/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ListExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ReadOnlyListWrapper<E>
extends SimpleListProperty<E> {
    private ReadOnlyPropertyImpl readOnlyProperty;

    public ReadOnlyListWrapper() {
    }

    public ReadOnlyListWrapper(ObservableList<E> observableList) {
        super(observableList);
    }

    public ReadOnlyListWrapper(Object object, String string) {
        super(object, string);
    }

    public ReadOnlyListWrapper(Object object, String string, ObservableList<E> observableList) {
        super(object, string, observableList);
    }

    public ReadOnlyListProperty<E> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImpl();
        }
        return this.readOnlyProperty;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.getReadOnlyProperty().addListener(invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(invalidationListener);
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableList<E>> changeListener) {
        this.getReadOnlyProperty().addListener(changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableList<E>> changeListener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(changeListener);
        }
    }

    @Override
    public void addListener(ListChangeListener<? super E> listChangeListener) {
        this.getReadOnlyProperty().addListener(listChangeListener);
    }

    @Override
    public void removeListener(ListChangeListener<? super E> listChangeListener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listChangeListener);
        }
    }

    @Override
    protected void fireValueChangedEvent() {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    @Override
    protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent(change);
        }
    }

    private class ReadOnlyPropertyImpl
    extends ReadOnlyListProperty<E> {
        private ListExpressionHelper<E> helper = null;

        private ReadOnlyPropertyImpl() {
        }

        @Override
        public ObservableList<E> get() {
            return ReadOnlyListWrapper.this.get();
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ListExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ListExpressionHelper.removeListener(this.helper, invalidationListener);
        }

        @Override
        public void addListener(ChangeListener<? super ObservableList<E>> changeListener) {
            this.helper = ListExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super ObservableList<E>> changeListener) {
            this.helper = ListExpressionHelper.removeListener(this.helper, changeListener);
        }

        @Override
        public void addListener(ListChangeListener<? super E> listChangeListener) {
            this.helper = ListExpressionHelper.addListener(this.helper, this, listChangeListener);
        }

        @Override
        public void removeListener(ListChangeListener<? super E> listChangeListener) {
            this.helper = ListExpressionHelper.removeListener(this.helper, listChangeListener);
        }

        private void fireValueChangedEvent() {
            ListExpressionHelper.fireValueChangedEvent(this.helper);
        }

        private void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
            ListExpressionHelper.fireValueChangedEvent(this.helper, change);
        }

        @Override
        public Object getBean() {
            return ReadOnlyListWrapper.this.getBean();
        }

        @Override
        public String getName() {
            return ReadOnlyListWrapper.this.getName();
        }

        @Override
        public ReadOnlyIntegerProperty sizeProperty() {
            return ReadOnlyListWrapper.this.sizeProperty();
        }

        @Override
        public ReadOnlyBooleanProperty emptyProperty() {
            return ReadOnlyListWrapper.this.emptyProperty();
        }
    }
}

