/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.Dependency;
import java.lang.reflect.Member;

public final class DependencyAndSource {
    private final Dependency<?> dependency;
    private final Object source;

    public DependencyAndSource(Dependency<?> dependency, Object source2) {
        this.dependency = dependency;
        this.source = source2;
    }

    public Dependency<?> getDependency() {
        return this.dependency;
    }

    public String getBindingSource() {
        if (this.source instanceof Class) {
            return StackTraceElements.forType((Class)this.source).toString();
        }
        if (this.source instanceof Member) {
            return StackTraceElements.forMember((Member)this.source).toString();
        }
        return this.source.toString();
    }

    public String toString() {
        Dependency<?> dep = this.getDependency();
        String source2 = this.getBindingSource();
        if (dep != null) {
            String string2 = String.valueOf(String.valueOf(dep));
            String string3 = String.valueOf(String.valueOf(source2));
            return new StringBuilder(22 + string2.length() + string3.length()).append("Dependency: ").append(string2).append(", source: ").append(string3).toString();
        }
        String string4 = String.valueOf(String.valueOf(source2));
        return new StringBuilder(8 + string4.length()).append("Source: ").append(string4).toString();
    }
}

