/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"


main (int argc, char *argv[])
{

	matrix_TYP **x, **S;
        bravais_TYP *G;
        int anz;

        extern char **FILENAMES;
        extern int FILEANZ;

        extern matrix_TYP **mget_mat();
        extern bravais_TYP *hyperbolic_stabilizer();

        read_header(argc, argv);
        if(FILEANZ != 2)
        {
           printf("usage:  hypstab 'file1' 'file2 ,\n");
           printf("where 'file1' contains an 1 by n matrix X.\n");
           printf("and   'file2' contains a set of n by n matrix S.\n");
           printf("of sylvester Typ (-1, n-1) s.t. xSx^{tr} < 0\n");
           if (is_option('h')){
              exit(0);
           }
           else{
              exit(31);
           }
        }
        x = mget_mat(FILENAMES[0], &anz);
        S = mget_mat(FILENAMES[1], &anz);
        G = hyperbolic_stabilizer(x[0], S[0]);
        put_bravais(G, NULL, "hyperbolic stabilizer");


   exit(0);
}
