/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: init_bravais.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ bravais_TYP *init_bravais(dim)
@ int dim;
@
@ returns a bravais_TYP 'B' with B->dim = dim
@ and all other pointers an integers in B are set to NULL resp. 0
@ and B->divisors[i] = 0 for 0<= i < 100
@---------------------------------------------------------------------------
@
\**************************************************************************/


bravais_TYP *init_bravais(dim)
int dim;
{
   int i;
   bravais_TYP *B;

   /* changed on 1/08/97 from malloc to calloc for paranoia reasons */
   if( (B = (bravais_TYP *)calloc(1,sizeof(bravais_TYP))) == NULL)
   {
     printf("malloc of 'B' in 'init_bravais' failed\n");
     exit(2);
   }
   B->dim = dim;
   for(i=0;i<100;i++)
     B->divisors[i] = 0;
   B->order = 0;
   B->gen_no = B->zentr_no = B->form_no = B->normal_no = B->cen_no = 0;
  B->gen = NULL;
  B->form = NULL;
  B->zentr = NULL;
  B->normal = NULL;
  B->cen = NULL;
  return(B);
}
