/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;

class FileIconKey {
    private final VirtualFile myFile;
    private final Project myProject;
    private final int myFlags;
    @Nullable
    private final Language myInitialLanguage;

    FileIconKey(@NotNull VirtualFile file2, Project project, int flags) {
        if (file2 == null) {
            FileIconKey.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
        this.myInitialLanguage = this.myFile instanceof LightVirtualFile ? ((LightVirtualFile)this.myFile).getLanguage() : null;
        this.myProject = project;
        this.myFlags = flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileIconKey)) {
            return false;
        }
        FileIconKey that = (FileIconKey)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        if (!this.myFile.equals(that.myFile)) {
            return false;
        }
        if (!Comparing.equal(this.myInitialLanguage, that.myInitialLanguage)) {
            return false;
        }
        return !(this.myProject != null ? !this.myProject.equals(that.myProject) : that.myProject != null);
    }

    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + (this.myProject != null ? this.myProject.hashCode() : 0);
        result2 = 31 * result2 + this.myFlags;
        return result2;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    public int getFlags() {
        return this.myFlags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/FileIconKey", "<init>"));
    }
}

