/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultExceptionAnalyser;
import org.gradle.initialization.MultipleBuildFailuresExceptionAnalyser;
import org.gradle.initialization.ReportedException;
import org.gradle.initialization.StackTraceSanitizingExceptionAnalyser;
import org.gradle.internal.buildevents.BuildLogger;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;
import org.gradle.tooling.internal.provider.ServicesSetupBuildActionExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFailureReportingActionExecuter
implements BuildExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFailureReportingActionExecuter.class);
    private final BuildExecuter delegate;
    private final StyledTextOutputFactory styledTextOutputFactory;
    private final Clock clock;

    public SessionFailureReportingActionExecuter(BuildExecuter delegate, StyledTextOutputFactory styledTextOutputFactory, Clock clock) {
        this.delegate = delegate;
        this.styledTextOutputFactory = styledTextOutputFactory;
        this.clock = clock;
    }

    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        try {
            return this.delegate.execute(action, requestContext, actionParameters, contextServices);
        }
        catch (ReportedException e) {
            throw e;
        }
        catch (Throwable e) {
            MultipleBuildFailuresExceptionAnalyser exceptionAnalyser = new MultipleBuildFailuresExceptionAnalyser((ExceptionAnalyser)new DefaultExceptionAnalyser((ListenerManager)new DefaultListenerManager()));
            if (action.getStartParameter().getShowStacktrace() != ShowStacktrace.ALWAYS_FULL) {
                exceptionAnalyser = new StackTraceSanitizingExceptionAnalyser((ExceptionAnalyser)exceptionAnalyser);
            }
            Throwable failure = e;
            try {
                failure = exceptionAnalyser.transform(e);
            }
            catch (Throwable innerFailure) {
                LOGGER.error("Failed to analyze exception", innerFailure);
            }
            BuildStartedTime buildStartedTime = BuildStartedTime.startingAt((long)requestContext.getStartTime());
            BuildLogger buildLogger = new BuildLogger(Logging.getLogger(ServicesSetupBuildActionExecuter.class), this.styledTextOutputFactory, (StartParameter)action.getStartParameter(), (BuildRequestMetaData)requestContext, buildStartedTime, this.clock);
            buildLogger.buildFinished(new BuildResult(null, failure));
            throw new ReportedException(failure);
        }
    }
}

