/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.type;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.IoActions;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.type.SignatureType;

public abstract class AbstractSignatureType
implements SignatureType {
    @Override
    public File sign(final Signatory signatory, File toSign) {
        final File signatureFile = this.fileFor(toSign);
        try {
            IoActions.withResource((Closeable)ResourceGroovyMethods.newInputStream((File)toSign), (Action)new Action<InputStream>(){

                public void execute(final InputStream toSignStream) {
                    try {
                        IoActions.withResource((Closeable)ResourceGroovyMethods.newOutputStream((File)signatureFile), (Action)new Action<BufferedOutputStream>(){

                            public void execute(BufferedOutputStream signatureFileStream) {
                                AbstractSignatureType.this.sign(signatory, toSignStream, signatureFileStream);
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
            });
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return signatureFile;
    }

    @Override
    public void sign(Signatory signatory, InputStream toSign, OutputStream destination) {
        signatory.sign(toSign, destination);
    }

    @Override
    public File fileFor(File toSign) {
        return new File(toSign.getPath() + "." + this.getExtension());
    }

    @Override
    public String combinedExtension(File toSign) {
        String name = toSign.getName();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex + 1 == name.length()) {
            return this.getExtension();
        }
        return name.substring(dotIndex + 1) + "." + this.getExtension();
    }
}

