/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.TransferResource;

abstract class AbstractChecksumPolicy
implements ChecksumPolicy {
    protected final Logger logger;
    protected final TransferResource resource;

    protected AbstractChecksumPolicy(LoggerFactory loggerFactory, TransferResource resource) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        this.resource = resource;
    }

    public boolean onChecksumMatch(String algorithm, int kind) {
        return true;
    }

    public void onChecksumMismatch(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        if ((kind & 1) == 0) {
            throw exception;
        }
    }

    public void onChecksumError(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        this.logger.debug("Could not validate " + algorithm + " checksum for " + this.resource.getResourceName(), (Throwable)exception);
    }

    public void onNoMoreChecksums() throws ChecksumFailureException {
        throw new ChecksumFailureException("Checksum validation failed, no checksums available");
    }

    public void onTransferRetry() {
    }
}

