#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: options
version: 1.2.1.1
id: options-1.2.1.1-8yUchvvR2SaHY7Vem0H7pL
key: options-1.2.1.1-8yUchvvR2SaHY7Vem0H7pL
license: MIT
maintainer: John Millikin <john@john-millikin.com>
author: John Millikin <john@john-millikin.com>
stability: stable
homepage: https://john-millikin.com/software/haskell-options/
synopsis: A powerful and easy-to-use command-line option parser.
description:
    The @options@ package lets library and application developers easily work
    with command-line options.
    .
    The following example is a full program that can accept two options,
    @--message@ and @--quiet@:
    .
    @
    import Control.Applicative
    import Options
    .
    data MainOptions = MainOptions
    &#x20;   &#x7b; optMessage :: String
    &#x20;   , optQuiet :: Bool
    &#x20;   &#x7d;
    .
    instance '\''Options'\'' MainOptions where
    &#x20;   defineOptions = pure MainOptions
    &#x20;       \<*\> simpleOption \"message\" \"Hello world!\"
    &#x20;           \"A message to show the user.\"
    &#x20;       \<*\> simpleOption \"quiet\" False
    &#x20;           \"Whether to be quiet.\"
    .
    main :: IO ()
    main = runCommand $ \\opts args -> do
    &#x20;   if optQuiet opts
    &#x20;       then return ()
    &#x20;       else putStrLn (optMessage opts)
    @
    .
    >$ ./hello
    >Hello world!
    >$ ./hello --message='\''ciao mondo'\''
    >ciao mondo
    >$ ./hello --quiet
    >$
    .
    In addition, this library will automatically create documentation options
    such as @--help@ and @--help-all@:
    .
    >$ ./hello --help
    >Help Options:
    >  -h, --help
    >    Show option summary.
    >  --help-all
    >    Show all help options.
    >
    >Application Options:
    >  --message :: text
    >    A message to show the user.
    >    default: "Hello world!"
    >  --quiet :: bool
    >    Whether to be quiet.
    >    default: false
category: Console
abi: 8f66bcbc8745db89acf1b240db0c7001
exposed: True
exposed-modules:
    Options
hidden-modules: Options.Help Options.Tokenize Options.Types
                Options.Util
import-dirs: /usr/lib/ghc-8.4.3/site-local/options-1.2.1.1
library-dirs: /usr/lib/ghc-8.4.3/site-local/options-1.2.1.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/options-1.2.1.1
hs-libraries: HSoptions-1.2.1.1-8yUchvvR2SaHY7Vem0H7pL
depends:
    base-4.11.1.0 containers-0.5.11.0
    monads-tf-0.1.0.3-Giaow1Z3bgu7ae1ewXz7xU transformers-0.5.5.0
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             monads-tf-0.1.0.3-Giaow1Z3bgu7ae1ewXz7xU=186b425acb38e926ddf66c94a3c8e5aa
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
haddock-interfaces: /usr/share/doc/haskell-options/html/options.haddock
haddock-html: /usr/share/doc/haskell-options/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

