/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.bits;

import edu.berkeley.nlp.lm.bits.BitList;
import edu.berkeley.nlp.lm.bits.BitStream;

public class CompressionUtils {
    public static BitList variableCompress(long n, int radix) {
        int numBits = CompressionUtils.getNumBits(n);
        int bitsPerDigit = radix - 1;
        int numDigits = CompressionUtils.getNumDigits(numBits, bitsPerDigit);
        BitList bits = CompressionUtils.writeUnary(numDigits);
        int numBitsToOutput = numDigits * bitsPerDigit;
        CompressionUtils.writeNormalBinary(n, bits, numBitsToOutput);
        assert (bits.size() < 64);
        return bits;
    }

    public static long variableDecompress(BitStream input, int radix) {
        int numBitsInDigit = radix - 1;
        int numDigits = CompressionUtils.readUnary(input);
        long nextBits = input.next(numBitsInDigit * numDigits);
        return nextBits;
    }

    private static int readUnary(BitStream input) {
        return input.nextConsecutiveZeros();
    }

    private static void writeNormalBinary(long n, BitList bits, int numBitsToOutput) {
        long mask = 1L << numBitsToOutput - 1;
        for (int i = 0; i < numBitsToOutput; ++i) {
            bits.add((n & mask) != 0L);
            mask >>>= 1;
        }
    }

    private static BitList writeUnary(int numDigits) {
        BitList bits = new BitList();
        for (int i = 0; i < numDigits; ++i) {
            bits.add(i == numDigits - 1);
        }
        return bits;
    }

    private static int getNumBits(long delta) {
        return 64 - Long.numberOfLeadingZeros(delta);
    }

    private static int getNumDigits(int numBits, int bitsPerDigit) {
        int numDigits = numBits / bitsPerDigit + (numBits % bitsPerDigit == 0 ? 0 : 1);
        numDigits = Math.max(1, numDigits);
        return numDigits;
    }
}

