/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.embed.EmbeddedSceneDragSourceInterface;
import com.sun.javafx.embed.EmbeddedSceneDragStartListenerInterface;
import com.sun.javafx.embed.EmbeddedSceneDropTargetInterface;
import com.sun.javafx.tk.quantum.EmbeddedSceneDragSource;
import com.sun.javafx.tk.quantum.EmbeddedSceneDropTarget;
import com.sun.javafx.tk.quantum.FxEventLoop;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDnD {
    private final GlassSceneDnDEventHandler dndHandler;
    private EmbeddedSceneDragStartListenerInterface dragStartListener;
    private EmbeddedSceneDragSourceInterface fxDragSource;
    private EmbeddedSceneDropTargetInterface fxDropTarget;
    private ClipboardAssistance clipboardAssistant;
    private Thread hostThread;

    public EmbeddedSceneDnD(GlassScene glassScene) {
        this.dndHandler = new GlassSceneDnDEventHandler(glassScene, null);
    }

    private void startDrag() {
        assert (Platform.isFxApplicationThread());
        assert (this.fxDragSource == null);
        this.fxDragSource = new EmbeddedSceneDragSource(this, this.dndHandler);
        TransferMode transferMode = TransferMode.COPY;
        this.dragStartListener.dragStarted(this.fxDragSource, transferMode);
    }

    private void setHostThread() {
        if (this.hostThread == null) {
            this.hostThread = Thread.currentThread();
        }
    }

    public boolean isHostThread() {
        return Thread.currentThread() == this.hostThread;
    }

    public boolean isValid(EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface) {
        assert (Platform.isFxApplicationThread());
        assert (embeddedSceneDragSourceInterface != null);
        assert (this.fxDragSource == embeddedSceneDragSourceInterface);
        assert (this.clipboardAssistant != null);
        return true;
    }

    public boolean isValid(EmbeddedSceneDropTargetInterface embeddedSceneDropTargetInterface) {
        assert (Platform.isFxApplicationThread());
        assert (embeddedSceneDropTargetInterface != null);
        assert (this.fxDropTarget == embeddedSceneDropTargetInterface);
        return true;
    }

    public boolean isFxDragSource() {
        assert (Platform.isFxApplicationThread());
        return this.fxDragSource != null;
    }

    public void onDragSourceReleased(EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface) {
        assert (this.isValid(embeddedSceneDragSourceInterface));
        this.fxDragSource = null;
        this.clipboardAssistant = null;
        FxEventLoop.leaveNestedLoop();
    }

    public void onDropTargetReleased(EmbeddedSceneDropTargetInterface embeddedSceneDropTargetInterface) {
        assert (this.isValid(embeddedSceneDropTargetInterface));
        this.fxDropTarget = null;
        if (!this.isFxDragSource()) {
            this.clipboardAssistant = null;
        }
    }

    public Dragboard createDragboard() {
        assert (Platform.isFxApplicationThread());
        assert (this.fxDropTarget == null);
        assert (this.clipboardAssistant == null);
        assert (this.fxDragSource == null);
        this.clipboardAssistant = new ClipboardAssistanceImpl(null);
        return GlassSceneDnDEventHandler.createDragboard(this.clipboardAssistant);
    }

    public void setDragStartListener(EmbeddedSceneDragStartListenerInterface embeddedSceneDragStartListenerInterface) {
        this.setHostThread();
        assert (this.isHostThread());
        this.dragStartListener = embeddedSceneDragStartListenerInterface;
    }

    public EmbeddedSceneDropTargetInterface createDropTarget() {
        this.setHostThread();
        assert (this.isHostThread());
        assert (this.fxDropTarget == null);
        return FxEventLoop.sendEvent(new Callable<EmbeddedSceneDropTargetInterface>(){

            @Override
            public EmbeddedSceneDropTargetInterface call() {
                EmbeddedSceneDnD.this.fxDropTarget = new EmbeddedSceneDropTarget(EmbeddedSceneDnD.this, EmbeddedSceneDnD.this.dndHandler);
                return EmbeddedSceneDnD.this.fxDropTarget;
            }
        });
    }

    public ClipboardAssistance getClipboardAssistance(EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface) {
        assert (Platform.isFxApplicationThread());
        assert (!this.isFxDragSource() || this.isValid(embeddedSceneDragSourceInterface));
        assert (!this.isFxDragSource() || this.clipboardAssistant != null);
        if (this.clipboardAssistant == null) {
            this.clipboardAssistant = new ClipboardAssistanceImpl(embeddedSceneDragSourceInterface);
        }
        return this.clipboardAssistant;
    }

    private class ClipboardAssistanceImpl
    extends ClipboardAssistance {
        final EmbeddedSceneDragSourceInterface source;

        private boolean isValid() {
            assert (Platform.isFxApplicationThread());
            assert (EmbeddedSceneDnD.this.clipboardAssistant == this);
            return true;
        }

        ClipboardAssistanceImpl(EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface) {
            super("DND-Embedded");
            this.source = embeddedSceneDragSourceInterface;
        }

        @Override
        public void flush() {
            assert (this.isValid());
            super.flush();
            EmbeddedSceneDnD.this.startDrag();
            FxEventLoop.enterNestedLoop();
        }

        @Override
        public void emptyCache() {
            assert (this.isValid());
            super.emptyCache();
        }

        @Override
        public Object getData(String string) {
            assert (this.isValid());
            if (this.source == null) {
                return super.getData(string);
            }
            return this.source.getData(string);
        }

        @Override
        public void setData(String string, Object object) {
            assert (this.isValid());
            if (this.source != null) {
                return;
            }
            super.setData(string, object);
        }

        @Override
        public void setSupportedActions(int n) {
            assert (this.isValid());
            if (this.source != null) {
                return;
            }
            super.setSupportedActions(n);
        }

        @Override
        public int getSupportedSourceActions() {
            assert (this.isValid());
            if (this.source == null) {
                return super.getSupportedSourceActions();
            }
            return QuantumClipboard.transferModesToClipboardActions(this.source.getSupportedActions());
        }

        @Override
        public void setTargetAction(int n) {
            assert (this.isValid());
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getMimeTypes() {
            assert (this.isValid());
            if (this.source == null) {
                return super.getMimeTypes();
            }
            return this.source.getMimeTypes();
        }
    }
}

