/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.process.NativeController;
import org.elasticsearch.xpack.ml.job.process.ProcessCtrl;
import org.elasticsearch.xpack.ml.job.process.ProcessPipes;
import org.elasticsearch.xpack.ml.job.process.normalizer.NativeNormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativeNormalizerProcessFactory
implements NormalizerProcessFactory {
    private static final Logger LOGGER = Loggers.getLogger(NativeNormalizerProcessFactory.class);
    private static final NamedPipeHelper NAMED_PIPE_HELPER = new NamedPipeHelper();
    private static final Duration PROCESS_STARTUP_TIMEOUT = Duration.ofSeconds(10L);
    private final Environment env;
    private final Settings settings;
    private final NativeController nativeController;

    public NativeNormalizerProcessFactory(Environment env, Settings settings, NativeController nativeController) {
        this.env = Objects.requireNonNull(env);
        this.settings = Objects.requireNonNull(settings);
        this.nativeController = Objects.requireNonNull(nativeController);
    }

    @Override
    public NormalizerProcess createNormalizerProcess(String jobId, String quantilesState, Integer bucketSpan, boolean perPartitionNormalization, ExecutorService executorService) {
        ProcessPipes processPipes = new ProcessPipes(this.env, NAMED_PIPE_HELPER, "normalize", jobId, true, false, true, true, false, false);
        this.createNativeProcess(jobId, quantilesState, processPipes, bucketSpan, perPartitionNormalization);
        return new NativeNormalizerProcess(jobId, this.settings, processPipes.getLogStream().get(), processPipes.getProcessInStream().get(), processPipes.getProcessOutStream().get(), executorService);
    }

    private void createNativeProcess(String jobId, String quantilesState, ProcessPipes processPipes, Integer bucketSpan, boolean perPartitionNormalization) {
        try {
            List<String> command = ProcessCtrl.buildNormalizerCommand(this.env, jobId, quantilesState, bucketSpan, perPartitionNormalization);
            processPipes.addArgs(command);
            this.nativeController.startProcess(command);
            processPipes.connectStreams(PROCESS_STARTUP_TIMEOUT);
        }
        catch (IOException e) {
            String msg = "Failed to launch normalizer for job " + jobId;
            LOGGER.error(msg);
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
    }
}

