/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.HashMap;
import java.util.Map;

public class StatsAccumulator {
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String AVG = "avg";
    private static final String TOTAL = "total";
    private long count;
    private double total;
    private Double min;
    private Double max;

    public void add(double value) {
        ++this.count;
        this.total += value;
        this.min = this.min == null ? value : (value < this.min ? value : this.min);
        this.max = this.max == null ? value : (value > this.max ? value : this.max);
    }

    public double getMin() {
        return this.min == null ? 0.0 : this.min;
    }

    public double getMax() {
        return this.max == null ? 0.0 : this.max;
    }

    public double getAvg() {
        return (double)this.count == 0.0 ? 0.0 : this.total / (double)this.count;
    }

    public double getTotal() {
        return this.total;
    }

    public Map<String, Double> asMap() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put(MIN, this.getMin());
        map.put(MAX, this.getMax());
        map.put(AVG, this.getAvg());
        map.put(TOTAL, this.getTotal());
        return map;
    }
}

