/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;

final class BigFloatArray
extends AbstractBigArray
implements FloatArray {
    private static final BigFloatArray ESTIMATOR = new BigFloatArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    private int[][] pages;

    BigFloatArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(4096, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new int[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newIntPage(i);
        }
    }

    @Override
    public float set(long index, float value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] page = this.pages[pageIndex];
        float ret = Float.intBitsToFloat(page[indexInPage]);
        page[indexInPage] = Float.floatToRawIntBits(value);
        return ret;
    }

    @Override
    public float increment(long index, float inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] page = this.pages[pageIndex];
        page[indexInPage] = Float.floatToRawIntBits(Float.intBitsToFloat(page[indexInPage]) + inc);
        return page[indexInPage];
    }

    @Override
    public float get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return Float.intBitsToFloat(this.pages[pageIndex][indexInPage]);
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (int[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newIntPage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, float value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int intBits = Float.floatToRawIntBits(value);
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, intBits);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, intBits);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], intBits);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, intBits);
        }
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }
}

