/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.script;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.Params;
import org.elasticsearch.xpack.sql.type.DataType;

public class ScriptTemplate {
    public static final ScriptTemplate EMPTY = new ScriptTemplate("");
    private final String template;
    private final Params params;
    private final DataType outputType;

    public ScriptTemplate(String template) {
        this(template, Params.EMPTY, DataType.KEYWORD);
    }

    public ScriptTemplate(String template, Params params, DataType outputType) {
        this.template = template;
        this.params = params;
        this.outputType = outputType;
    }

    public String template() {
        return this.template;
    }

    public Params params() {
        return this.params;
    }

    public List<String> aggRefs() {
        return this.params.asAggRefs();
    }

    public Map<String, String> aggPaths() {
        return this.params.asAggPaths();
    }

    public DataType outputType() {
        return this.outputType;
    }

    public Script toPainless() {
        return new Script(ScriptType.INLINE, "painless", this.bindTemplate(), this.params.asParams());
    }

    private String bindTemplate() {
        List<String> binding = this.params.asCodeNames();
        return binding.isEmpty() ? this.template : String.format(Locale.ROOT, this.template, binding.toArray());
    }

    public int hashCode() {
        return Objects.hash(this.template, this.params, this.outputType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptTemplate other = (ScriptTemplate)obj;
        return Objects.equals(this.template, other.template) && Objects.equals(this.params, other.params) && Objects.equals(this.outputType, other.outputType);
    }

    public String toString() {
        return this.bindTemplate();
    }

    public static String formatTemplate(String template) {
        return template.replace("{}", "params.%s");
    }
}

