/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;

public class DateEsField
extends EsField {
    public static final List<String> DEFAULT_FORMAT = Arrays.asList("strict_date_optional_time", "epoch_millis");
    private final List<String> formats;

    public DateEsField(String name, Map<String, EsField> properties, boolean hasDocValues, String ... formats) {
        super(name, DataType.DATE, properties, hasDocValues);
        this.formats = CollectionUtils.isEmpty((Object[])formats) ? DEFAULT_FORMAT : Arrays.asList(formats);
    }

    @Override
    public int getPrecision() {
        return 19;
    }

    public List<String> getFormats() {
        return this.formats;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateEsField dateField = (DateEsField)o;
        return Objects.equals(this.formats, dateField.formats);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.formats);
    }
}

