/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.sort.SortOrder;

class CompositeValuesSourceConfig {
    private final String name;
    @Nullable
    private final MappedFieldType fieldType;
    private final ValuesSource vs;
    private final DocValueFormat format;
    private final int reverseMul;
    private final Object missing;

    CompositeValuesSourceConfig(String name, @Nullable MappedFieldType fieldType, ValuesSource vs, DocValueFormat format, SortOrder order, @Nullable Object missing) {
        this.name = name;
        this.fieldType = fieldType;
        this.vs = vs;
        this.format = format;
        this.reverseMul = order == SortOrder.ASC ? 1 : -1;
        this.missing = missing;
    }

    String name() {
        return this.name;
    }

    MappedFieldType fieldType() {
        return this.fieldType;
    }

    ValuesSource valuesSource() {
        return this.vs;
    }

    DocValueFormat format() {
        return this.format;
    }

    Object missing() {
        return this.missing;
    }

    int reverseMul() {
        assert (this.reverseMul == -1 || this.reverseMul == 1);
        return this.reverseMul;
    }
}

