/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTriggerEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ManualExecutionContext
extends WatchExecutionContext {
    private final Map<String, ActionExecutionMode> actionModes;
    private final boolean recordExecution;
    private final boolean knownWatch;
    private final Watch watch;

    ManualExecutionContext(Watch watch, boolean knownWatch, DateTime executionTime, ManualTriggerEvent triggerEvent, TimeValue defaultThrottlePeriod, Input.Result inputResult, Condition.Result conditionResult, Map<String, ActionExecutionMode> actionModes, boolean recordExecution) {
        super(watch.id(), executionTime, (TriggerEvent)triggerEvent, defaultThrottlePeriod);
        ActionExecutionMode allMode;
        this.actionModes = actionModes;
        this.recordExecution = recordExecution;
        this.knownWatch = knownWatch;
        this.watch = watch;
        if (inputResult != null) {
            this.onInputResult(inputResult);
        }
        if (conditionResult != null) {
            this.onConditionResult(conditionResult);
        }
        if ((allMode = actionModes.get("_all")) == null || allMode == ActionExecutionMode.SKIP) {
            boolean throttleAll = allMode == ActionExecutionMode.SKIP;
            for (ActionWrapper action : watch.actions()) {
                if (throttleAll) {
                    this.onActionResult(new ActionWrapperResult(action.id(), (Action.Result)new Action.Result.Throttled(action.action().type(), "manually skipped")));
                    continue;
                }
                ActionExecutionMode mode = actionModes.get(action.id());
                if (mode != ActionExecutionMode.SKIP) continue;
                this.onActionResult(new ActionWrapperResult(action.id(), (Action.Result)new Action.Result.Throttled(action.action().type(), "manually skipped")));
            }
        }
    }

    public void ensureWatchExists(CheckedSupplier<Watch, Exception> supplier) throws Exception {
        super.ensureWatchExists(() -> this.watch);
    }

    public boolean knownWatch() {
        return this.knownWatch;
    }

    public final boolean simulateAction(String actionId) {
        ActionExecutionMode mode = this.actionModes.get("_all");
        if (mode == null) {
            mode = this.actionModes.get(actionId);
        }
        return mode != null && mode.simulate();
    }

    public boolean skipThrottling(String actionId) {
        ActionExecutionMode mode = this.actionModes.get("_all");
        if (mode == null) {
            mode = this.actionModes.get(actionId);
        }
        return mode != null && mode.force();
    }

    public boolean shouldBeExecuted() {
        return true;
    }

    public final boolean recordExecution() {
        return this.recordExecution;
    }

    public Watch watch() {
        return this.watch;
    }

    public static Builder builder(Watch watch, boolean knownWatch, ManualTriggerEvent event, TimeValue defaultThrottlePeriod) {
        return new Builder(watch, knownWatch, event, defaultThrottlePeriod);
    }

    public static class Builder {
        static final String ALL = "_all";
        private final Watch watch;
        private final boolean knownWatch;
        private final ManualTriggerEvent triggerEvent;
        private final TimeValue defaultThrottlePeriod;
        protected DateTime executionTime;
        private boolean recordExecution = false;
        private Map<String, ActionExecutionMode> actionModes = new HashMap<String, ActionExecutionMode>();
        private Input.Result inputResult;
        private Condition.Result conditionResult;

        private Builder(Watch watch, boolean knownWatch, ManualTriggerEvent triggerEvent, TimeValue defaultThrottlePeriod) {
            this.watch = watch;
            this.knownWatch = knownWatch;
            assert (triggerEvent != null);
            this.triggerEvent = triggerEvent;
            this.defaultThrottlePeriod = defaultThrottlePeriod;
        }

        public Builder executionTime(DateTime executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public Builder recordExecution(boolean recordExecution) {
            this.recordExecution = recordExecution;
            return this;
        }

        public Builder allActionsMode(ActionExecutionMode mode) {
            return this.actionMode(ALL, mode);
        }

        public Builder actionMode(String id, ActionExecutionMode mode) {
            if (this.actionModes == null) {
                throw new IllegalStateException("ManualExecutionContext has already been built!");
            }
            if (ALL.equals(id)) {
                this.actionModes = new HashMap<String, ActionExecutionMode>();
            }
            this.actionModes.put(id, mode);
            return this;
        }

        public Builder withInput(Input.Result inputResult) {
            this.inputResult = inputResult;
            return this;
        }

        public Builder withCondition(Condition.Result conditionResult) {
            this.conditionResult = conditionResult;
            return this;
        }

        public ManualExecutionContext build() {
            if (this.executionTime == null) {
                this.executionTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
            }
            ManualExecutionContext context = new ManualExecutionContext(this.watch, this.knownWatch, this.executionTime, this.triggerEvent, this.defaultThrottlePeriod, this.inputResult, this.conditionResult, Collections.unmodifiableMap(this.actionModes), this.recordExecution);
            this.actionModes = null;
            return context;
        }
    }
}

