/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.invocation.Gradle;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.kotlin.dsl.accessors.AccessorsClassPathKt;
import org.gradle.kotlin.dsl.execution.EvalOption;
import org.gradle.kotlin.dsl.execution.EvalOptionKt;
import org.gradle.kotlin.dsl.execution.ExecutableProgram;
import org.gradle.kotlin.dsl.execution.Interpreter$WhenMappings;
import org.gradle.kotlin.dsl.execution.InterpreterKt;
import org.gradle.kotlin.dsl.execution.PartialEvaluator;
import org.gradle.kotlin.dsl.execution.Program;
import org.gradle.kotlin.dsl.execution.ProgramId;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramParser;
import org.gradle.kotlin.dsl.execution.ProgramSource;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.execution.ResidualProgram;
import org.gradle.kotlin.dsl.execution.ResidualProgramCompiler;
import org.gradle.kotlin.dsl.support.GradleExtensionsKt;
import org.gradle.kotlin.dsl.support.KotlinScriptHost;
import org.gradle.kotlin.dsl.support.ProjectExtensionsKt;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.gradle.kotlin.dsl.support.SettingsExtensionsKt;
import org.gradle.plugin.management.internal.PluginRequests;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003:;<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JL\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JR\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020#0\"j\u0002`$J>\u0010%\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010,\u001a\u00060\u0006R\u00020\u00002\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020#0\"j\u0002`$H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0001H\u0002J0\u0010.\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J>\u00102\u001a\b\u0012\u0004\u0012\u00020\u0001032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u00104\u001a\u0002052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0001H\u0002J\u0010\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020(H\u0002J\u0018\u00108\u001a\u0002092\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0010H\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006="}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter;", "", "host", "Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;)V", "defaultProgramHost", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "getHost", "()Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "emitSpecializedProgramFor", "Ljava/lang/Class;", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "templateId", "", "parentClassLoader", "Ljava/lang/ClassLoader;", "targetScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "baseScope", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "eval", "", "target", "scriptHandler", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "topLevelScript", "", "options", "Ljava/util/EnumSet;", "Lorg/gradle/kotlin/dsl/execution/EvalOption;", "Lorg/gradle/kotlin/dsl/execution/EvalOptions;", "loadClassInChildScopeOf", "scriptPath", "classesDir", "Ljava/io/File;", "scriptTemplateId", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "programHostFor", "programTargetFor", "residualProgramCompilerFor", "Lorg/gradle/kotlin/dsl/execution/ResidualProgramCompiler;", "outputDir", "classLoaderScopeForClassPath", "scriptHostFor", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "serviceRegistryFor", "Lorg/gradle/internal/service/ServiceRegistry;", "stage1SubDirOf", "cachedDir", "startCompilerOperationFor", "Ljava/lang/AutoCloseable;", "FirstStageOnlyProgramHost", "Host", "ProgramHost", "gradle-kotlin-dsl"})
public final class Interpreter {
    private final ProgramHost defaultProgramHost;
    @NotNull
    private final Host host;

    public final void eval(@NotNull Object target, @NotNull ScriptSource scriptSource, @NotNull HashCode sourceHash, @NotNull ScriptHandler scriptHandler, @NotNull ClassLoaderScope targetScope, @NotNull ClassLoaderScope baseScope, boolean topLevelScript, @NotNull EnumSet<EvalOption> options) {
        ClassLoader parentClassLoader;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
        Intrinsics.checkParameterIsNotNull((Object)scriptHandler, (String)"scriptHandler");
        Intrinsics.checkParameterIsNotNull((Object)targetScope, (String)"targetScope");
        Intrinsics.checkParameterIsNotNull((Object)baseScope, (String)"baseScope");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        ProgramKind programKind = topLevelScript ? ProgramKind.TopLevel : ProgramKind.ScriptPlugin;
        ProgramTarget programTarget = this.programTargetFor(target);
        String templateId = InterpreterKt.templateIdFor(programTarget, programKind, "stage1");
        ClassLoader classLoader = parentClassLoader = baseScope.getExportClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"parentClassLoader");
        ProgramId programId = new ProgramId(templateId, sourceHash, classLoader, null, 8, null);
        Class<?> cachedProgram = this.host.cachedClassFor(programId);
        KotlinScriptHost<Object> scriptHost = this.scriptHostFor(programTarget, target, scriptSource, scriptHandler, targetScope, baseScope);
        ProgramHost programHost = this.programHostFor(options);
        if (cachedProgram != null) {
            programHost.eval(cachedProgram, scriptHost);
            return;
        }
        Class<?> specializedProgram = this.emitSpecializedProgramFor(scriptSource, sourceHash, templateId, parentClassLoader, targetScope, baseScope, programKind, programTarget);
        this.host.cache(specializedProgram, programId);
        programHost.eval(specializedProgram, scriptHost);
    }

    public static /* bridge */ /* synthetic */ void eval$default(Interpreter interpreter2, Object object, ScriptSource scriptSource, HashCode hashCode, ScriptHandler scriptHandler, ClassLoaderScope classLoaderScope, ClassLoaderScope classLoaderScope2, boolean bl, EnumSet enumSet, int n, Object object2) {
        if ((n & 0x80) != 0) {
            enumSet = EvalOptionKt.getDefaultEvalOptions();
        }
        interpreter2.eval(object, scriptSource, hashCode, scriptHandler, classLoaderScope, classLoaderScope2, bl, enumSet);
    }

    private final ProgramTarget programTargetFor(Object target) {
        ProgramTarget programTarget;
        Object object = target;
        if (object instanceof Settings) {
            programTarget = ProgramTarget.Settings;
        } else if (object instanceof Project) {
            programTarget = ProgramTarget.Project;
        } else if (object instanceof Gradle) {
            programTarget = ProgramTarget.Gradle;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported target: " + target);
        }
        return programTarget;
    }

    private final KotlinScriptHost<Object> scriptHostFor(ProgramTarget programTarget, Object target, ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope) {
        return new KotlinScriptHost<Object>(target, scriptSource, scriptHandler, targetScope, baseScope, this.serviceRegistryFor(programTarget, target));
    }

    private final ProgramHost programHostFor(EnumSet<EvalOption> options) {
        return options.contains((Object)EvalOption.SkipBody) ? (ProgramHost)new FirstStageOnlyProgramHost() : this.defaultProgramHost;
    }

    private final ServiceRegistry serviceRegistryFor(ProgramTarget programTarget, Object target) {
        ServiceRegistry serviceRegistry;
        switch (Interpreter$WhenMappings.$EnumSwitchMapping$0[programTarget.ordinal()]) {
            case 1: {
                Object object = target;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.Project");
                }
                ServiceRegistry serviceRegistry2 = ProjectExtensionsKt.serviceRegistryOf((Project)object);
                serviceRegistry = serviceRegistry2;
                Intrinsics.checkExpressionValueIsNotNull((Object)serviceRegistry2, (String)"serviceRegistryOf(target as Project)");
                break;
            }
            case 2: {
                Object object = target;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.initialization.Settings");
                }
                ServiceRegistry serviceRegistry3 = SettingsExtensionsKt.serviceRegistryOf((Settings)object);
                serviceRegistry = serviceRegistry3;
                Intrinsics.checkExpressionValueIsNotNull((Object)serviceRegistry3, (String)"serviceRegistryOf(target as Settings)");
                break;
            }
            case 3: {
                Object object = target;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.invocation.Gradle");
                }
                ServiceRegistry serviceRegistry4 = GradleExtensionsKt.serviceRegistryOf((Gradle)object);
                serviceRegistry = serviceRegistry4;
                Intrinsics.checkExpressionValueIsNotNull((Object)serviceRegistry4, (String)"serviceRegistryOf(target as Gradle)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return serviceRegistry;
    }

    private final Class<?> emitSpecializedProgramFor(ScriptSource scriptSource, HashCode sourceHash, String templateId, ClassLoader parentClassLoader, ClassLoaderScope targetScope, ClassLoaderScope baseScope, ProgramKind programKind, ProgramTarget programTarget) {
        String string = scriptSource.getFileName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String scriptPath = string;
        File cachedDir2 = this.host.cachedDirFor(templateId, sourceHash, parentClassLoader, null, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this, scriptSource, templateId, scriptPath, programKind, programTarget, sourceHash, targetScope){
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ ScriptSource $scriptSource;
            final /* synthetic */ String $templateId;
            final /* synthetic */ String $scriptPath;
            final /* synthetic */ ProgramKind $programKind;
            final /* synthetic */ ProgramTarget $programTarget;
            final /* synthetic */ HashCode $sourceHash;
            final /* synthetic */ ClassLoaderScope $targetScope;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull File cachedDir2) {
                Intrinsics.checkParameterIsNotNull((Object)cachedDir2, (String)"cachedDir");
                AutoCloseable autoCloseable = Interpreter.access$startCompilerOperationFor(this.this$0, this.$scriptSource, this.$templateId);
                Throwable throwable = null;
                try {
                    String sourceText;
                    File file;
                    AutoCloseable it = autoCloseable;
                    File $receiver = file = Interpreter.access$stage1SubDirOf(this.this$0, cachedDir2);
                    $receiver.mkdir();
                    File outputDir = file;
                    TextResource textResource = this.$scriptSource.getResource();
                    if (textResource == null) {
                        Intrinsics.throwNpe();
                    }
                    String string = sourceText = textResource.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceText");
                    ProgramSource programSource = new ProgramSource(this.$scriptPath, string);
                    Program program2 = ProgramParser.INSTANCE.parse(programSource, this.$programKind, this.$programTarget);
                    ResidualProgram residualProgram = new PartialEvaluator(this.$programKind, this.$programTarget).reduce(program2);
                    ScriptSource $receiver$iv = this.$scriptSource;
                    try {
                        ClassLoaderScope classLoaderScope = this.$targetScope.getParent();
                        Intrinsics.checkExpressionValueIsNotNull((Object)classLoaderScope, (String)"targetScope.parent");
                        Interpreter.access$residualProgramCompilerFor(this.this$0, this.$sourceHash, outputDir, classLoaderScope, this.$programKind, this.$programTarget).compile(residualProgram);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (ScriptCompilationException e$iv) {
                        throw (Throwable)new LocationAwareException((Throwable)e$iv, $receiver$iv, e$iv.getFirstErrorLine());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = interpreter2;
                this.$scriptSource = scriptSource;
                this.$templateId = string;
                this.$scriptPath = string2;
                this.$programKind = programKind;
                this.$programTarget = programTarget;
                this.$sourceHash = hashCode;
                this.$targetScope = classLoaderScope;
                super(1);
            }
        }));
        File classesDir = this.stage1SubDirOf(cachedDir2);
        return this.loadClassInChildScopeOf(baseScope, scriptPath, classesDir, templateId, null, scriptSource);
    }

    private final File stage1SubDirOf(File cachedDir2) {
        return FilesKt.resolve((File)cachedDir2, (String)"stage-1");
    }

    private final Class<?> loadClassInChildScopeOf(ClassLoaderScope baseScope, String scriptPath, File classesDir, String scriptTemplateId, ClassPath accessorsClassPath, ScriptSource scriptSource) {
        InterpreterKt.access$logClassLoadingOf(scriptTemplateId, scriptSource);
        String string = "Program";
        File file = classesDir;
        ClassPath classPath = accessorsClassPath;
        return this.host.loadClassInChildScopeOf(baseScope, InterpreterKt.access$classLoaderScopeIdFor(scriptPath, scriptTemplateId), file, string, classPath);
    }

    private final ResidualProgramCompiler residualProgramCompilerFor(HashCode sourceHash, File outputDir, ClassLoaderScope classLoaderScopeForClassPath, ProgramKind programKind, ProgramTarget programTarget) {
        return new ResidualProgramCompiler(outputDir, this.host.compilationClassPathOf(classLoaderScopeForClassPath), sourceHash, programKind, programTarget, this.host.getImplicitImports(), null, 64, null);
    }

    private final AutoCloseable startCompilerOperationFor(ScriptSource scriptSource, String scriptTemplateId) {
        InterpreterKt.access$logCompilationOf(scriptTemplateId, scriptSource);
        String string = scriptSource.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptSource.displayName");
        return this.host.startCompilerOperation(string);
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    public Interpreter(@NotNull Host host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.host = host;
        this.defaultProgramHost = new ProgramHost();
    }

    @NotNull
    public static final /* synthetic */ AutoCloseable access$startCompilerOperationFor(Interpreter $this, @NotNull ScriptSource scriptSource, @NotNull String scriptTemplateId) {
        return $this.startCompilerOperationFor(scriptSource, scriptTemplateId);
    }

    @NotNull
    public static final /* synthetic */ File access$stage1SubDirOf(Interpreter $this, @NotNull File cachedDir2) {
        return $this.stage1SubDirOf(cachedDir2);
    }

    @NotNull
    public static final /* synthetic */ ResidualProgramCompiler access$residualProgramCompilerFor(Interpreter $this, @NotNull HashCode sourceHash, @NotNull File outputDir, @NotNull ClassLoaderScope classLoaderScopeForClassPath, @NotNull ProgramKind programKind, @NotNull ProgramTarget programTarget) {
        return $this.residualProgramCompilerFor(sourceHash, outputDir, classLoaderScopeForClassPath, programKind, programTarget);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u001c\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u001c\u0010\u0010\u001a\u00020\b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0016\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J>\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0 H&J\u0014\u0010!\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H&J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001eH&J6\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH&J\u0014\u0010+\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006/"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "", "implicitImports", "", "", "getImplicitImports", "()Ljava/util/List;", "applyBasePluginsTo", "", "project", "Lorg/gradle/api/Project;", "applyPluginsTo", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "cache", "specializedProgram", "Ljava/lang/Class;", "programId", "Lorg/gradle/kotlin/dsl/execution/ProgramId;", "cachedClassFor", "cachedDirFor", "Ljava/io/File;", "templateId", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "parentClassLoader", "Ljava/lang/ClassLoader;", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "initializer", "Lkotlin/Function1;", "closeTargetScopeOf", "compilationClassPathOf", "classLoaderScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "hashOf", "classPath", "loadClassInChildScopeOf", "childScopeId", "location", "className", "setupEmbeddedKotlinFor", "startCompilerOperation", "Ljava/lang/AutoCloseable;", "description", "gradle-kotlin-dsl"})
    public static interface Host {
        @Nullable
        public Class<?> cachedClassFor(@NotNull ProgramId var1);

        public void cache(@NotNull Class<?> var1, @NotNull ProgramId var2);

        @NotNull
        public File cachedDirFor(@NotNull String var1, @NotNull HashCode var2, @NotNull ClassLoader var3, @Nullable ClassPath var4, @NotNull Function1<? super File, Unit> var5);

        @NotNull
        public AutoCloseable startCompilerOperation(@NotNull String var1);

        @NotNull
        public ClassPath compilationClassPathOf(@NotNull ClassLoaderScope var1);

        @NotNull
        public Class<?> loadClassInChildScopeOf(@NotNull ClassLoaderScope var1, @NotNull String var2, @NotNull File var3, @NotNull String var4, @Nullable ClassPath var5);

        public void applyPluginsTo(@NotNull KotlinScriptHost<?> var1, @NotNull PluginRequests var2);

        public void applyBasePluginsTo(@NotNull Project var1);

        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> var1);

        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public HashCode hashOf(@NotNull ClassPath var1);

        @NotNull
        public List<String> getImplicitImports();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$FirstStageOnlyProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "evaluateSecondStageOf", "", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "scriptTemplateId", "", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "gradle-kotlin-dsl"})
    private final class FirstStageOnlyProgramHost
    extends ProgramHost {
        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @Nullable ClassPath accessorsClassPath) {
            Intrinsics.checkParameterIsNotNull((Object)program2, (String)"program");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016JR\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J6\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016J(\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0014\u0010%\u001a\u00020&2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0014\u0010'\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006("}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$Host;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "accessorsClassPathFor", "Lorg/gradle/internal/classpath/ClassPath;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "applyBasePluginsTo", "", "project", "Lorg/gradle/api/Project;", "applyPluginsTo", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "closeTargetScopeOf", "compileSecondStageScript", "Ljava/lang/Class;", "scriptPath", "", "originalScriptPath", "scriptTemplateId", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "accessorsClassPath", "eval", "specializedProgram", "evaluateSecondStageOf", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "handleScriptException", "exception", "", "scriptClass", "instantiate", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram;", "setupEmbeddedKotlinFor", "gradle-kotlin-dsl"})
    private class ProgramHost
    implements ExecutableProgram.Host {
        @Override
        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().setupEmbeddedKotlinFor(scriptHost);
        }

        @Override
        public void applyPluginsTo(@NotNull KotlinScriptHost<?> scriptHost, @NotNull PluginRequests pluginRequests) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)pluginRequests, (String)"pluginRequests");
            Interpreter.this.getHost().applyPluginsTo(scriptHost, pluginRequests);
        }

        @Override
        public void applyBasePluginsTo(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Interpreter.this.getHost().applyBasePluginsTo(project);
        }

        @Override
        public void handleScriptException(@NotNull Throwable exception, @NotNull Class<?> scriptClass, @NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            Intrinsics.checkParameterIsNotNull(scriptClass, (String)"scriptClass");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Void void_ = InterpreterKt.access$locationAwareExceptionHandlingFor(exception, scriptClass, scriptHost.getScriptSource());
            throw null;
        }

        @Override
        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().closeTargetScopeOf(scriptHost);
        }

        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @Nullable ClassPath accessorsClassPath) {
            HashCode hashCode;
            Intrinsics.checkParameterIsNotNull((Object)program2, (String)"program");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
            ClassLoaderScope targetScope = scriptHost.getTargetScope();
            ClassLoader parentClassLoader = targetScope.getExportClassLoader();
            ClassPath classPath = accessorsClassPath;
            if (classPath != null) {
                ClassPath classPath2;
                ClassPath it = classPath2 = classPath;
                hashCode = Interpreter.this.getHost().hashOf(it);
            } else {
                hashCode = null;
            }
            HashCode classPathHash = hashCode;
            ClassLoader classLoader = parentClassLoader;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"parentClassLoader");
            ProgramId programId = new ProgramId(scriptTemplateId, sourceHash, classLoader, classPathHash);
            Class<?> cachedProgram = Interpreter.this.getHost().cachedClassFor(programId);
            if (cachedProgram != null) {
                this.eval(cachedProgram, scriptHost);
                return;
            }
            Class<?> specializedProgram = program2.loadSecondStageFor(this, scriptHost, scriptTemplateId, sourceHash, accessorsClassPath);
            Interpreter.this.getHost().cache(specializedProgram, programId);
            this.eval(specializedProgram, scriptHost);
        }

        @Override
        @NotNull
        public ClassPath accessorsClassPathFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Object obj = scriptHost.getTarget();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.Project");
            }
            return AccessorsClassPathKt.accessorsClassPathFor((Project)obj, Interpreter.this.getHost().compilationClassPathOf(scriptHost.getTargetScope())).getBin();
        }

        @Override
        @NotNull
        public Class<?> compileSecondStageScript(@NotNull String scriptPath, @NotNull String originalScriptPath, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @NotNull ProgramKind programKind, @NotNull ProgramTarget programTarget, @Nullable ClassPath accessorsClassPath) {
            Intrinsics.checkParameterIsNotNull((Object)scriptPath, (String)"scriptPath");
            Intrinsics.checkParameterIsNotNull((Object)originalScriptPath, (String)"originalScriptPath");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            Intrinsics.checkParameterIsNotNull((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkParameterIsNotNull((Object)sourceHash, (String)"sourceHash");
            Intrinsics.checkParameterIsNotNull((Object)((Object)programKind), (String)"programKind");
            Intrinsics.checkParameterIsNotNull((Object)((Object)programTarget), (String)"programTarget");
            ClassLoaderScope targetScope = scriptHost.getTargetScope();
            ClassLoader parentClassLoader = targetScope.getExportClassLoader();
            ScriptSource scriptSource = scriptHost.getScriptSource();
            Host host = Interpreter.this.getHost();
            ClassLoader classLoader = parentClassLoader;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"parentClassLoader");
            File cacheDir2 = host.cachedDirFor(scriptTemplateId, sourceHash, classLoader, accessorsClassPath, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this, scriptSource, scriptTemplateId, targetScope, accessorsClassPath, sourceHash, programKind, programTarget, scriptPath, originalScriptPath){
                final /* synthetic */ ProgramHost this$0;
                final /* synthetic */ ScriptSource $scriptSource;
                final /* synthetic */ String $scriptTemplateId;
                final /* synthetic */ ClassLoaderScope $targetScope;
                final /* synthetic */ ClassPath $accessorsClassPath;
                final /* synthetic */ HashCode $sourceHash;
                final /* synthetic */ ProgramKind $programKind;
                final /* synthetic */ ProgramTarget $programTarget;
                final /* synthetic */ String $scriptPath;
                final /* synthetic */ String $originalScriptPath;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull File outputDir) {
                    Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
                    AutoCloseable autoCloseable = Interpreter.access$startCompilerOperationFor(this.this$0.Interpreter.this, this.$scriptSource, this.$scriptTemplateId);
                    Throwable throwable = null;
                    try {
                        ClassPath classPath;
                        ClassPath it;
                        AutoCloseable it2 = autoCloseable;
                        ClassPath targetScopeClassPath = this.this$0.Interpreter.this.getHost().compilationClassPathOf(this.$targetScope);
                        ClassPath classPath2 = this.$accessorsClassPath;
                        if (classPath2 == null || (classPath2 = targetScopeClassPath.plus(it = (classPath = classPath2))) == null) {
                            classPath2 = targetScopeClassPath;
                        }
                        ClassPath compilationClassPath = classPath2;
                        ScriptSource $receiver$iv = this.$scriptSource;
                        try {
                            new ResidualProgramCompiler(outputDir, compilationClassPath, this.$sourceHash, this.$programKind, this.$programTarget, this.this$0.Interpreter.this.getHost().getImplicitImports(), null, 64, null).emitStage2ProgramFor(new File(this.$scriptPath), this.$originalScriptPath);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (ScriptCompilationException e$iv) {
                            throw (Throwable)new LocationAwareException((Throwable)e$iv, $receiver$iv, e$iv.getFirstErrorLine());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
                {
                    this.this$0 = programHost;
                    this.$scriptSource = scriptSource;
                    this.$scriptTemplateId = string;
                    this.$targetScope = classLoaderScope;
                    this.$accessorsClassPath = classPath;
                    this.$sourceHash = hashCode;
                    this.$programKind = programKind;
                    this.$programTarget = programTarget;
                    this.$scriptPath = string2;
                    this.$originalScriptPath = string3;
                    super(1);
                }
            }));
            return Interpreter.this.loadClassInChildScopeOf(targetScope, originalScriptPath, cacheDir2, scriptTemplateId, accessorsClassPath, scriptSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eval(@NotNull Class<?> specializedProgram, @NotNull KotlinScriptHost<?> scriptHost) {
            Thread currentThread$iv;
            Intrinsics.checkParameterIsNotNull(specializedProgram, (String)"specializedProgram");
            Intrinsics.checkParameterIsNotNull(scriptHost, (String)"scriptHost");
            ClassLoader classLoader = specializedProgram.getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"specializedProgram.classLoader");
            ClassLoader classLoader$iv = classLoader;
            Thread thread = currentThread$iv = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
            ClassLoader previous$iv = thread.getContextClassLoader();
            try {
                currentThread$iv.setContextClassLoader(classLoader$iv);
                this.instantiate(specializedProgram).execute(this, scriptHost);
            }
            finally {
                currentThread$iv.setContextClassLoader(previous$iv);
            }
        }

        private final ExecutableProgram instantiate(Class<?> specializedProgram) {
            Object obj = specializedProgram.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.kotlin.dsl.execution.ExecutableProgram");
            }
            return (ExecutableProgram)obj;
        }
    }
}

