/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SequentialTaskExecutor;

public class LowMemoryWatcherManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcherManager");
    @NotNull
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final AtomicBoolean myProcessing;
    private final Runnable myJanitor;
    private final NotificationListener myLowMemoryListener;

    public LowMemoryWatcherManager(@NotNull ExecutorService executorService) {
        if (executorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        this.myProcessing = new AtomicBoolean();
        this.myJanitor = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Runnable runnable = LowMemoryWatcherManager.this.myJanitor;
                synchronized (runnable) {
                    LowMemoryWatcherManager.this.mySubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived();
            }
        };
        this.myLowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                if ("java.management.memory.threshold.exceeded".equals(notification.getType())) {
                    if (Registry.is("low.memory.watcher.sync", true)) {
                        LowMemoryWatcherManager.this.handleEventImmediately();
                        return;
                    }
                    Runnable runnable = LowMemoryWatcherManager.this.myJanitor;
                    synchronized (runnable) {
                        if (LowMemoryWatcherManager.this.mySubmitted == null) {
                            LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(LowMemoryWatcherManager.this.myJanitor);
                        }
                    }
                }
            }
        };
        this.myExecutorService = new SequentialTaskExecutor("LowMemoryWatcherManager", executorService);
        try {
            for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                long max;
                long threshold;
                if (bean.getType() != MemoryType.HEAP || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((double)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                bean.setUsageThreshold(threshold);
            }
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this.myLowMemoryListener, null, null);
        }
        catch (Throwable e) {
            LOG.info("Errors initializing LowMemoryWatcher: ", e);
        }
    }

    private static double getOccupiedMemoryThreshold() {
        try {
            return Registry.doubleValue("low.memory.watcher.notification.threshold");
        }
        catch (MissingResourceException e) {
            return 0.95;
        }
    }

    private void handleEventImmediately() {
        if (this.myProcessing.compareAndSet(false, true)) {
            try {
                this.myJanitor.run();
            }
            finally {
                this.myProcessing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (ListenerNotFoundException e) {
            LOG.error(e);
        }
        Runnable runnable = this.myJanitor;
        synchronized (runnable) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorService", "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager", "<init>"));
    }
}

