/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.testFramework;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.CharsetUtil;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFileBase;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent;
    private Language myLanguage;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls @NotNull String name) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(0);
        }
        this(name, "");
    }

    public LightVirtualFile(@NonNls @NotNull String name, @NotNull CharSequence content) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(1);
        }
        if (content == null) {
            LightVirtualFile.$$$reportNull$$$0(2);
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text2) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(4);
        }
        this(name, fileType, text2, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text2, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(7);
        }
        this(name, fileType, text2, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text2), modificationStamp);
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text2, Charset charset, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(9);
        }
        super(name, fileType, modificationStamp);
        this.myContent = text2;
        this.setCharset(charset);
    }

    public LightVirtualFile(@NotNull String name, Language language, @NotNull CharSequence text2) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            LightVirtualFile.$$$reportNull$$$0(11);
        }
        super(name, null, LocalTimeCounter.currentTime());
        this.myContent = text2;
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            LightVirtualFile.$$$reportNull$$$0(12);
        }
        this.myLanguage = language;
        FileType type2 = language.getAssociatedFileType();
        if (type2 == null) {
            type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName());
        }
        this.setFileType(type2);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        OutputStream outputStream2 = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (LightVirtualFile.this.isWritable());
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    LightVirtualFile.this.myContent = this.toString(LightVirtualFile.this.getCharset().name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream2 == null) {
            LightVirtualFile.$$$reportNull$$$0(13);
        }
        return outputStream2;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        byte[] byArray = s.getBytes(charset.name());
        if (byArray == null) {
            LightVirtualFile.$$$reportNull$$$0(14);
        }
        return byArray;
    }

    @NotNull
    public CharSequence getContent() {
        CharSequence charSequence = this.myContent;
        if (charSequence == null) {
            LightVirtualFile.$$$reportNull$$$0(16);
        }
        return charSequence;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setLanguage";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

