/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsInvocation
extends JsExpression.JsExpressionHasArguments {
    @NotNull
    private JsExpression qualifier;

    public JsInvocation(@NotNull JsExpression qualifier, @NotNull List<? extends JsExpression> arguments2) {
        super(new SmartList<JsExpression>((Collection<JsExpression>)arguments2));
        this.qualifier = qualifier;
    }

    public JsInvocation(@NotNull JsExpression qualifier, JsExpression ... arguments2) {
        this(qualifier, new SmartList<JsExpression>(arguments2));
    }

    @Override
    @NotNull
    public List<JsExpression> getArguments() {
        return this.arguments;
    }

    @NotNull
    public JsExpression getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(@NotNull JsExpression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitInvocation(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.qualifier);
        visitor2.acceptList(this.arguments);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.qualifier = v.accept(this.qualifier);
            v.acceptList(this.arguments);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsInvocation deepCopy() {
        JsExpression qualifierCopy = AstUtil.deepCopy(this.qualifier);
        List argumentsCopy = AstUtil.deepCopy(this.arguments);
        return new JsInvocation(qualifierCopy, argumentsCopy).withMetadataFrom(this);
    }
}

