/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator$WhenMappings;
import org.jetbrains.kotlin.js.translate.expression.RangeLiteral;
import org.jetbrains.kotlin.js.translate.expression.RangeType;
import org.jetbrains.kotlin.js.translate.expression.WithIndexInfo;
import org.jetbrains.kotlin.js.translate.expression.WithIndexReceiverType;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.BuiltInPropertyIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"downToFunctionName", "Lorg/jetbrains/kotlin/name/FqName;", "indicesFqName", "intProgressionName", "intRangeName", "rangeToFunctionName", "sequenceFqName", "sequenceWithIndexFqName", "stepFunctionName", "untilFunctionName", "withIndexFqName", "createWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "js.translator"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    private static final FqName rangeToFunctionName = new FqName("kotlin.Int.rangeTo");
    private static final FqName untilFunctionName = new FqName("kotlin.ranges.until");
    private static final FqName downToFunctionName = new FqName("kotlin.ranges.downTo");
    private static final FqName stepFunctionName = new FqName("kotlin.ranges.step");
    private static final FqName intRangeName = new FqName("kotlin.ranges.IntRange");
    private static final FqName intProgressionName = new FqName("kotlin.ranges.IntProgression");
    private static final FqName withIndexFqName = new FqName("kotlin.collections.withIndex");
    private static final FqName sequenceWithIndexFqName = new FqName("kotlin.sequences.withIndex");
    private static final FqName indicesFqName = new FqName("kotlin.collections.indices");
    private static final FqName sequenceFqName = new FqName("kotlin.sequences.Sequence");

    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression2, @NotNull TranslationContext context) {
        JsStatement bodyStatement;
        JsStatement jsStatement;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtExpression ktExpression = expression2.getCondition();
        if (ktExpression == null) {
            throw (Throwable)new IllegalArgumentException("condition expression should not be null: " + expression2.getText());
        }
        KtExpression conditionExpression = ktExpression;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsCondition = Translation.translateAsExpression(conditionExpression, context, conditionBlock);
        KtExpression body = expression2.getBody();
        if (body != null) {
            JsStatement jsStatement2 = Translation.translateAsStatementAndMergeInBlockIfNeeded(body, context);
            jsStatement = jsStatement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"Translation.translateAsS\u2026ckIfNeeded(body, context)");
        } else {
            jsStatement = bodyStatement = (JsStatement)JsEmpty.INSTANCE;
        }
        if (!conditionBlock.isEmpty()) {
            SourceInfoAwareJsNode sourceInfoAwareJsNode = new JsBreak();
            SourceInfoAwareJsNode sourceInfoAwareJsNode2 = JsAstUtils.not(jsCondition);
            JsBreak $receiver = sourceInfoAwareJsNode;
            $receiver.setSource(expression2);
            JsBreak jsBreak = sourceInfoAwareJsNode;
            JsStatement jsStatement3 = jsBreak;
            JsExpression jsExpression = sourceInfoAwareJsNode2;
            $receiver = sourceInfoAwareJsNode = new JsIf(jsExpression, jsStatement3);
            $receiver.setSource(expression2);
            SourceInfoAwareJsNode breakIfConditionIsFalseStatement = sourceInfoAwareJsNode;
            JsBlock bodyBlock = JsAstUtils.convertToBlock(bodyStatement);
            jsCondition = new JsBooleanLiteral(true);
            if (doWhile) {
                JsExpression secondRun = context.defineTemporary(new JsBooleanLiteral(false).source(expression2));
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                JsIf ifStatement = new JsIf(secondRun, conditionBlock, JsAstUtils.assignment(secondRun, new JsBooleanLiteral(true)).source(expression2).makeStmt());
                JsBlock jsBlock = bodyBlock;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"bodyBlock");
                JsIf jsIf = ifStatement;
                int n = 0;
                List<JsStatement> list2 = jsBlock.getStatements();
                JsIf $receiver2 = jsIf;
                $receiver2.setSource(expression2);
                sourceInfoAwareJsNode2 = jsIf;
                list2.add(n, (JsStatement)((Object)sourceInfoAwareJsNode2));
            } else {
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                JsBlock jsBlock = bodyBlock;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"bodyBlock");
                List<JsStatement> list3 = jsBlock.getStatements();
                List<JsStatement> list4 = conditionBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"conditionBlock.statements");
                list3.addAll(0, (Collection<JsStatement>)list4);
            }
            bodyStatement = bodyBlock;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        JsNode jsNode = result2.source(expression2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNode, (String)"result.source(expression)");
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context) {
        JsStatement result2;
        JsStatement jsStatement;
        Object object;
        block7: {
            Function0<JsStatement> translateForOverIterator$;
            Function0<JsStatement> translateForOverArray$;
            Function0<JsStatement> translateForOverRange$;
            Function0<Boolean> isForOverArray$;
            Function0<Boolean> isForOverRange$;
            block8: {
                Object withIndexCall;
                Function1<WithIndexInfo, JsStatement> translateForOverCollectionWithIndex$;
                Function1<WithIndexInfo, JsStatement> translateForOverCollectionIndices$;
                Function1<WithIndexInfo, JsStatement> translateForOverArrayWithIndex$;
                block6: {
                    KtParameter loopParameter;
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    KtExpression ktExpression = KtPsiUtil.deparenthesize(PsiUtils.getLoopRange(expression2));
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    KtExpression loopRange = ktExpression;
                    KotlinType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
                    isForOverRange$ = new Function0<Boolean>(rangeType){
                        final /* synthetic */ KotlinType $rangeType;

                        public final boolean invoke() {
                            Object object = this.$rangeType.getConstructor().getDeclarationDescriptor();
                            if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
                                return false;
                            }
                            Object fqn = object;
                            return Intrinsics.areEqual((Object)fqn, (Object)LoopTranslator.access$getIntRangeName$p());
                        }
                        {
                            this.$rangeType = kotlinType;
                            super(0);
                        }
                    };
                    Function0<RangeLiteral> extractForOverRangeLiteral$ = new Function0<RangeLiteral>(rangeType, loopRange, context){
                        final /* synthetic */ KotlinType $rangeType;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ TranslationContext $context;

                        @Nullable
                        public final RangeLiteral invoke() {
                            RangeType rangeType;
                            Object object;
                            ReceiverValue receiverValue;
                            ReceiverValue receiverValue2;
                            KtExpression step;
                            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                            block17: {
                                ResolvedCall<? extends CallableDescriptor> resolvedCall3;
                                block19: {
                                    block18: {
                                        FqName fqn;
                                        ClassifierDescriptor classifierDescriptor = this.$rangeType.getConstructor().getDeclarationDescriptor();
                                        FqName fqName2 = fqn = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
                                        if (Intrinsics.areEqual((Object)fqn, (Object)LoopTranslator.access$getIntRangeName$p()) ^ true && Intrinsics.areEqual((Object)fqn, (Object)LoopTranslator.access$getIntProgressionName$p()) ^ true) {
                                            return null;
                                        }
                                        KtElement ktElement = this.$loopRange;
                                        BindingContext bindingContext = this.$context.bindingContext();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.bindingContext()");
                                        ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                                        if (resolvedCall4 == null) {
                                            return null;
                                        }
                                        resolvedCall2 = resolvedCall4;
                                        step = null;
                                        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor()), (Object)LoopTranslator.access$getStepFunctionName$p())) break block17;
                                        Call call2 = resolvedCall2.getCall();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
                                        KtExpression ktExpression = call2.getValueArguments().get(0).getArgumentExpression();
                                        if (ktExpression == null) {
                                            return null;
                                        }
                                        step = ktExpression;
                                        ReceiverValue receiverValue3 = resolvedCall2.getExtensionReceiver();
                                        if (!(receiverValue3 instanceof ExpressionReceiver)) {
                                            receiverValue3 = null;
                                        }
                                        if ((resolvedCall3 = (ExpressionReceiver)receiverValue3) == null || (resolvedCall3 = resolvedCall3.getExpression()) == null) break block18;
                                        KtElement ktElement2 = (KtElement)((Object)resolvedCall3);
                                        BindingContext bindingContext2 = this.$context.bindingContext();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.bindingContext()");
                                        resolvedCall3 = CallUtilKt.getResolvedCall(ktElement2, bindingContext2);
                                        if (resolvedCall3 != null) break block19;
                                    }
                                    return null;
                                }
                                resolvedCall2 = resolvedCall3;
                            }
                            if ((receiverValue2 = resolvedCall2.getExtensionReceiver()) == null) {
                                receiverValue2 = receiverValue = resolvedCall2.getDispatchReceiver();
                            }
                            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                                receiverValue = null;
                            }
                            if ((object = (ExpressionReceiver)receiverValue) == null || (object = object.getExpression()) == null) {
                                return null;
                            }
                            Object first2 = object;
                            List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
                            if (list2 == null || (list2 = (ResolvedValueArgument)CollectionsKt.firstOrNull(list2)) == null || (list2 = list2.getArguments()) == null || (list2 = (ValueArgument)CollectionsKt.firstOrNull(list2)) == null || (list2 = list2.getArgumentExpression()) == null) {
                                return null;
                            }
                            List<ResolvedValueArgument> second = list2;
                            FqName fqName3 = DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor());
                            if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getRangeToFunctionName$p())) {
                                rangeType = RangeType.RANGE_TO;
                            } else if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getUntilFunctionName$p())) {
                                rangeType = RangeType.UNTIL;
                            } else if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getDownToFunctionName$p())) {
                                rangeType = RangeType.DOWN_TO;
                            } else {
                                return null;
                            }
                            RangeType type2 = rangeType;
                            return new RangeLiteral(type2, (KtExpression)first2, (KtExpression)((Object)second), step);
                        }
                        {
                            this.$rangeType = kotlinType;
                            this.$loopRange = ktExpression;
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    isForOverArray$ = new Function0<Boolean>(rangeType){
                        final /* synthetic */ KotlinType $rangeType;

                        public final boolean invoke() {
                            return KotlinBuiltIns.isArray(this.$rangeType) || KotlinBuiltIns.isPrimitiveArray(this.$rangeType);
                        }
                        {
                            this.$rangeType = kotlinType;
                            super(0);
                        }
                    };
                    KtParameter ktParameter = expression2.getLoopParameter();
                    if (ktParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    KtParameter ktParameter2 = loopParameter = ktParameter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter2, (String)"loopParameter");
                    KtDestructuringDeclaration destructuringParameter = ktParameter2.getDestructuringDeclaration();
                    JsName parameterName = destructuringParameter == null ? context.getNameForElement(loopParameter) : JsScope.declareTemporary();
                    Function1<KtDeclaration, VariableDescriptor> extractDescriptor$ = new Function1<KtDeclaration, VariableDescriptor>(context){
                        final /* synthetic */ TranslationContext $context;

                        @Nullable
                        public final VariableDescriptor invoke(@NotNull KtDeclaration $receiver) {
                            VariableDescriptor variableDescriptor;
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            VariableDescriptor variableDescriptor2 = (VariableDescriptor)this.$context.bindingContext().get(BindingContext.VARIABLE, $receiver);
                            if (variableDescriptor2 != null) {
                                VariableDescriptor variableDescriptor3;
                                VariableDescriptor it;
                                VariableDescriptor variableDescriptor4 = it = (variableDescriptor3 = variableDescriptor2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor4, (String)"it");
                                Name name = variableDescriptor4.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.name");
                                variableDescriptor = !name.isSpecial() ? variableDescriptor3 : null;
                            } else {
                                variableDescriptor = null;
                            }
                            return variableDescriptor;
                        }
                        {
                            this.$context = translationContext;
                            super(1);
                        }
                    };
                    Function0<WithIndexInfo> extractWithIndexCall$ = new Function0<WithIndexInfo>(loopRange, context, destructuringParameter, extractDescriptor$, loopParameter){
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;
                        final /* synthetic */ translateForExpression.4 $extractDescriptor$4;
                        final /* synthetic */ KtParameter $loopParameter;

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final WithIndexInfo invoke() {
                            void indexDescriptor;
                            JsExpression arrayExpr;
                            JsExpression jsExpression;
                            ReceiverValue receiver;
                            WithIndexReceiverType withIndexReceiverType;
                            ClassifierDescriptor classifierDescriptor;
                            Pair pair;
                            FqName fqName2;
                            KtElement ktElement = this.$loopRange;
                            BindingContext bindingContext = this.$context.bindingContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.bindingContext()");
                            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                            if (resolvedCall2 == null) {
                                return null;
                            }
                            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                            FqName fqName3 = fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor());
                            if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getWithIndexFqName$p()) || Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getSequenceWithIndexFqName$p())) {
                                List<KtDestructuringDeclarationEntry> list2;
                                if (this.$destructuringParameter == null) {
                                    return null;
                                }
                                List<KtDestructuringDeclarationEntry> it = list2 = this.$destructuringParameter.getEntries();
                                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it.get(0);
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"it[0]");
                                VariableDescriptor variableDescriptor = this.$extractDescriptor$4.invoke(ktDestructuringDeclarationEntry);
                                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry2 = it.get(1);
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry2, (String)"it[1]");
                                pair = new Pair((Object)variableDescriptor, (Object)this.$extractDescriptor$4.invoke(ktDestructuringDeclarationEntry2));
                            } else if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getIndicesFqName$p())) {
                                if (this.$destructuringParameter != null) {
                                    return null;
                                }
                                DeclarationDescriptor declarationDescriptor = this.$context.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.$loopParameter);
                                if (!(declarationDescriptor instanceof VariableDescriptor)) {
                                    declarationDescriptor = null;
                                }
                                VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
                                if (variableDescriptor == null) {
                                    return null;
                                }
                                VariableDescriptor varDescriptor = variableDescriptor;
                                pair = new Pair((Object)varDescriptor, null);
                            } else {
                                return null;
                            }
                            Pair pair2 = pair;
                            VariableDescriptor variableDescriptor = (VariableDescriptor)pair2.component1();
                            VariableDescriptor elementDescriptor = (VariableDescriptor)pair2.component2();
                            Object object = resolvedCall3.getResultingDescriptor().getExtensionReceiverParameter();
                            if (!((object != null && (object = object.getType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                                classifierDescriptor = null;
                            }
                            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                            if (classDescriptor == null) {
                                return null;
                            }
                            ClassDescriptor receiverClass = classDescriptor;
                            if (KotlinBuiltIns.isArrayOrPrimitiveArray(receiverClass)) {
                                withIndexReceiverType = WithIndexReceiverType.ARRAY;
                            } else if (KotlinBuiltIns.isCollectionOrNullableCollection(receiverClass.getDefaultType())) {
                                withIndexReceiverType = WithIndexReceiverType.COLLECTION;
                            } else if (KotlinBuiltIns.isIterableOrNullableIterable(receiverClass.getDefaultType())) {
                                withIndexReceiverType = WithIndexReceiverType.ITERABLE;
                            } else if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(receiverClass), (Object)LoopTranslator.access$getSequenceFqName$p())) {
                                withIndexReceiverType = WithIndexReceiverType.SEQUENCE;
                            } else {
                                return null;
                            }
                            WithIndexReceiverType receiverType = withIndexReceiverType;
                            ReceiverValue receiverValue = resolvedCall3.getExtensionReceiver();
                            if (receiverValue == null) {
                                return null;
                            }
                            ReceiverValue receiverValue2 = receiver = receiverValue;
                            if (receiverValue2 instanceof ExpressionReceiver) {
                                jsExpression = Translation.translateAsExpression(((ExpressionReceiver)receiver).getExpression(), this.$context);
                            } else if (receiverValue2 instanceof ImplicitReceiver) {
                                jsExpression = this.$context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(receiver));
                            } else {
                                return null;
                            }
                            JsExpression jsExpression2 = arrayExpr = jsExpression;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"arrayExpr");
                            return new WithIndexInfo(receiverType, (VariableDescriptor)indexDescriptor, elementDescriptor, jsExpression2);
                        }
                        {
                            this.$loopRange = ktExpression;
                            this.$context = translationContext;
                            this.$destructuringParameter = ktDestructuringDeclaration;
                            this.$extractDescriptor$4 = var4_4;
                            this.$loopParameter = ktParameter;
                            super(0);
                        }
                    };
                    Function1<JsExpression, JsStatement> translateBody$ = new Function1<JsExpression, JsStatement>(expression2, context, destructuringParameter, loopParameter, parameterName){
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;
                        final /* synthetic */ KtParameter $loopParameter;
                        final /* synthetic */ JsName $parameterName;

                        @Nullable
                        public final JsStatement invoke(@Nullable JsExpression itemValue) {
                            List<JsStatement> list2;
                            SourceInfoAwareJsNode sourceInfoAwareJsNode;
                            JsStatement realBody;
                            JsStatement jsStatement;
                            KtExpression ktExpression = this.$expression.getBody();
                            if (ktExpression != null) {
                                KtExpression ktExpression2;
                                KtExpression it = ktExpression2 = ktExpression;
                                jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, this.$context);
                            } else {
                                jsStatement = realBody = null;
                            }
                            if (itemValue == null && this.$destructuringParameter == null) {
                                return realBody;
                            }
                            JsBlock block = new JsBlock();
                            if (this.$destructuringParameter == null) {
                                JsExpression jsExpression;
                                SourceInfoAwareJsNode sourceInfoAwareJsNode2;
                                DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(this.$context.bindingContext(), this.$loopParameter);
                                if (declarationDescriptor == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                                }
                                CallableDescriptor loopParameterDescriptor = (CallableDescriptor)declarationDescriptor;
                                KotlinType kotlinType = loopParameterDescriptor.getReturnType();
                                if (kotlinType == null) {
                                    SimpleType simpleType2 = this.$context.getCurrentModule().getBuiltIns().getAnyType();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.currentModule.builtIns.anyType");
                                    kotlinType = simpleType2;
                                }
                                KotlinType loopParameterType = kotlinType;
                                JsExpression jsExpression2 = itemValue;
                                if (jsExpression2 != null) {
                                    sourceInfoAwareJsNode2 = jsExpression2;
                                    JsExpression it = sourceInfoAwareJsNode2;
                                    jsExpression = TranslationUtils.coerce(this.$context, it, loopParameterType);
                                } else {
                                    jsExpression = null;
                                }
                                JsExpression coercedItemValue = jsExpression;
                                SourceInfoAwareJsNode $receiver = sourceInfoAwareJsNode2 = JsAstUtils.newVar(this.$parameterName, coercedItemValue);
                                $receiver.setSource(this.$expression.getLoopRange());
                                sourceInfoAwareJsNode = sourceInfoAwareJsNode2;
                            } else {
                                TranslationContext innerBlockContext = this.$context.innerBlock(block);
                                if (itemValue != null) {
                                    JsVars jsVars;
                                    JsVars $receiver = jsVars = JsAstUtils.newVar(this.$parameterName, itemValue);
                                    $receiver.setSource(this.$expression.getLoopRange());
                                    JsVars parameterStatement = jsVars;
                                    innerBlockContext.addStatementToCurrentBlock(parameterStatement);
                                }
                                sourceInfoAwareJsNode = DestructuringDeclarationTranslator.translate(this.$destructuringParameter, JsAstUtils.pureFqn(this.$parameterName, null), innerBlockContext);
                            }
                            JsVars currentVarInit = sourceInfoAwareJsNode;
                            Collection collection = block.getStatements();
                            collection.add(currentVarInit);
                            collection = block.getStatements();
                            if (realBody instanceof JsBlock) {
                                List<JsStatement> list3 = ((JsBlock)realBody).getStatements();
                                list2 = list3;
                                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"realBody.statements");
                            } else {
                                list2 = CollectionsKt.listOfNotNull((Object)realBody);
                            }
                            Iterable iterable = list2;
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                            return block;
                        }
                        {
                            this.$expression = ktForExpression;
                            this.$context = translationContext;
                            this.$destructuringParameter = ktDestructuringDeclaration;
                            this.$loopParameter = ktParameter;
                            this.$parameterName = jsName;
                            super(1);
                        }
                    };
                    Function1<RangeLiteral, JsStatement> translateForOverLiteralRange$ = new Function1<RangeLiteral, JsStatement>(context, translateBody$, parameterName, expression2){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;
                        final /* synthetic */ JsName $parameterName;
                        final /* synthetic */ KtForExpression $expression;

                        @NotNull
                        public final JsStatement invoke(@NotNull RangeLiteral literal) {
                            JsVars jsVars;
                            JsExpression jsExpression;
                            Enum incrementOperator;
                            JsBinaryOperation jsBinaryOperation;
                            JsExpression jsExpression2;
                            JsExpression jsExpression3;
                            Intrinsics.checkParameterIsNotNull((Object)literal, (String)"literal");
                            JsBlock startBlock = new JsBlock();
                            JsExpression leftExpression = Translation.translateAsExpression(literal.getFirst(), this.$context, startBlock);
                            JsBlock endBlock = new JsBlock();
                            JsExpression rightExpression = Translation.translateAsExpression(literal.getSecond(), this.$context, endBlock);
                            JsBlock stepBlock = new JsBlock();
                            KtExpression ktExpression = literal.getStep();
                            if (ktExpression != null) {
                                KtExpression ktExpression2;
                                KtExpression it = ktExpression2 = ktExpression;
                                jsExpression3 = Translation.translateAsExpression(it, this.$context, stepBlock);
                            } else {
                                jsExpression3 = null;
                            }
                            JsExpression stepExpression = jsExpression3;
                            this.$context.addStatementsToCurrentBlockFrom(startBlock);
                            JsExpression rangeStart = this.$context.cacheExpressionIfNeeded(leftExpression);
                            this.$context.addStatementsToCurrentBlockFrom(endBlock);
                            JsExpression rangeEnd = this.$context.defineTemporary(rightExpression);
                            this.$context.addStatementsToCurrentBlockFrom(stepBlock);
                            JsExpression jsExpression4 = stepExpression;
                            if (jsExpression4 != null) {
                                JsExpression jsExpression5;
                                JsExpression it = jsExpression5 = jsExpression4;
                                jsExpression2 = this.$context.defineTemporary(it);
                            } else {
                                jsExpression2 = null;
                            }
                            JsExpression step = jsExpression2;
                            JsStatement body = this.$translateBody$6.invoke(null);
                            switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$0[literal.getType().ordinal()]) {
                                case 1: {
                                    jsBinaryOperation = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), rangeEnd);
                                    break;
                                }
                                case 2: {
                                    jsBinaryOperation = JsAstUtils.lessThan(this.$parameterName.makeRef(), rangeEnd);
                                    break;
                                }
                                case 3: {
                                    jsBinaryOperation = JsAstUtils.greaterThanEq(this.$parameterName.makeRef(), rangeEnd);
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            JsExpression conditionExpression = jsBinaryOperation.source(this.$expression);
                            if (step == null) {
                                JsUnaryOperator jsUnaryOperator;
                                switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$1[literal.getType().ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        jsUnaryOperator = JsUnaryOperator.INC;
                                        break;
                                    }
                                    case 3: {
                                        jsUnaryOperator = JsUnaryOperator.DEC;
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                incrementOperator = jsUnaryOperator;
                                jsExpression = new JsPostfixOperation((JsUnaryOperator)incrementOperator, this.$parameterName.makeRef()).source(this.$expression);
                            } else {
                                JsBinaryOperator jsBinaryOperator;
                                switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$2[literal.getType().ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        jsBinaryOperator = JsBinaryOperator.ASG_ADD;
                                        break;
                                    }
                                    case 3: {
                                        jsBinaryOperator = JsBinaryOperator.ASG_SUB;
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                incrementOperator = jsBinaryOperator;
                                jsExpression = new JsBinaryOperation((JsBinaryOperator)incrementOperator, this.$parameterName.makeRef(), step).source(this.$expression);
                            }
                            JsExpression incrementExpression = jsExpression;
                            JsVars $receiver = jsVars = JsAstUtils.newVar(this.$parameterName, rangeStart);
                            $receiver.setSource(this.$expression);
                            JsVars initVars = jsVars;
                            return new JsFor(initVars, conditionExpression, incrementExpression, body);
                        }
                        {
                            this.$context = translationContext;
                            this.$translateBody$6 = var2_2;
                            this.$parameterName = jsName;
                            this.$expression = ktForExpression;
                            super(1);
                        }
                    };
                    translateForOverRange$ = new Function0<JsStatement>(context, loopRange, translateBody$, parameterName, expression2){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;
                        final /* synthetic */ JsName $parameterName;
                        final /* synthetic */ KtForExpression $expression;

                        @NotNull
                        public final JsStatement invoke() {
                            JsVars jsVars;
                            JsExpression rangeExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                            Function1<String, JsExpression> getProperty$ = new Function1<String, JsExpression>(this, rangeExpression){
                                final /* synthetic */ translateForExpression.8 this$0;
                                final /* synthetic */ JsExpression $rangeExpression;

                                @NotNull
                                public final JsExpression invoke(@NotNull String funName) {
                                    Intrinsics.checkParameterIsNotNull((Object)funName, (String)"funName");
                                    JsExpression jsExpression = new JsNameRef(funName, this.$rangeExpression).source(this.this$0.$loopRange);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"JsNameRef(funName, range\u2026ession).source(loopRange)");
                                    return jsExpression;
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$rangeExpression = jsExpression;
                                    super(1);
                                }
                            };
                            JsExpression start = this.$context.defineTemporary(getProperty$.invoke("first"));
                            JsExpression end = this.$context.defineTemporary(getProperty$.invoke("last"));
                            JsExpression increment = this.$context.defineTemporary(getProperty$.invoke("step"));
                            JsStatement body = this.$translateBody$6.invoke(null);
                            JsExpression conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), end).source(this.$expression);
                            JsExpression incrementExpression = JsAstUtils.addAssign(this.$parameterName.makeRef(), increment).source(this.$expression);
                            JsVars $receiver = jsVars = JsAstUtils.newVar(this.$parameterName, start);
                            $receiver.setSource(this.$expression);
                            JsVars initVars = jsVars;
                            return new JsFor(initVars, conditionExpression, incrementExpression, body);
                        }
                        {
                            this.$context = translationContext;
                            this.$loopRange = ktExpression;
                            this.$translateBody$6 = var3_3;
                            this.$parameterName = jsName;
                            this.$expression = ktForExpression;
                            super(0);
                        }
                    };
                    translateForOverArray$ = new Function0<JsStatement>(context, loopRange, expression2, translateBody$){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;

                        @NotNull
                        public final JsStatement invoke() {
                            JsExpression rangeExpression;
                            JsExpression jsExpression = rangeExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                            BuiltInPropertyIntrinsic builtInPropertyIntrinsic = ArrayFIF.LENGTH_PROPERTY_INTRINSIC;
                            List list2 = CollectionsKt.emptyList();
                            JsExpression length = builtInPropertyIntrinsic.apply(jsExpression, (List<? extends JsExpression>)list2, this.$context);
                            JsExpression end = this.$context.defineTemporary(length);
                            TemporaryVariable index2 = this.$context.declareTemporary(new JsIntLiteral(0), this.$expression);
                            JsExpression arrayAccess = new JsArrayAccess(rangeExpression, index2.reference()).source(this.$expression);
                            JsStatement body = this.$translateBody$6.invoke(arrayAccess);
                            JsExpression initExpression = JsAstUtils.assignment(index2.reference(), new JsIntLiteral(0)).source(this.$expression);
                            JsExpression conditionExpression = JsAstUtils.inequality(index2.reference(), end).source(this.$expression);
                            JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference()).source(this.$expression);
                            return new JsFor(initExpression, conditionExpression, incrementExpression, body);
                        }
                        {
                            this.$context = translationContext;
                            this.$loopRange = ktExpression;
                            this.$expression = ktForExpression;
                            this.$translateBody$6 = var4_4;
                            super(0);
                        }
                    };
                    translateForOverArrayWithIndex$ = new Function1<WithIndexInfo, JsStatement>(context, expression2){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtForExpression $expression;

                        @NotNull
                        public final JsStatement invoke(@NotNull WithIndexInfo info) {
                            JsBlock body;
                            JsExpression incrementExpression;
                            JsExpression conditionExpression;
                            Object initExpression;
                            block4: {
                                Object object;
                                JsName jsName;
                                Object it;
                                VariableDescriptor variableDescriptor;
                                VariableDescriptor it2;
                                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                                JsExpression range = this.$context.cacheExpressionIfNeeded(info.getRange());
                                Object object2 = info.getIndex();
                                if (object2 == null || (object2 = this.$context.getNameForDescriptor(it2 = (variableDescriptor = object2))) == null) {
                                    object2 = JsScope.declareTemporary();
                                }
                                Object indexVar = object2;
                                VariableDescriptor variableDescriptor2 = info.getValue();
                                if (variableDescriptor2 != null) {
                                    it2 = variableDescriptor2;
                                    it = it2;
                                    jsName = this.$context.getNameForDescriptor((DeclarationDescriptor)it);
                                } else {
                                    jsName = null;
                                }
                                JsName valueVar = jsName;
                                Object $receiver = it = JsAstUtils.newVar((JsName)indexVar, new JsIntLiteral(0));
                                ((SourceInfoAwareJsNode)$receiver).setSource(this.$expression);
                                initExpression = it;
                                conditionExpression = JsAstUtils.inequality(((JsName)indexVar).makeRef(), new JsNameRef("length", range)).source(this.$expression);
                                incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, ((JsName)indexVar).makeRef()).source(this.$expression);
                                body = new JsBlock();
                                if (valueVar != null) {
                                    JsVars jsVars;
                                    object = body.getStatements();
                                    JsVars $receiver2 = jsVars = JsAstUtils.newVar(valueVar, new JsArrayAccess(range, ((JsName)indexVar).makeRef()));
                                    $receiver2.setSource(this.$expression);
                                    object.add(jsVars);
                                }
                                KtExpression ktExpression = this.$expression.getBody();
                                if (ktExpression == null) break block4;
                                Object it3 = object = ktExpression;
                                Collection collection = body.getStatements();
                                JsStatement jsStatement = Translation.translateAsStatement((KtExpression)it3, this.$context.innerBlock(body));
                                collection.add(jsStatement);
                            }
                            return new JsFor((JsVars)initExpression, conditionExpression, incrementExpression, (JsStatement)body);
                        }
                        {
                            this.$context = translationContext;
                            this.$expression = ktForExpression;
                            super(1);
                        }
                    };
                    Function0<ClassDescriptor> findCollection$ = new Function0<ClassDescriptor>(context){
                        final /* synthetic */ TranslationContext $context;

                        @NotNull
                        public final ClassDescriptor invoke() {
                            ModuleDescriptor moduleDescriptor = this.$context.getCurrentModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"context.currentModule");
                            ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.collection);
                            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(KotlinB\u2026tIns.FQ_NAMES.collection)");
                            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
                            if (classDescriptor == null) {
                                Intrinsics.throwNpe();
                            }
                            return classDescriptor;
                        }
                        {
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    translateForOverCollectionIndices$ = new Function1<WithIndexInfo, JsStatement>(context, expression2, findCollection$){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.11 $findCollection$11;

                        @NotNull
                        public final JsStatement invoke(@NotNull WithIndexInfo info) {
                            JsBlock body;
                            JsExpression incrementExpression;
                            JsExpression conditionExpression;
                            Object initExpression;
                            block1: {
                                KtExpression ktExpression;
                                VariableDescriptor variableDescriptor;
                                Object it;
                                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                                JsExpression range = this.$context.cacheExpressionIfNeeded(info.getRange());
                                Object object = info.getIndex();
                                if (object == null || (object = this.$context.getNameForDescriptor((DeclarationDescriptor)(it = (variableDescriptor = object)))) == null) {
                                    object = JsScope.declareTemporary();
                                }
                                Object indexVar = object;
                                Object $receiver = it = JsAstUtils.newVar((JsName)indexVar, new JsIntLiteral(0));
                                ((SourceInfoAwareJsNode)$receiver).setSource(this.$expression);
                                initExpression = it;
                                PropertyDescriptor sizeDescriptor = DescriptorUtils.getPropertyByName(this.$findCollection$11.invoke().getUnsubstitutedMemberScope(), Name.identifier("size"));
                                JsName sizeName = this.$context.getNameForDescriptor(sizeDescriptor);
                                conditionExpression = JsAstUtils.inequality(((JsName)indexVar).makeRef(), new JsNameRef(sizeName, range)).source(this.$expression);
                                incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, ((JsName)indexVar).makeRef()).source(this.$expression);
                                body = new JsBlock();
                                KtExpression ktExpression2 = this.$expression.getBody();
                                if (ktExpression2 == null) break block1;
                                KtExpression it2 = ktExpression = ktExpression2;
                                Collection collection = body.getStatements();
                                JsStatement jsStatement = Translation.translateAsStatement(it2, this.$context.innerBlock(body));
                                collection.add(jsStatement);
                            }
                            return new JsFor((JsVars)initExpression, conditionExpression, incrementExpression, (JsStatement)body);
                        }
                        {
                            this.$context = translationContext;
                            this.$expression = ktForExpression;
                            this.$findCollection$11 = var3_3;
                            super(1);
                        }
                    };
                    Function0<ClassDescriptor> findIterable$ = new Function0<ClassDescriptor>(context){
                        final /* synthetic */ TranslationContext $context;

                        @NotNull
                        public final ClassDescriptor invoke() {
                            ModuleDescriptor moduleDescriptor = this.$context.getCurrentModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"context.currentModule");
                            ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable);
                            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable)");
                            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
                            if (classDescriptor == null) {
                                Intrinsics.throwNpe();
                            }
                            return classDescriptor;
                        }
                        {
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    Function0<ClassDescriptor> findSequence$ = new Function0<ClassDescriptor>(context){
                        final /* synthetic */ TranslationContext $context;

                        @NotNull
                        public final ClassDescriptor invoke() {
                            ModuleDescriptor moduleDescriptor = this.$context.getCurrentModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"context.currentModule");
                            ClassId classId = ClassId.topLevel(LoopTranslator.access$getSequenceFqName$p());
                            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(sequenceFqName)");
                            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
                            if (classDescriptor == null) {
                                Intrinsics.throwNpe();
                            }
                            return classDescriptor;
                        }
                        {
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    translateForOverCollectionWithIndex$ = new Function1<WithIndexInfo, JsStatement>(context, expression2, findSequence$, findIterable$){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.14 $findSequence$14;
                        final /* synthetic */ translateForExpression.13 $findIterable$13;

                        @NotNull
                        public final JsStatement invoke(@NotNull WithIndexInfo info) {
                            Object it;
                            JsStatement jsStatement;
                            Object $receiver;
                            JsStatement $i$a$1$let;
                            JsExpression jsExpression;
                            JsVars jsVars;
                            JsName jsName;
                            Object it2;
                            JsName jsName2;
                            Object it3;
                            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                            JsExpression range = this.$context.cacheExpressionIfNeeded(info.getRange());
                            VariableDescriptor variableDescriptor = info.getIndex();
                            if (variableDescriptor != null) {
                                VariableDescriptor variableDescriptor2 = variableDescriptor;
                                it3 = variableDescriptor2;
                                jsName2 = this.$context.getNameForDescriptor((DeclarationDescriptor)it3);
                            } else {
                                jsName2 = null;
                            }
                            JsName indexVar = jsName2;
                            VariableDescriptor variableDescriptor3 = info.getValue();
                            if (variableDescriptor3 != null) {
                                it2 = it3 = variableDescriptor3;
                                jsName = this.$context.getNameForDescriptor((DeclarationDescriptor)it2);
                            } else {
                                jsName = null;
                            }
                            JsName valueVar = jsName;
                            JsName jsName3 = indexVar;
                            if (jsName3 != null) {
                                it2 = it3 = jsName3;
                                JsVars $i$a$1$let2 = JsAstUtils.newVar((JsName)it2, new JsIntLiteral(0));
                                TranslationContext translationContext = this.$context;
                                JsVars $receiver2 = $i$a$1$let2;
                                $receiver2.setSource(this.$expression);
                                jsVars = $i$a$1$let2;
                                translationContext.addStatementToCurrentBlock(jsVars);
                            }
                            JsName iteratorVar = JsScope.declareTemporary();
                            Object rangeOwner = info.getReceiverType() == WithIndexReceiverType.SEQUENCE ? this.$findSequence$14.invoke() : this.$findIterable$13.invoke();
                            FunctionDescriptor iteratorDescriptor = DescriptorUtils.getFunctionByName(rangeOwner.getUnsubstitutedMemberScope(), Name.identifier("iterator"));
                            JsName iteratorName = this.$context.getNameForDescriptor(iteratorDescriptor);
                            JsVars $receiver3 = jsVars = JsAstUtils.newVar(iteratorVar, new JsInvocation((JsExpression)JsAstUtils.pureFqn(iteratorName, range), new JsExpression[0]));
                            $receiver3.setSource(this.$expression);
                            JsVars initExpression = jsVars;
                            FunctionDescriptor functionDescriptor = iteratorDescriptor;
                            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"iteratorDescriptor");
                            KotlinType kotlinType = functionDescriptor.getReturnType();
                            if (kotlinType == null) {
                                Intrinsics.throwNpe();
                            }
                            ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
                            if (classifierDescriptor == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                            }
                            ClassDescriptor iteratorClassDescriptor = (ClassDescriptor)classifierDescriptor;
                            FunctionDescriptor hasNextDescriptor = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("hasNext"));
                            JsName hasNextName = this.$context.getNameForDescriptor(hasNextDescriptor);
                            JsNode hasNextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(hasNextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source(this.$expression);
                            FunctionDescriptor nextDescriptor = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("next"));
                            JsName nextName = this.$context.getNameForDescriptor(nextDescriptor);
                            JsNode nextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(nextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source(this.$expression);
                            JsName jsName4 = indexVar;
                            if (jsName4 != null) {
                                JsName jsName5;
                                JsName it4 = jsName5 = jsName4;
                                jsExpression = new JsPrefixOperation(JsUnaryOperator.INC, it4.makeRef()).source(this.$expression);
                            } else {
                                jsExpression = null;
                            }
                            JsExpression incrementExpression = jsExpression;
                            JsBlock body = new JsBlock();
                            Object object = body.getStatements();
                            if (valueVar != null) {
                                $i$a$1$let = JsAstUtils.newVar(valueVar, (JsExpression)nextInvocation);
                                $receiver = $i$a$1$let;
                                ((SourceInfoAwareJsNode)$receiver).setSource(this.$expression);
                                jsStatement = $i$a$1$let;
                            } else {
                                jsStatement = JsAstUtils.asSyntheticStatement((JsExpression)nextInvocation);
                            }
                            $i$a$1$let = jsStatement;
                            object.add($i$a$1$let);
                            KtExpression ktExpression = this.$expression.getBody();
                            if (ktExpression != null) {
                                it = object = ktExpression;
                                $receiver = body.getStatements();
                                JsStatement jsStatement2 = Translation.translateAsStatement((KtExpression)it, this.$context.innerBlock(body));
                                $receiver.add(jsStatement2);
                            }
                            it = object = new JsFor(initExpression, (JsExpression)hasNextInvocation, incrementExpression);
                            ((JsFor)it).setBody(body);
                            return (JsStatement)object;
                        }
                        {
                            this.$context = translationContext;
                            this.$expression = ktForExpression;
                            this.$findSequence$14 = var3_3;
                            this.$findIterable$13 = var4_4;
                            super(1);
                        }
                    };
                    translateForOverIterator$ = new Function0<JsStatement>(context, loopRange, expression2, translateBody$){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;

                        @NotNull
                        public final JsStatement invoke() {
                            Object object;
                            List<JsStatement> list2;
                            Object object2;
                            Collection collection;
                            JsExpression jsExpression;
                            Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression> translateMethodInvocation$ = new Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression>(this){
                                final /* synthetic */ translateForExpression.16 this$0;

                                @NotNull
                                public final JsExpression invoke(@Nullable JsExpression receiver, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @NotNull JsBlock block) {
                                    Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
                                    Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                                    TranslationContext translationContext = this.this$0.$context.innerBlock(block);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context.innerBlock(block)");
                                    return CallTranslator.translate(translationContext, resolvedCall2, receiver);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(3);
                                }
                            };
                            Function0<JsExpression> iteratorMethodInvocation$ = new Function0<JsExpression>(this){
                                final /* synthetic */ translateForExpression.16 this$0;

                                @NotNull
                                public final JsExpression invoke() {
                                    JsExpression range = Translation.translateAsExpression(this.this$0.$loopRange, this.this$0.$context);
                                    ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getIteratorFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                                    TranslationContext translationContext = this.this$0.$context;
                                    ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
                                    Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, (String)"resolvedCall");
                                    return CallTranslator.translate(translationContext, resolvedCall3, range);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            };
                            JsExpression iteratorVar = this.$context.defineTemporary((JsExpression)iteratorMethodInvocation$.invoke());
                            Function1<JsBlock, JsExpression> hasNextMethodInvocation$ = new Function1<JsBlock, JsExpression>(this, translateMethodInvocation$, iteratorVar){
                                final /* synthetic */ translateForExpression.16 this$0;
                                final /* synthetic */ translateForExpression.1 $translateMethodInvocation$1;
                                final /* synthetic */ JsExpression $iteratorVar;

                                @NotNull
                                public final JsExpression invoke(@NotNull JsBlock block) {
                                    ResolvedCall<FunctionDescriptor> resolvedCall2;
                                    Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                                    ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = BindingUtils.getHasNextCallable(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                                    Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, (String)"resolvedCall");
                                    return this.$translateMethodInvocation$1.invoke(this.$iteratorVar, resolvedCall3, block);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$translateMethodInvocation$1 = var2_2;
                                    this.$iteratorVar = jsExpression;
                                    super(1);
                                }
                            };
                            JsBlock hasNextBlock = new JsBlock();
                            JsExpression hasNextInvocation = hasNextMethodInvocation$.invoke(hasNextBlock);
                            JsBlock nextBlock = new JsBlock();
                            ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction(this.$context.bindingContext(), this.$loopRange);
                            Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, (String)"getNextFunction(context.\u2026dingContext(), loopRange)");
                            JsExpression nextInvoke = translateMethodInvocation$.invoke(iteratorVar, resolvedCall2, nextBlock);
                            List bodyStatements = new ArrayList<E>();
                            if (hasNextBlock.isEmpty()) {
                                jsExpression = hasNextInvocation;
                            } else {
                                collection = bodyStatements;
                                List<JsStatement> list3 = hasNextBlock.getStatements();
                                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"hasNextBlock.statements");
                                object2 = list3;
                                CollectionsKt.addAll((Collection)collection, (Iterable)object2);
                                collection = bodyStatements;
                                object2 = new JsBreak();
                                JsExpression jsExpression2 = JsAstUtils.notOptimized(hasNextInvocation);
                                Object $receiver = object2;
                                ((SourceInfoAwareJsNode)$receiver).setSource(this.$expression);
                                Object object3 = object2;
                                JsStatement jsStatement = (JsStatement)object3;
                                JsExpression jsExpression3 = jsExpression2;
                                $receiver = object2 = new JsIf(jsExpression3, jsStatement);
                                ((SourceInfoAwareJsNode)$receiver).setSource(this.$expression);
                                collection.add(object2);
                                jsExpression = new JsBooleanLiteral(true);
                            }
                            JsExpression exitCondition = jsExpression;
                            collection = bodyStatements;
                            List<JsStatement> list4 = nextBlock.getStatements();
                            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"nextBlock.statements");
                            object2 = list4;
                            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
                            collection = bodyStatements;
                            JsStatement jsStatement = this.$translateBody$6.invoke(nextInvoke);
                            if (jsStatement != null) {
                                Object p1 = object2 = jsStatement;
                                list2 = JsAstUtils.flattenStatement((JsStatement)p1);
                            } else {
                                list2 = null;
                            }
                            if ((object = (object2 = list2)) == null) {
                                object = CollectionsKt.emptyList();
                            }
                            object2 = (Iterable)object;
                            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
                            JsStatement jsStatement2 = (JsStatement)CollectionsKt.singleOrNull((List)bodyStatements);
                            if (jsStatement2 == null) {
                                jsStatement2 = new JsBlock(bodyStatements);
                            }
                            return new JsWhile(exitCondition, jsStatement2);
                        }
                        {
                            this.$context = translationContext;
                            this.$loopRange = ktExpression;
                            this.$expression = ktForExpression;
                            this.$translateBody$6 = var4_4;
                            super(0);
                        }
                    };
                    Object rangeLiteral = extractForOverRangeLiteral$.invoke();
                    withIndexCall = extractWithIndexCall$.invoke();
                    if (rangeLiteral == null) break block6;
                    object = translateForOverLiteralRange$.invoke((RangeLiteral)rangeLiteral);
                    break block7;
                }
                if (withIndexCall == null) break block8;
                switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$3[((WithIndexInfo)withIndexCall).getReceiverType().ordinal()]) {
                    case 1: {
                        object = translateForOverArrayWithIndex$.invoke((WithIndexInfo)withIndexCall);
                        break block7;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        object = ((WithIndexInfo)withIndexCall).getValue() == null && ((WithIndexInfo)withIndexCall).getReceiverType() == WithIndexReceiverType.COLLECTION ? translateForOverCollectionIndices$.invoke((WithIndexInfo)withIndexCall) : translateForOverCollectionWithIndex$.invoke((WithIndexInfo)withIndexCall);
                        break block7;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            object = isForOverRange$.invoke() ? translateForOverRange$.invoke() : (isForOverArray$.invoke() ? translateForOverArray$.invoke() : translateForOverIterator$.invoke());
        }
        JsStatement $receiver = jsStatement = (result2 = object);
        $receiver.setSource(expression2);
        return jsStatement;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getIntRangeName$p() {
        return intRangeName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getIntProgressionName$p() {
        return intProgressionName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getStepFunctionName$p() {
        return stepFunctionName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getRangeToFunctionName$p() {
        return rangeToFunctionName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getUntilFunctionName$p() {
        return untilFunctionName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getDownToFunctionName$p() {
        return downToFunctionName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getWithIndexFqName$p() {
        return withIndexFqName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getSequenceWithIndexFqName$p() {
        return sequenceWithIndexFqName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getIndicesFqName$p() {
        return indicesFqName;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getSequenceFqName$p() {
        return sequenceFqName;
    }
}

