/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.Serializable;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDiscoveringCompiler;
import org.gradle.api.internal.tasks.compile.ApiGroovyCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompiler;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaHomeBasedJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.JdkJavaCompiler;
import org.gradle.api.internal.tasks.compile.NormalizingGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.DaemonGroovyCompiler;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.internal.Factory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.IsolatedClassloaderWorkerFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerFactory;

public class GroovyCompilerFactory
implements CompilerFactory<GroovyJavaJointCompileSpec> {
    private final ProjectInternal project;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final IsolatedClassloaderWorkerFactory inProcessWorkerFactory;
    private final FileResolver fileResolver;
    private AnnotationProcessorDetector processorDetector;

    public GroovyCompilerFactory(ProjectInternal project, WorkerDaemonFactory workerDaemonFactory, IsolatedClassloaderWorkerFactory inProcessWorkerFactory, FileResolver fileResolver, AnnotationProcessorDetector processorDetector) {
        this.project = project;
        this.workerDaemonFactory = workerDaemonFactory;
        this.inProcessWorkerFactory = inProcessWorkerFactory;
        this.fileResolver = fileResolver;
        this.processorDetector = processorDetector;
    }

    public Compiler<GroovyJavaJointCompileSpec> newCompiler(GroovyJavaJointCompileSpec spec) {
        GroovyCompileOptions groovyOptions = spec.getGroovyCompileOptions();
        Object workerFactory = groovyOptions.isFork() ? this.workerDaemonFactory : this.inProcessWorkerFactory;
        DaemonGroovyCompiler groovyCompiler = new DaemonGroovyCompiler(((WorkerDirectoryProvider)this.project.getServices().get(WorkerDirectoryProvider.class)).getIdleWorkingDirectory(), new DaemonSideCompiler(), (ClassPathRegistry)this.project.getServices().get(ClassPathRegistry.class), (WorkerFactory)workerFactory, this.fileResolver);
        return new AnnotationProcessorDiscoveringCompiler((Compiler)new NormalizingGroovyCompiler((Compiler<GroovyJavaJointCompileSpec>)groovyCompiler), this.processorDetector);
    }

    private static class DaemonSideCompiler
    implements Compiler<GroovyJavaJointCompileSpec>,
    Serializable {
        private DaemonSideCompiler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WorkResult execute(GroovyJavaJointCompileSpec spec) {
            DefaultExecActionFactory execHandleFactory = new DefaultExecActionFactory((FileResolver)new IdentityFileResolver());
            try {
                Object javaCompiler = CommandLineJavaCompileSpec.class.isAssignableFrom(spec.getClass()) ? new CommandLineJavaCompiler((ExecHandleFactory)execHandleFactory) : new JdkJavaCompiler((Factory)new JavaHomeBasedJavaCompilerFactory());
                ApiGroovyCompiler groovyCompiler = new ApiGroovyCompiler((Compiler<JavaCompileSpec>)javaCompiler);
                WorkResult workResult = groovyCompiler.execute((CompileSpec)spec);
                return workResult;
            }
            finally {
                execHandleFactory.stop();
            }
        }
    }
}

