/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.FileTreeSnapshot;
import org.gradle.api.internal.changedetection.state.Snapshot;
import org.gradle.api.internal.changedetection.state.WellKnownFileLocations;
import org.gradle.api.internal.tasks.execution.TaskOutputChangesListener;
import org.gradle.initialization.RootBuildLifecycleListener;

public class DefaultFileSystemMirror
implements FileSystemMirror,
TaskOutputChangesListener,
RootBuildLifecycleListener {
    private final Map<String, FileSnapshot> files = new ConcurrentHashMap<String, FileSnapshot>();
    private final Map<String, FileSnapshot> cacheFiles = new ConcurrentHashMap<String, FileSnapshot>();
    private final Map<String, FileTreeSnapshot> trees = new ConcurrentHashMap<String, FileTreeSnapshot>();
    private final Map<String, FileTreeSnapshot> cacheTrees = new ConcurrentHashMap<String, FileTreeSnapshot>();
    private final Map<String, Snapshot> snapshots = new ConcurrentHashMap<String, Snapshot>();
    private final Map<String, Snapshot> cacheSnapshots = new ConcurrentHashMap<String, Snapshot>();
    private final WellKnownFileLocations wellKnownFileLocations;

    public DefaultFileSystemMirror(WellKnownFileLocations wellKnownFileLocations) {
        this.wellKnownFileLocations = wellKnownFileLocations;
    }

    @Nullable
    public FileSnapshot getFile(String path) {
        if (this.wellKnownFileLocations.isImmutable(path)) {
            return this.cacheFiles.get(path);
        }
        return this.files.get(path);
    }

    public void putFile(FileSnapshot file) {
        if (this.wellKnownFileLocations.isImmutable(file.getPath())) {
            this.cacheFiles.put(file.getPath(), file);
        } else {
            this.files.put(file.getPath(), file);
        }
    }

    @Nullable
    public Snapshot getContent(String path) {
        if (this.wellKnownFileLocations.isImmutable(path)) {
            return this.cacheSnapshots.get(path);
        }
        return this.snapshots.get(path);
    }

    public void putContent(String path, Snapshot snapshot) {
        if (this.wellKnownFileLocations.isImmutable(path)) {
            this.cacheSnapshots.put(path, snapshot);
        } else {
            this.snapshots.put(path, snapshot);
        }
    }

    @Nullable
    public FileTreeSnapshot getDirectoryTree(String path) {
        if (this.wellKnownFileLocations.isImmutable(path)) {
            return this.cacheTrees.get(path);
        }
        return this.trees.get(path);
    }

    public void putDirectory(FileTreeSnapshot directory) {
        if (this.wellKnownFileLocations.isImmutable(directory.getPath())) {
            this.cacheTrees.put(directory.getPath(), directory);
        } else {
            this.trees.put(directory.getPath(), directory);
        }
    }

    public void beforeTaskOutputChanged() {
        this.files.clear();
        this.trees.clear();
        this.snapshots.clear();
    }

    public void afterStart() {
    }

    public void beforeComplete() {
        this.files.clear();
        this.cacheFiles.clear();
        this.trees.clear();
        this.cacheTrees.clear();
        this.snapshots.clear();
        this.cacheSnapshots.clear();
    }
}

