/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProvider<T>
implements ProviderInternal<T> {
    public T get() {
        Object evaluatedValue = this.getOrNull();
        if (evaluatedValue == null) {
            throw new IllegalStateException("No value has been specified for this provider.");
        }
        return (T)evaluatedValue;
    }

    public T getOrElse(T defaultValue) {
        Object value = this.getOrNull();
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(transformer, this);
    }

    public boolean isPresent() {
        return this.getOrNull() != null;
    }

    public String toString() {
        return String.format("provider(%s)", GUtil.elvis(this.getType(), (Object)"?"));
    }
}

