/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.visualstudio.XmlConfigFile;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectMetadata;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.CollectionUtils;
import org.gradle.util.VersionNumber;

public class DefaultVisualStudioProject
implements VisualStudioProjectInternal {
    private final DefaultConfigFile projectFile;
    private final DefaultConfigFile filtersFile;
    private final String name;
    private final String componentName;
    private final VersionNumber visualStudioVersion;
    private final VersionNumber sdkVersion;
    private final List<File> additionalFiles = new ArrayList<File>();
    private final Map<VisualStudioTargetBinary, VisualStudioProjectConfiguration> configurations = new LinkedHashMap<VisualStudioTargetBinary, VisualStudioProjectConfiguration>();
    private final DefaultTaskDependency buildDependencies = new DefaultTaskDependency();

    public DefaultVisualStudioProject(String name, String componentName, VersionNumber visualStudioVersion, VersionNumber sdkVersion, PathToFileResolver fileResolver, Instantiator instantiator) {
        this.name = name;
        this.componentName = componentName;
        this.visualStudioVersion = visualStudioVersion;
        this.sdkVersion = sdkVersion;
        this.projectFile = (DefaultConfigFile)instantiator.newInstance(DefaultConfigFile.class, new Object[]{fileResolver, this.getName() + ".vcxproj"});
        this.filtersFile = (DefaultConfigFile)instantiator.newInstance(DefaultConfigFile.class, new Object[]{fileResolver, this.getName() + ".vcxproj.filters"});
    }

    @Override
    @Input
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public DefaultConfigFile getProjectFile() {
        return this.projectFile;
    }

    @Override
    public DefaultConfigFile getFiltersFile() {
        return this.filtersFile;
    }

    public void addSourceFile(File sourceFile) {
        this.additionalFiles.add(sourceFile);
    }

    public static String getUUID(File projectFile) {
        return "{" + UUID.nameUUIDFromBytes(projectFile.getAbsolutePath().getBytes()).toString().toUpperCase() + "}";
    }

    @Internal
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> allSources = new LinkedHashSet<File>();
        for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
            allSources.addAll(binary.getSourceFiles().getFiles());
        }
        allSources.addAll(this.additionalFiles);
        return allSources;
    }

    @Input
    public Set<String> getSourceFilePaths() {
        return CollectionUtils.collect(this.getSourceFiles(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    @Internal
    public Set<File> getResourceFiles() {
        LinkedHashSet<File> allResources = new LinkedHashSet<File>();
        for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
            allResources.addAll(binary.getResourceFiles().getFiles());
        }
        return allResources;
    }

    @Input
    public Set<String> getResourceFilePaths() {
        return CollectionUtils.collect(this.getResourceFiles(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    @Internal
    public Set<File> getHeaderFiles() {
        LinkedHashSet<File> allHeaders = new LinkedHashSet<File>();
        for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
            allHeaders.addAll(binary.getHeaderFiles().getFiles());
        }
        return allHeaders;
    }

    @Input
    public Set<String> getHeaderFilePaths() {
        return CollectionUtils.collect(this.getHeaderFiles(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    @Nested
    public List<VisualStudioProjectConfiguration> getConfigurations() {
        return CollectionUtils.toList(this.configurations.values());
    }

    public void addConfiguration(VisualStudioTargetBinary nativeBinary, VisualStudioProjectConfiguration configuration) {
        this.configurations.put(nativeBinary, configuration);
        this.builtBy(nativeBinary.getSourceFiles());
        this.builtBy(nativeBinary.getResourceFiles());
        this.builtBy(nativeBinary.getHeaderFiles());
    }

    @Internal
    public VisualStudioProjectConfiguration getConfiguration(VisualStudioTargetBinary nativeBinary) {
        return this.configurations.get(nativeBinary);
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.buildDependencies.add(tasks);
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.buildDependencies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public VersionNumber getVisualStudioVersion() {
        return this.visualStudioVersion;
    }

    public VersionNumber getSdkVersion() {
        return this.sdkVersion;
    }

    @Override
    @Internal
    public IdeProjectMetadata getPublishArtifact() {
        return new VisualStudioProjectMetadata(this);
    }

    @Nested
    public List<Action<? super XmlProvider>> getProjectFileActions() {
        return this.projectFile.getXmlActions();
    }

    @Nested
    public List<Action<? super XmlProvider>> getFiltersFileActions() {
        return this.filtersFile.getXmlActions();
    }

    public static class DefaultConfigFile
    implements XmlConfigFile {
        private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
        private final PathToFileResolver fileResolver;
        private Object location;

        public DefaultConfigFile(PathToFileResolver fileResolver, String defaultLocation) {
            this.fileResolver = fileResolver;
            this.location = defaultLocation;
        }

        @Override
        public File getLocation() {
            return this.fileResolver.resolve(this.location);
        }

        @Override
        public void setLocation(Object location) {
            this.location = location;
        }

        @Override
        public void withXml(Action<? super XmlProvider> action) {
            this.actions.add(action);
        }

        @Nested
        public List<Action<? super XmlProvider>> getXmlActions() {
            return this.actions;
        }
    }
}

