/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class DefaultModuleComponentSelector
implements ModuleComponentSelector {
    private final ModuleIdentifier moduleIdentifier;
    private final ImmutableVersionConstraint versionConstraint;
    private final ImmutableAttributes attributes;
    private final int hashCode;

    private DefaultModuleComponentSelector(ModuleIdentifier module, ImmutableVersionConstraint version, ImmutableAttributes attributes) {
        assert (module != null) : "module cannot be null";
        assert (version != null) : "version cannot be null";
        assert (attributes != null) : "attributes cannot be null";
        this.moduleIdentifier = module;
        this.versionConstraint = version;
        this.attributes = attributes;
        this.hashCode = Objects.hashCode((Object[])new Object[]{version, module, attributes});
    }

    public String getDisplayName() {
        String group = this.moduleIdentifier.getGroup();
        String module = this.moduleIdentifier.getName();
        StringBuilder builder = new StringBuilder(group.length() + module.length() + this.versionConstraint.getPreferredVersion().length() + 2);
        builder.append(group);
        builder.append(":");
        builder.append(module);
        if (this.versionConstraint.getPreferredVersion().length() > 0) {
            builder.append(":");
            builder.append(this.versionConstraint.getPreferredVersion());
        }
        if (this.versionConstraint.getBranch() != null) {
            builder.append(" (branch: ");
            builder.append(this.versionConstraint.getBranch());
            builder.append(")");
        }
        return builder.toString();
    }

    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    public String getModule() {
        return this.moduleIdentifier.getName();
    }

    public String getVersion() {
        return this.versionConstraint.getPreferredVersion();
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)identifier;
            return this.moduleIdentifier.getName().equals(moduleComponentIdentifier.getModule()) && this.moduleIdentifier.getGroup().equals(moduleComponentIdentifier.getGroup()) && this.versionConstraint.getPreferredVersion().equals(moduleComponentIdentifier.getVersion());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentSelector that = (DefaultModuleComponentSelector)o;
        if (!this.moduleIdentifier.equals(that.moduleIdentifier)) {
            return false;
        }
        if (!this.versionConstraint.equals(that.versionConstraint)) {
            return false;
        }
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, VersionConstraint version, AttributeContainer attributes) {
        assert (attributes != null) : "attributes cannot be null";
        assert (version != null) : "version cannot be null";
        DefaultModuleComponentSelector.assertModuleIdentifier(id);
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ((AttributeContainerInternal)attributes).asImmutable());
    }

    private static void assertModuleIdentifier(ModuleIdentifier id) {
        assert (id.getGroup() != null) : "group cannot be null";
        assert (id.getName() != null) : "name cannot be null";
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, VersionConstraint version) {
        assert (version != null) : "version cannot be null";
        DefaultModuleComponentSelector.assertModuleIdentifier(id);
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY);
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, String version) {
        DefaultModuleComponentSelector.assertModuleIdentifier(id);
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY);
    }

    public static ModuleComponentSelector newSelector(ModuleVersionSelector selector) {
        return new DefaultModuleComponentSelector(selector.getModule(), DefaultImmutableVersionConstraint.of(selector.getVersion()), ImmutableAttributes.EMPTY);
    }
}

