/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.TextFragment;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.CharUtilities;

public class GlyphMapping {
    private static final Log LOG = LogFactory.getLog(GlyphMapping.class);
    public final int startIndex;
    public final int endIndex;
    private int wordCharLength;
    public final int wordSpaceCount;
    public int letterSpaceCount;
    public MinOptMax areaIPD;
    public final boolean isHyphenated;
    public final boolean isSpace;
    public boolean breakOppAfter;
    public final Font font;
    public final int level;
    public final int[][] gposAdjustments;
    public String mapping;
    public List associations;

    public GlyphMapping(int startIndex, int endIndex, int wordSpaceCount, int letterSpaceCount, MinOptMax areaIPD, boolean isHyphenated, boolean isSpace, boolean breakOppAfter, Font font, int level, int[][] gposAdjustments) {
        this(startIndex, endIndex, wordSpaceCount, letterSpaceCount, areaIPD, isHyphenated, isSpace, breakOppAfter, font, level, gposAdjustments, null, null);
    }

    public GlyphMapping(int startIndex, int endIndex, int wordSpaceCount, int letterSpaceCount, MinOptMax areaIPD, boolean isHyphenated, boolean isSpace, boolean breakOppAfter, Font font, int level, int[][] gposAdjustments, String mapping, List associations) {
        assert (startIndex <= endIndex);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.wordCharLength = -1;
        this.wordSpaceCount = wordSpaceCount;
        this.letterSpaceCount = letterSpaceCount;
        this.areaIPD = areaIPD;
        this.isHyphenated = isHyphenated;
        this.isSpace = isSpace;
        this.breakOppAfter = breakOppAfter;
        this.font = font;
        this.level = level;
        this.gposAdjustments = gposAdjustments;
        this.mapping = mapping;
        this.associations = associations;
    }

    public static GlyphMapping doGlyphMapping(TextFragment text, int startIndex, int endIndex, Font font, MinOptMax letterSpaceIPD, MinOptMax[] letterSpaceAdjustArray, char precedingChar, char breakOpportunityChar, boolean endsWithHyphen, int level, boolean dontOptimizeForIdentityMapping, boolean retainAssociations, boolean retainControls) {
        GlyphMapping mapping = font.performsSubstitution() || font.performsPositioning() ? GlyphMapping.processWordMapping(text, startIndex, endIndex, font, breakOpportunityChar, endsWithHyphen, level, dontOptimizeForIdentityMapping, retainAssociations, retainControls) : GlyphMapping.processWordNoMapping(text, startIndex, endIndex, font, letterSpaceIPD, letterSpaceAdjustArray, precedingChar, breakOpportunityChar, endsWithHyphen, level);
        return mapping;
    }

    private static GlyphMapping processWordMapping(TextFragment text, int startIndex, int endIndex, Font font, char breakOpportunityChar, boolean endsWithHyphen, int level, boolean dontOptimizeForIdentityMapping, boolean retainAssociations, boolean retainControls) {
        int e = endIndex;
        int nLS = 0;
        String script = text.getScript();
        String language = text.getLanguage();
        if (LOG.isDebugEnabled()) {
            LOG.debug("PW: [" + startIndex + "," + endIndex + "]: {" + " +M" + ", level = " + level + " }");
        }
        CharSequence ics = text.subSequence(startIndex, e);
        if (script == null || "auto".equals(script)) {
            script = CharScript.scriptTagFromCode((int)CharScript.dominantScript((CharSequence)ics));
        }
        if (language == null || "none".equals(language)) {
            language = "dflt";
        }
        ArrayList associations = retainAssociations ? new ArrayList() : null;
        CharSequence mcs = font.performSubstitution(ics, script, language, associations, retainControls);
        int[][] gpa = null;
        if (font.performsPositioning()) {
            gpa = font.performPositioning(mcs, script, language);
        }
        if (GlyphMapping.useKerningAdjustments(font, script, language)) {
            gpa = GlyphMapping.getKerningAdjustments(mcs, font, gpa);
        }
        mcs = font.reorderCombiningMarks(mcs, gpa, script, language, associations);
        MinOptMax ipd = MinOptMax.ZERO;
        int n = mcs.length();
        for (int i = 0; i < n; ++i) {
            char c = mcs.charAt(i);
            int w = font.getCharWidth((int)c);
            if (w < 0) {
                w = 0;
            }
            if (gpa != null) {
                w += gpa[i][2];
            }
            ipd = ipd.plus(w);
        }
        return new GlyphMapping(startIndex, e, 0, nLS, ipd, endsWithHyphen, false, breakOpportunityChar != '\u0000', font, level, gpa, (String)(!dontOptimizeForIdentityMapping && CharUtilities.isSameSequence(mcs, ics) ? null : ((Object)mcs).toString()), associations);
    }

    private static boolean useKerningAdjustments(Font font, String script, String language) {
        return font.hasKerning() && !font.hasFeature(2, script, language, "kern");
    }

    private static int[][] getKerningAdjustments(CharSequence mcs, Font font, int[][] gpa) {
        int i;
        int nc = mcs.length();
        int[] ka = new int[nc];
        int n = nc;
        int cPrev = -1;
        for (int i2 = 0; i2 < n; ++i2) {
            char c = mcs.charAt(i2);
            if (cPrev >= 0) {
                ka[i2] = font.getKernValue(cPrev, (int)c);
            }
            cPrev = c;
        }
        boolean hasKerning = false;
        int n2 = nc;
        for (i = 0; i < n2; ++i) {
            if (ka[i] == 0) continue;
            hasKerning = true;
            break;
        }
        if (hasKerning) {
            if (gpa == null) {
                gpa = new int[nc][4];
            }
            n2 = nc;
            for (i = 0; i < n2; ++i) {
                if (i <= 0) continue;
                int[] nArray = gpa[i - 1];
                nArray[2] = nArray[2] + ka[i];
            }
            return gpa;
        }
        return null;
    }

    private static GlyphMapping processWordNoMapping(TextFragment text, int startIndex, int endIndex, Font font, MinOptMax letterSpaceIPD, MinOptMax[] letterSpaceAdjustArray, char precedingChar, char breakOpportunityChar, boolean endsWithHyphen, int level) {
        int kern;
        boolean kerning = font.hasKerning();
        MinOptMax wordIPD = MinOptMax.ZERO;
        if (LOG.isDebugEnabled()) {
            LOG.debug("PW: [" + startIndex + "," + endIndex + "]: {" + " -M" + ", level = " + level + " }");
        }
        for (int i = startIndex; i < endIndex; ++i) {
            char currentChar = text.charAt(i);
            int charWidth = font.getCharWidth(currentChar);
            wordIPD = wordIPD.plus(charWidth);
            if (!kerning) continue;
            int kern2 = 0;
            if (i > startIndex) {
                char previousChar = text.charAt(i - 1);
                kern2 = font.getKernValue(previousChar, currentChar);
            } else if (precedingChar != '\u0000') {
                kern2 = font.getKernValue(precedingChar, currentChar);
            }
            if (kern2 == 0) continue;
            GlyphMapping.addToLetterAdjust(letterSpaceAdjustArray, i, kern2);
            wordIPD = wordIPD.plus(kern2);
        }
        if (kerning && breakOpportunityChar != '\u0000' && !GlyphMapping.isSpace(breakOpportunityChar) && endIndex > 0 && endsWithHyphen && (kern = font.getKernValue(text.charAt(endIndex - 1), breakOpportunityChar)) != 0) {
            GlyphMapping.addToLetterAdjust(letterSpaceAdjustArray, endIndex, kern);
        }
        int wordLength = endIndex - startIndex;
        int letterSpaces = 0;
        if (wordLength != 0) {
            letterSpaces = wordLength - 1;
            if (breakOpportunityChar != '\u0000' && !GlyphMapping.isSpace(breakOpportunityChar)) {
                ++letterSpaces;
            }
        }
        assert (letterSpaces >= 0);
        wordIPD = wordIPD.plus(letterSpaceIPD.mult(letterSpaces));
        return new GlyphMapping(startIndex, endIndex, 0, letterSpaces, wordIPD, endsWithHyphen, false, breakOpportunityChar != '\u0000' && !GlyphMapping.isSpace(breakOpportunityChar), font, level, null);
    }

    private static void addToLetterAdjust(MinOptMax[] letterSpaceAdjustArray, int index, int width) {
        letterSpaceAdjustArray[index] = letterSpaceAdjustArray[index] == null ? MinOptMax.getInstance(width) : letterSpaceAdjustArray[index].plus(width);
    }

    public static boolean isSpace(char ch) {
        return ch == ' ' || CharUtilities.isNonBreakableSpace(ch) || CharUtilities.isFixedWidthSpace(ch);
    }

    public int getWordLength() {
        if (this.wordCharLength == -1) {
            if (this.mapping != null) {
                this.wordCharLength = this.mapping.length();
            } else {
                assert (this.endIndex >= this.startIndex);
                this.wordCharLength = this.endIndex - this.startIndex;
            }
        }
        return this.wordCharLength;
    }

    public void addToAreaIPD(MinOptMax idp) {
        this.areaIPD = this.areaIPD.plus(idp);
    }

    public String toString() {
        return super.toString() + "{" + "interval = [" + this.startIndex + "," + this.endIndex + "]" + ", isSpace = " + this.isSpace + ", level = " + this.level + ", areaIPD = " + this.areaIPD + ", letterSpaceCount = " + this.letterSpaceCount + ", wordSpaceCount = " + this.wordSpaceCount + ", isHyphenated = " + this.isHyphenated + ", font = " + this.font + "}";
    }
}

