/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;

public class FlickEvent
implements Event {
    private static final long serialVersionUID = -2305607021385835330L;
    private float xDirection;
    private float yDirection;
    private float speedLevel;

    public FlickEvent() {
        this.xDirection = 0.0f;
        this.yDirection = 0.0f;
        this.speedLevel = 0.0f;
    }

    public FlickEvent(float absx, float absy) {
    }

    public FlickEvent(int _speedLevel, int _xDirection, int _yDirection) {
        this.speedLevel = _speedLevel;
        this.xDirection = _xDirection;
        this.yDirection = _yDirection;
    }

    public FlickEvent(byte[] data) {
        if (data.length < 12) {
            System.err.println("Error constructing Flick Event.");
        } else {
            this.speedLevel = Converter.byteArrayToFloat(data, 0);
            this.xDirection = Converter.byteArrayToFloat(data, 4);
            this.yDirection = Converter.byteArrayToFloat(data, 8);
        }
    }

    public float getSpeedLevel() {
        return this.speedLevel;
    }

    public float getXdirection() {
        return this.xDirection;
    }

    public float getYdirection() {
        return this.yDirection;
    }

    @Override
    public int getEventType() {
        return 6;
    }

    public String toString() {
        String ret = "Flick Event";
        return ret;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[16];
        Converter.intToByteArray(data, 0, this.getEventType());
        Converter.floatToByteArray(data, 4, this.speedLevel);
        Converter.floatToByteArray(data, 8, this.xDirection);
        Converter.floatToByteArray(data, 12, this.yDirection);
        return data;
    }
}

