/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.Lst;
import jspecview.common.Coordinate;
import jspecview.common.ScaleData;
import jspecview.common.Spectrum;

public class ViewData {
    private ScaleData[] scaleData;
    private ScaleData thisScale;
    private int nSpectra;
    private int iThisScale;
    private Lst<Spectrum> spectra;

    public ScaleData[] getScaleData() {
        return this.scaleData;
    }

    public ScaleData getScale() {
        return this.thisScale;
    }

    public ViewData(Lst<Spectrum> lst, double d, double d2, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        this.nSpectra = bl2 ? 1 : lst.size();
        this.scaleData = new ScaleData[this.nSpectra];
        for (int i = 0; i < this.nSpectra; ++i) {
            this.scaleData[i] = new ScaleData(nArray[i], nArray2[i]);
        }
        this.init(lst, d, d2, bl);
    }

    public ViewData(Lst<Spectrum> lst, double d, double d2, boolean bl) {
        this.nSpectra = lst.size();
        int n = ((Spectrum)lst.get(0)).getXYCoords().length;
        this.scaleData = new ScaleData[1];
        this.scaleData[0] = new ScaleData(0, n - 1);
        this.init(lst, d, d2, bl);
    }

    void init(Lst<Spectrum> lst, double d, double d2, boolean bl) {
        if (lst == null) {
            lst = this.spectra;
        } else {
            this.spectra = lst;
        }
        this.iThisScale = 0;
        this.thisScale = this.scaleData[0];
        for (int i = 0; i < this.scaleData.length; ++i) {
            this.scaleData[i].userYFactor = ((Spectrum)lst.get(i)).getUserYFactor();
            this.scaleData[i].spectrumYRef = ((Spectrum)lst.get(i)).getYRef();
        }
        this.resetScaleFactors();
        double d3 = Coordinate.getMinX(lst, this);
        double d4 = Coordinate.getMaxX(lst, this);
        double d5 = Coordinate.getMinYUser(lst, this);
        double d6 = Coordinate.getMaxYUser(lst, this);
        if (d != d2 && (d5 = d) > (d6 = d2)) {
            double d7 = d5;
            d5 = d6;
            d6 = d7;
        }
        boolean bl2 = ((Spectrum)lst.get(0)).isInverted();
        for (int i = 0; i < this.scaleData.length; ++i) {
            this.scaleData[i].setMinMax(d3, d4, d5, d6);
            this.scaleData[i].setScale(bl, bl2);
        }
    }

    public void newSpectrum(Lst<Spectrum> lst) {
        this.init(lst, 0.0, 0.0, false);
    }

    public void setXRangeForSubSpectrum(Coordinate[] coordinateArray) {
        this.setXRange(0, coordinateArray, this.scaleData[0].minX, this.scaleData[0].maxX, 0, coordinateArray.length - 1);
    }

    private int setXRange(int n, Coordinate[] coordinateArray, double d, double d2, int n2, int n3) {
        double d3;
        int n4 = 0;
        int n5 = 0;
        for (n4 = n2; n4 <= n3; ++n4) {
            d3 = coordinateArray[n4].getXVal();
            if (!(d3 >= d)) continue;
            this.scaleData[n % this.scaleData.length].startDataPointIndex = n4;
            break;
        }
        while (n4 <= n3) {
            d3 = coordinateArray[n4].getXVal();
            ++n5;
            if (d3 >= d2) break;
            ++n4;
        }
        this.scaleData[n % this.scaleData.length].endDataPointIndex = n4 - 1;
        return n5;
    }

    public int getStartingPointIndex(int n) {
        return this.scaleData[n % this.scaleData.length].startDataPointIndex;
    }

    public int getEndingPointIndex(int n) {
        return this.scaleData[n % this.scaleData.length].endDataPointIndex;
    }

    public boolean areYScalesSame(int n, int n2) {
        return this.scaleData[n %= this.scaleData.length].minYOnScale == this.scaleData[n2 %= this.scaleData.length].minYOnScale && this.scaleData[n].maxYOnScale == this.scaleData[n2].maxYOnScale;
    }

    public void setScale(int n, int n2, int n3, boolean bl) {
        this.iThisScale = n % this.scaleData.length;
        this.thisScale = this.scaleData[this.iThisScale];
        this.thisScale.setXYScale(n2, n3, bl);
    }

    public void resetScaleFactors() {
        for (int i = 0; i < this.scaleData.length; ++i) {
            this.scaleData[i].spectrumScaleFactor = 1.0;
        }
    }

    public void scaleSpectrum(int n, double d) {
        if (d <= 0.0 || n >= this.nSpectra) {
            return;
        }
        if (n == -2) {
            this.thisScale.scale2D(d);
            return;
        }
        if (n < 0) {
            for (n = 0; n < this.scaleData.length; ++n) {
                this.scaleData[n].scaleBy(d);
            }
        } else {
            this.scaleData[n % this.scaleData.length].scaleBy(d);
        }
    }

    public ScaleData[] getNewScales(int n, boolean bl, double d, double d2) {
        int n2;
        if (bl) {
            return this.scaleData;
        }
        n %= this.scaleData.length;
        double d3 = (d - this.thisScale.minYOnScale) / (this.thisScale.maxYOnScale - this.thisScale.minYOnScale);
        double d4 = (d2 - this.thisScale.minYOnScale) / (this.thisScale.maxYOnScale - this.thisScale.minYOnScale);
        ScaleData[] scaleDataArray = new ScaleData[this.scaleData.length];
        for (n2 = 0; n2 < this.scaleData.length; ++n2) {
            scaleDataArray[n2] = n >= 0 && n2 != n ? this.scaleData[n2] : new ScaleData();
        }
        ScaleData.copyScaleFactors(this.scaleData, scaleDataArray);
        ScaleData.copyYScales(this.scaleData, scaleDataArray);
        for (n2 = 0; n2 < this.scaleData.length; ++n2) {
            if (n >= 0 && n2 != n) continue;
            scaleDataArray[n2].isShiftZoomedY = true;
            scaleDataArray[n2].minYOnScale = this.scaleData[n2].minYOnScale * (1.0 - d3) + d3 * this.scaleData[n2].maxYOnScale;
            scaleDataArray[n2].maxYOnScale = this.scaleData[n2].minYOnScale * (1.0 - d4) + d4 * this.scaleData[n2].maxYOnScale;
        }
        return scaleDataArray;
    }
}

