/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.help.HelpBrowserHistory;
import org.openstreetmap.josm.gui.help.HelpContentReader;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.IHelpBrowser;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.gui.widgets.JosmHTMLEditorKit;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;

public class HelpBrowser
extends JFrame
implements IHelpBrowser {
    private static HelpBrowser instance;
    private JMenuItem windowMenuItem;
    private JosmEditorPane help;
    private transient HelpBrowserHistory history;
    private String url;
    private final transient HelpContentReader reader = new HelpContentReader(HelpUtil.getWikiBaseUrl());
    private static final JosmAction FOCUS_ACTION;

    public HelpBrowser() {
        this.build();
    }

    public static synchronized HelpBrowser getInstance() {
        if (instance == null) {
            instance = new HelpBrowser();
        }
        return instance;
    }

    public static void setUrlForHelpTopic(String helpTopic) {
        HelpBrowser browser = HelpBrowser.getInstance();
        SwingUtilities.invokeLater(() -> {
            browser.openHelpTopic(helpTopic);
            browser.setVisible(true);
            browser.toFront();
        });
    }

    public static void launchBrowser(String helpTopic) {
        HelpBrowser browser = HelpBrowser.getInstance();
        browser.openHelpTopic(helpTopic);
        browser.setVisible(true);
        browser.toFront();
    }

    protected StyleSheet buildStyleSheet() {
        String css;
        StyleSheet ss = new StyleSheet();
        try (CachedFile cf = new CachedFile("resource://data/help-browser.css");){
            css = new String(cf.getByteContent(), StandardCharsets.ISO_8859_1);
        }
        catch (IOException e) {
            Logging.error(I18n.tr("Failed to read CSS file ''help-browser.css''. Exception is: {0}", e.toString()));
            Logging.error(e);
            return ss;
        }
        ss.addRule(css);
        return ss;
    }

    protected JToolBar buildToolBar() {
        JToolBar tb = new JToolBar();
        tb.add(new JButton(new HomeAction(this)));
        tb.add(new JButton(new BackAction(this)));
        tb.add(new JButton(new ForwardAction(this)));
        tb.add(new JButton(new ReloadAction(this)));
        tb.add(new JSeparator());
        tb.add(new JButton(new OpenInBrowserAction(this)));
        tb.add(new JButton(new EditAction(this)));
        return tb;
    }

    protected final void build() {
        this.help = new JosmEditorPane();
        JosmHTMLEditorKit kit = new JosmHTMLEditorKit();
        kit.setStyleSheet(this.buildStyleSheet());
        this.help.setEditorKit(kit);
        this.help.setEditable(false);
        this.help.addHyperlinkListener(new HyperlinkHandler());
        this.help.setContentType("text/html");
        this.history = new HelpBrowserHistory(this);
        JPanel p = new JPanel(new BorderLayout());
        this.setContentPane(p);
        p.add((Component)new JScrollPane(this.help), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HelpBrowser.this.setVisible(false);
            }
        });
        p.add((Component)this.buildToolBar(), "North");
        InputMapUtils.addEscapeAction(this.getRootPane(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpBrowser.this.setVisible(false);
            }
        });
        this.setMinimumSize(new Dimension(400, 200));
        this.setTitle(I18n.tr("JOSM Help Browser", new Object[0]));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(600, 400))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        MainMenu menu = MainApplication.getMenu();
        if (menu != null && menu.windowMenu != null) {
            if (this.windowMenuItem != null && !visible) {
                menu.windowMenu.remove(this.windowMenuItem);
                this.windowMenuItem = null;
            }
            if (this.windowMenuItem == null && visible) {
                this.windowMenuItem = MainMenu.add(menu.windowMenu, FOCUS_ACTION, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
            }
        }
        super.setVisible(visible);
    }

    protected void loadTopic(String content) {
        Document document = this.help.getEditorKit().createDefaultDocument();
        try {
            this.help.getEditorKit().read(new StringReader(content), document, 0);
        }
        catch (IOException | BadLocationException e) {
            Logging.error(e);
        }
        this.help.setDocument(document);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    protected void handleMissingHelpContent(String relativeHelpTopic) {
        String message = I18n.tr("<html><p class=\"warning-header\">Help content for help topic missing</p><p class=\"warning-body\">Help content for the help topic <strong>{0}</strong> is not available yet. It is missing both in your local language ({1}) and in English.<br><br>Please help to improve the JOSM help system and fill in the missing information. You can both edit the <a href=\"{2}\">help topic in your local language ({1})</a> and the <a href=\"{3}\">help topic in English</a>.</p></html>", relativeHelpTopic, Locale.getDefault().getDisplayName(), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.DEFAULT)), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.ENGLISH)));
        this.loadTopic(message);
    }

    protected void handleHelpContentReaderException(String relativeHelpTopic, HelpContentReaderException e) {
        String message = I18n.tr("<html><p class=\"error-header\">Error when retrieving help information</p><p class=\"error-body\">The content for the help topic <strong>{0}</strong> could not be loaded. The error message is (untranslated):<br><tt>{1}</tt></p></html>", relativeHelpTopic, e.toString());
        this.loadTopic(message);
    }

    protected void loadRelativeHelpTopic(String relativeHelpTopic) {
        String url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.DEFAULTNOTENGLISH));
        String content = null;
        try {
            content = this.reader.fetchHelpTopicContent(url, true);
        }
        catch (MissingHelpContentException e) {
            Logging.trace(e);
            url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.BASELANGUAGE));
            try {
                content = this.reader.fetchHelpTopicContent(url, true);
            }
            catch (MissingHelpContentException e1) {
                Logging.trace(e1);
                url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.ENGLISH));
                try {
                    content = this.reader.fetchHelpTopicContent(url, true);
                }
                catch (MissingHelpContentException e2) {
                    Logging.debug(e2);
                    this.url = url;
                    this.handleMissingHelpContent(relativeHelpTopic);
                    return;
                }
                catch (HelpContentReaderException e2) {
                    Logging.error(e2);
                    this.handleHelpContentReaderException(relativeHelpTopic, e2);
                    return;
                }
            }
            catch (HelpContentReaderException e1) {
                Logging.error(e1);
                this.handleHelpContentReaderException(relativeHelpTopic, e1);
                return;
            }
        }
        catch (HelpContentReaderException e) {
            Logging.error(e);
            this.handleHelpContentReaderException(relativeHelpTopic, e);
            return;
        }
        this.loadTopic(content);
        this.history.setCurrentUrl(url);
        this.url = url;
    }

    protected void loadAbsoluteHelpTopic(String absoluteHelpTopic) {
        String url = HelpUtil.getHelpTopicUrl(absoluteHelpTopic);
        String content = null;
        try {
            content = this.reader.fetchHelpTopicContent(url, true);
        }
        catch (MissingHelpContentException e) {
            Logging.debug(e);
            this.url = url;
            this.handleMissingHelpContent(absoluteHelpTopic);
            return;
        }
        catch (HelpContentReaderException e) {
            Logging.error(e);
            this.handleHelpContentReaderException(absoluteHelpTopic, e);
            return;
        }
        this.loadTopic(content);
        this.history.setCurrentUrl(url);
        this.url = url;
    }

    @Override
    public void openUrl(String url) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        String helpTopic = HelpUtil.extractAbsoluteHelpTopic(url);
        if (helpTopic == null) {
            try {
                this.url = url;
                String content = this.reader.fetchHelpTopicContent(url, false);
                this.loadTopic(content);
                this.history.setCurrentUrl(url);
                this.url = url;
            }
            catch (HelpContentReaderException e) {
                Logging.warn(e);
                HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>Failed to open help page for url {0}.<br>This is most likely due to a network problem, please check<br>your internet connection</html>", url), I18n.tr("Failed to open URL", new Object[0]), 0, null, null, null, null);
            }
            this.history.setCurrentUrl(url);
        } else {
            this.loadAbsoluteHelpTopic(helpTopic);
        }
    }

    @Override
    public void openHelpTopic(String relativeHelpTopic) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        this.loadRelativeHelpTopic(relativeHelpTopic);
    }

    @Override
    public HelpBrowserHistory getHistory() {
        return this.history;
    }

    static {
        FOCUS_ACTION = new JosmAction(I18n.tr("JOSM Help Browser", new Object[0]), "help", "", null, false, false){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpBrowser.getInstance().setVisible(true);
            }
        };
    }

    class HyperlinkHandler
    implements HyperlinkListener {
        HyperlinkHandler() {
        }

        protected boolean scrollToElementWithId(String id) {
            Document d = HelpBrowser.this.help.getDocument();
            if (d instanceof HTMLDocument) {
                HTMLDocument doc = (HTMLDocument)d;
                Element element = doc.getElement(id);
                try {
                    Rectangle r = HelpBrowser.this.help.modelToView(element.getStartOffset());
                    if (r != null) {
                        Rectangle vis = HelpBrowser.this.help.getVisibleRect();
                        r.height = vis.height;
                        HelpBrowser.this.help.scrollRectToVisible(r);
                        return true;
                    }
                }
                catch (BadLocationException e) {
                    Logging.warn(I18n.tr("Bad location in HTML document. Exception was: {0}", e.toString()));
                    Logging.error(e);
                }
            }
            return false;
        }

        protected String getUrlFragment(HyperlinkEvent e) {
            AttributeSet set = e.getSourceElement().getAttributes();
            Object value = set.getAttribute(HTML.Tag.A);
            if (!(value instanceof SimpleAttributeSet)) {
                return null;
            }
            SimpleAttributeSet atts = (SimpleAttributeSet)value;
            if ((value = atts.getAttribute(HTML.Attribute.HREF)) == null) {
                return null;
            }
            String s = (String)value;
            Matcher m = Pattern.compile("(?:" + HelpBrowser.this.url + ")?#(.+)").matcher(s);
            if (m.matches()) {
                return m.group(1);
            }
            return null;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (e.getURL() == null || e.getURL().toExternalForm().startsWith(HelpBrowser.this.url + '#')) {
                String fragment = this.getUrlFragment(e);
                if (fragment != null) {
                    if (!this.scrollToElementWithId(fragment)) {
                        HelpBrowser.this.help.scrollToReference(fragment);
                    }
                } else {
                    HelpAwareOptionPane.showOptionDialog(instance, I18n.tr("Failed to open help page. The target URL is empty.", new Object[0]), I18n.tr("Failed to open help page", new Object[0]), 0, null, null, null, null);
                }
            } else if (e.getURL().toExternalForm().endsWith("action=edit")) {
                OpenBrowser.displayUrl(e.getURL().toExternalForm());
            } else {
                HelpBrowser.this.url = e.getURL().toExternalForm();
                if (HelpBrowser.this.url.startsWith(HelpUtil.getWikiBaseUrl())) {
                    HelpBrowser.this.openUrl(HelpBrowser.this.url);
                } else {
                    OpenBrowser.displayUrl(HelpBrowser.this.url);
                }
            }
        }
    }

    static class HomeAction
    extends AbstractBrowserAction {
        HomeAction(IHelpBrowser browser) {
            super(browser);
            this.putValue("ShortDescription", I18n.tr("Go to the JOSM help home page", new Object[0]));
            new ImageProvider("help", "home").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.browser.openHelpTopic("/");
        }
    }

    static class ForwardAction
    extends AbstractBrowserAction
    implements ChangeListener {
        ForwardAction(IHelpBrowser browser) {
            super(browser);
            browser.getHistory().addChangeListener(this);
            this.putValue("ShortDescription", I18n.tr("Go to the next page", new Object[0]));
            new ImageProvider("dialogs", "next").getResource().attachImageIcon(this, true);
            this.setEnabled(browser.getHistory().canGoForward());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.browser.getHistory().forward();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setEnabled(this.browser.getHistory().canGoForward());
        }
    }

    static class BackAction
    extends AbstractBrowserAction
    implements ChangeListener {
        BackAction(IHelpBrowser browser) {
            super(browser);
            browser.getHistory().addChangeListener(this);
            this.putValue("ShortDescription", I18n.tr("Go to the previous page", new Object[0]));
            new ImageProvider("dialogs", "previous").getResource().attachImageIcon(this, true);
            this.setEnabled(browser.getHistory().canGoBack());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.browser.getHistory().back();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setEnabled(this.browser.getHistory().canGoBack());
        }
    }

    static class ReloadAction
    extends AbstractBrowserAction {
        ReloadAction(IHelpBrowser browser) {
            super(browser);
            this.putValue("ShortDescription", I18n.tr("Reload the current help page", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.browser.openUrl(this.browser.getUrl());
        }
    }

    static class EditAction
    extends AbstractBrowserAction {
        EditAction(IHelpBrowser browser) {
            super(browser);
            this.putValue("ShortDescription", I18n.tr("Edit the current help page", new Object[0]));
            new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url = this.browser.getUrl();
            if (url == null) {
                return;
            }
            if (!url.startsWith(HelpUtil.getWikiBaseHelpUrl())) {
                String message = I18n.tr("<html>The current URL <tt>{0}</tt><br>is an external URL. Editing is only possible for help topics<br>on the help server <tt>{1}</tt>.</html>", url, HelpUtil.getWikiBaseUrl());
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(Main.parent, message, I18n.tr("Warning", new Object[0]), 2);
                }
                return;
            }
            url = url.replaceAll("#[^#]*$", "");
            OpenBrowser.displayUrl(url + "?action=edit");
        }
    }

    static class OpenInBrowserAction
    extends AbstractBrowserAction {
        OpenInBrowserAction(IHelpBrowser browser) {
            super(browser);
            this.putValue("ShortDescription", I18n.tr("Open the current help page in an external browser", new Object[0]));
            new ImageProvider("help", "internet").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OpenBrowser.displayUrl(this.browser.getUrl());
        }
    }

    static abstract class AbstractBrowserAction
    extends AbstractAction {
        protected final transient IHelpBrowser browser;

        protected AbstractBrowserAction(IHelpBrowser browser) {
            this.browser = browser;
        }
    }
}

