/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Locale;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

@FunctionalInterface
public interface RotationAngle {
    public static final RotationAngle NO_ROTATION = new StaticRotationAngle(0.0);

    public double getRotationAngle(IPrimitive var1);

    public static RotationAngle buildStaticRotation(double angle) {
        return new StaticRotationAngle(angle);
    }

    public static RotationAngle buildStaticRotation(String string) {
        try {
            return RotationAngle.buildStaticRotation(RotationAngle.parseCardinalRotation(string));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid string: " + string, e);
        }
    }

    public static double parseCardinalRotation(String cardinal) {
        switch (cardinal.toLowerCase(Locale.ENGLISH)) {
            case "n": 
            case "north": {
                return 0.0;
            }
            case "ne": 
            case "northeast": {
                return Utils.toRadians(45.0);
            }
            case "e": 
            case "east": {
                return Utils.toRadians(90.0);
            }
            case "se": 
            case "southeast": {
                return Utils.toRadians(135.0);
            }
            case "s": 
            case "south": {
                return Math.PI;
            }
            case "sw": 
            case "southwest": {
                return Utils.toRadians(225.0);
            }
            case "w": 
            case "west": {
                return Utils.toRadians(270.0);
            }
            case "nw": 
            case "northwest": {
                return Utils.toRadians(315.0);
            }
        }
        throw new IllegalArgumentException("Unexpected cardinal direction " + cardinal);
    }

    public static RotationAngle buildWayDirectionRotation() {
        return new WayDirectionRotationAngle();
    }

    public static final class StaticRotationAngle
    implements RotationAngle {
        private final double angle;

        private StaticRotationAngle(double angle) {
            this.angle = angle;
        }

        @Override
        public double getRotationAngle(IPrimitive p) {
            return this.angle;
        }

        public String toString() {
            return this.angle + "rad";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.angle);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StaticRotationAngle other = (StaticRotationAngle)obj;
            return Double.doubleToLongBits(this.angle) == Double.doubleToLongBits(other.angle);
        }
    }

    public static final class WayDirectionRotationAngle
    implements RotationAngle {
        @Override
        public double getRotationAngle(IPrimitive p) {
            if (!(p instanceof Node)) {
                return 0.0;
            }
            Node n = (Node)p;
            SubclassFilteredCollection<OsmPrimitive, Way> ways = Utils.filteredCollection(n.getReferrers(), Way.class);
            if (ways.isEmpty()) {
                return 0.0;
            }
            Way w = ways.iterator().next();
            int idx = w.getNodes().indexOf(n);
            if (idx == 0) {
                return -Geometry.getSegmentAngle(n.getEastNorth(), w.getNode(idx + 1).getEastNorth());
            }
            return -Geometry.getSegmentAngle(w.getNode(idx - 1).getEastNorth(), n.getEastNorth());
        }

        public String toString() {
            return "way-direction";
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }
}

