/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.annotation;

import java.util.Optional;
import javax.inject.Provider;
import org.protege.editor.owl.model.annotation.AnnotationValueProvider;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataFactory;

public final class AnnotationProvider {
    private final Provider<IRI> annotationPropertyIriProvider;
    private final AnnotationValueProvider annotationValueProvider;

    public AnnotationProvider(Provider<IRI> annotationPropertyIriProvider, AnnotationValueProvider annotationValueProvider) {
        this.annotationPropertyIriProvider = annotationPropertyIriProvider;
        this.annotationValueProvider = annotationValueProvider;
    }

    public Optional<OWLAnnotation> getAnnotation(OWLDataFactory dataFactory) {
        Optional<OWLAnnotationValue> annotationValue = this.annotationValueProvider.getAnnotationValue(dataFactory);
        return annotationValue.map(v -> {
            IRI iri = (IRI)this.annotationPropertyIriProvider.get();
            OWLAnnotationProperty property = dataFactory.getOWLAnnotationProperty(iri);
            return dataFactory.getOWLAnnotation(property, (OWLAnnotationValue)annotationValue.get());
        });
    }
}

