/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.tasks;

import org.gradle.api.Task;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class TaskDependencies {
    public static final TaskDependencyInternal EMPTY = new TaskDependencyInternal() {
        @Override
        public Set<? extends Task> getDependencies(@Nullable Task task) {
            return Collections.emptySet();
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }
    };

    public static TaskDependencyInternal of(Collection<?> dependencies) {
        if (dependencies.isEmpty()) {
            return EMPTY;
        }
        return new DefaultTaskDependency().add(dependencies);
    }
}
