/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OsmExporter
extends FileExporter {
    public OsmExporter() {
        super(new ExtensionFileFilter("osm,xml", "osm", I18n.tr("OSM Server Files", new Object[0]) + " (*.osm)"));
    }

    public OsmExporter(ExtensionFileFilter filter) {
        super(filter);
    }

    @Override
    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        this.exportData(file, layer, false);
    }

    public void exportData(File file, Layer layer, boolean noBackup) {
        if (!(layer instanceof OsmDataLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        this.save(file, (OsmDataLayer)layer, noBackup);
    }

    protected static OutputStream getOutputStream(File file) throws IOException {
        return Compression.getCompressedFileOutputStream(file);
    }

    private void save(File file, OsmDataLayer layer, boolean noBackup) {
        File tmpFile = null;
        try {
            if (file.exists()) {
                tmpFile = new File(file.getPath() + '~');
                Utils.copyFile(file, tmpFile);
            }
            this.doSave(file, layer);
            if ((noBackup || !Config.getPref().getBoolean("save.keepbackup", false)) && tmpFile != null) {
                Utils.deleteFile(tmpFile);
            }
            layer.onPostSaveToFile();
        }
        catch (IOException | InvalidPathException e) {
            Logging.error(e);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while saving.<br>Error is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(e.getMessage())), I18n.tr("Error", new Object[0]), 0);
            try {
                if (tmpFile != null && tmpFile.exists()) {
                    Utils.copyFile(tmpFile, file);
                }
            }
            catch (IOException | InvalidPathException e2) {
                Logging.error(e2);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while restoring backup file.<br>Error is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(e2.getMessage())), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(File file, OsmDataLayer layer) throws IOException {
        try (OutputStream out = OsmExporter.getOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
             OsmWriter w = OsmWriterFactory.createOsmWriter(new PrintWriter(writer), false, layer.data.getVersion());){
            layer.data.getReadLock().lock();
            try {
                w.write(layer.data);
            }
            finally {
                layer.data.getReadLock().unlock();
            }
        }
    }
}

