#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: Agda
version: 2.5.4
id: Agda-2.5.4-9V6NaxwSgLsClQ9AAgneJY
key: Agda-2.5.4-9V6NaxwSgLsClQ9AAgneJY
license: LicenseRef-OtherLicense
maintainer: Ulf Norell <ulfn@chalmers.se>
author: Agda 2 was originally written by Ulf Norell, partially based on code from Agda 1 by Catarina Coquand and Makoto Takeyama, and from Agdalight by Ulf Norell and Andreas Abel. Agda 2 is currently actively developed mainly by Andreas Abel, Guillaume Allais, Jesper Cockx, Nils Anders Danielsson, Philipp Hausmann, Fredrik Nordvall Forsberg, Ulf Norell, Víctor López Juan, Andrés Sicard-Ramírez, and Andrea Vezzosi. Further, Agda 2 has received contributions by, amongst others, Stevan Andjelkovic, Marcin Benke, Jean-Philippe Bernardy, Guillaume Brunerie, James Chapman, Dominique Devriese, Péter Diviánszki, Olle Fredriksson, Adam Gundry, Daniel Gustafsson, Kuen-Bang Hou (favonia), Patrik Jansson, Alan Jeffrey, Wolfram Kahl, Wen Kokke, Fredrik Lindblad, Francesco Mazzoli, Stefan Monnier, Darin Morrison, Guilhem Moulin, Nicolas Pouillard, Nobuo Yamashita, Christian Sattler, and Makoto Takeyama and many more.
homepage: http://wiki.portal.chalmers.se/agda/
synopsis: A dependently typed functional programming language and proof assistant
description:
    Agda is a dependently typed functional programming language: It has
    inductive families, which are similar to Haskell'\''s GADTs, but they
    can be indexed by values and not just types. It also has
    parameterised modules, mixfix operators, Unicode characters, and an
    interactive Emacs interface (the type checker can assist in the
    development of your code).
    .
    Agda is also a proof assistant: It is an interactive system for
    writing and checking proofs. Agda is based on intuitionistic type
    theory, a foundational system for constructive mathematics developed
    by the Swedish logician Per Martin-L&#xf6;f. It has many
    similarities with other proof assistants based on dependent types,
    such as Coq, Epigram and NuPRL.
    .
    This package includes both a command-line program (agda) and an
    Emacs mode. If you want to use the Emacs mode you can set it up by
    running @agda-mode setup@ (see the README).
    .
    Note that the Agda package does not follow the package versioning
    policy, because it is not intended to be used by third-party
    packages.
category: Dependent types
abi: 05f2c52160ce77032b20372b859893f1
exposed: True
exposed-modules:
    Agda.Auto.Auto Agda.Auto.CaseSplit Agda.Auto.Convert
    Agda.Auto.NarrowingSearch Agda.Auto.Options Agda.Auto.SearchControl
    Agda.Auto.Syntax Agda.Auto.Typecheck Agda.Benchmarking
    Agda.Compiler.Backend Agda.Compiler.CallCompiler
    Agda.Compiler.Common Agda.Compiler.JS.Compiler
    Agda.Compiler.JS.Pretty Agda.Compiler.JS.Substitution
    Agda.Compiler.JS.Syntax Agda.Compiler.MAlonzo.Coerce
    Agda.Compiler.MAlonzo.Compiler Agda.Compiler.MAlonzo.Encode
    Agda.Compiler.MAlonzo.HaskellTypes Agda.Compiler.MAlonzo.Misc
    Agda.Compiler.MAlonzo.Pragmas Agda.Compiler.MAlonzo.Pretty
    Agda.Compiler.MAlonzo.Primitives Agda.Compiler.ToTreeless
    Agda.Compiler.Treeless.AsPatterns Agda.Compiler.Treeless.Builtin
    Agda.Compiler.Treeless.Compare
    Agda.Compiler.Treeless.EliminateDefaults
    Agda.Compiler.Treeless.EliminateLiteralPatterns
    Agda.Compiler.Treeless.Erase Agda.Compiler.Treeless.GuardsToPrims
    Agda.Compiler.Treeless.Identity
    Agda.Compiler.Treeless.NormalizeNames Agda.Compiler.Treeless.Pretty
    Agda.Compiler.Treeless.Simplify Agda.Compiler.Treeless.Subst
    Agda.Compiler.Treeless.Uncase Agda.Compiler.Treeless.Unused
    Agda.ImpossibleTest Agda.Interaction.BasicOps
    Agda.Interaction.CommandLine Agda.Interaction.EmacsCommand
    Agda.Interaction.EmacsTop Agda.Interaction.FindFile
    Agda.Interaction.Highlighting.Dot
    Agda.Interaction.Highlighting.Emacs
    Agda.Interaction.Highlighting.Generate
    Agda.Interaction.Highlighting.HTML
    Agda.Interaction.Highlighting.LaTeX
    Agda.Interaction.Highlighting.Precise
    Agda.Interaction.Highlighting.Range
    Agda.Interaction.Highlighting.Vim Agda.Interaction.Imports
    Agda.Interaction.InteractionTop Agda.Interaction.Library
    Agda.Interaction.Library.Base Agda.Interaction.Library.Parse
    Agda.Interaction.MakeCase Agda.Interaction.Monad
    Agda.Interaction.Options Agda.Interaction.Options.Help
    Agda.Interaction.Options.IORefs Agda.Interaction.Options.Lenses
    Agda.Interaction.Options.Warnings Agda.Interaction.Response
    Agda.Interaction.SearchAbout Agda.Main Agda.Syntax.Abstract
    Agda.Syntax.Abstract.Copatterns Agda.Syntax.Abstract.Name
    Agda.Syntax.Abstract.Pattern Agda.Syntax.Abstract.PatternSynonyms
    Agda.Syntax.Abstract.Pretty Agda.Syntax.Abstract.Views
    Agda.Syntax.Common Agda.Syntax.Concrete
    Agda.Syntax.Concrete.Definitions Agda.Syntax.Concrete.Generic
    Agda.Syntax.Concrete.Name Agda.Syntax.Concrete.Operators
    Agda.Syntax.Concrete.Operators.Parser
    Agda.Syntax.Concrete.Operators.Parser.Monad
    Agda.Syntax.Concrete.Pattern Agda.Syntax.Concrete.Pretty
    Agda.Syntax.DoNotation Agda.Syntax.Fixity Agda.Syntax.IdiomBrackets
    Agda.Syntax.Info Agda.Syntax.Internal Agda.Syntax.Internal.Defs
    Agda.Syntax.Internal.Generic Agda.Syntax.Internal.Names
    Agda.Syntax.Internal.Pattern Agda.Syntax.Internal.SanityCheck
    Agda.Syntax.Literal Agda.Syntax.Notation Agda.Syntax.Parser
    Agda.Syntax.Parser.Alex Agda.Syntax.Parser.Comments
    Agda.Syntax.Parser.Layout Agda.Syntax.Parser.LexActions
    Agda.Syntax.Parser.Lexer Agda.Syntax.Parser.Literate
    Agda.Syntax.Parser.LookAhead Agda.Syntax.Parser.Monad
    Agda.Syntax.Parser.Parser Agda.Syntax.Parser.StringLiterals
    Agda.Syntax.Parser.Tokens Agda.Syntax.Position
    Agda.Syntax.Reflected Agda.Syntax.Scope.Base
    Agda.Syntax.Scope.Monad Agda.Syntax.Translation.AbstractToConcrete
    Agda.Syntax.Translation.ConcreteToAbstract
    Agda.Syntax.Translation.InternalToAbstract
    Agda.Syntax.Translation.ReflectedToAbstract Agda.Syntax.Treeless
    Agda.Termination.CallGraph Agda.Termination.CallMatrix
    Agda.Termination.CutOff Agda.Termination.Inlining
    Agda.Termination.Monad Agda.Termination.Order
    Agda.Termination.RecCheck Agda.Termination.Semiring
    Agda.Termination.SparseMatrix Agda.Termination.TermCheck
    Agda.Termination.Termination Agda.TheTypeChecker
    Agda.TypeChecking.Abstract Agda.TypeChecking.CheckInternal
    Agda.TypeChecking.CompiledClause
    Agda.TypeChecking.CompiledClause.Compile
    Agda.TypeChecking.CompiledClause.Match
    Agda.TypeChecking.Constraints Agda.TypeChecking.Conversion
    Agda.TypeChecking.Coverage Agda.TypeChecking.Coverage.Match
    Agda.TypeChecking.Coverage.SplitTree Agda.TypeChecking.Datatypes
    Agda.TypeChecking.DeadCode Agda.TypeChecking.DisplayForm
    Agda.TypeChecking.DropArgs Agda.TypeChecking.Empty
    Agda.TypeChecking.Errors Agda.TypeChecking.EtaContract
    Agda.TypeChecking.Forcing Agda.TypeChecking.Free
    Agda.TypeChecking.Free.Lazy Agda.TypeChecking.Free.Old
    Agda.TypeChecking.Free.Precompute Agda.TypeChecking.Functions
    Agda.TypeChecking.Implicit Agda.TypeChecking.Injectivity
    Agda.TypeChecking.Inlining Agda.TypeChecking.InstanceArguments
    Agda.TypeChecking.Irrelevance Agda.TypeChecking.Level
    Agda.TypeChecking.LevelConstraints Agda.TypeChecking.MetaVars
    Agda.TypeChecking.MetaVars.Mention
    Agda.TypeChecking.MetaVars.Occurs Agda.TypeChecking.Monad
    Agda.TypeChecking.Monad.Base Agda.TypeChecking.Monad.Benchmark
    Agda.TypeChecking.Monad.Builtin Agda.TypeChecking.Monad.Caching
    Agda.TypeChecking.Monad.Closure Agda.TypeChecking.Monad.Constraints
    Agda.TypeChecking.Monad.Context Agda.TypeChecking.Monad.Debug
    Agda.TypeChecking.Monad.Env Agda.TypeChecking.Monad.Imports
    Agda.TypeChecking.Monad.MetaVars Agda.TypeChecking.Monad.Mutual
    Agda.TypeChecking.Monad.Open Agda.TypeChecking.Monad.Options
    Agda.TypeChecking.Monad.Signature
    Agda.TypeChecking.Monad.SizedTypes Agda.TypeChecking.Monad.State
    Agda.TypeChecking.Monad.Statistics Agda.TypeChecking.Monad.Trace
    Agda.TypeChecking.Patterns.Abstract
    Agda.TypeChecking.Patterns.Internal
    Agda.TypeChecking.Patterns.Match Agda.TypeChecking.Polarity
    Agda.TypeChecking.Positivity
    Agda.TypeChecking.Positivity.Occurrence Agda.TypeChecking.Pretty
    Agda.TypeChecking.Primitive Agda.TypeChecking.ProjectionLike
    Agda.TypeChecking.Quote Agda.TypeChecking.ReconstructParameters
    Agda.TypeChecking.RecordPatterns Agda.TypeChecking.Records
    Agda.TypeChecking.Reduce Agda.TypeChecking.Reduce.Fast
    Agda.TypeChecking.Reduce.Monad Agda.TypeChecking.Rewriting
    Agda.TypeChecking.Rewriting.NonLinMatch
    Agda.TypeChecking.Rules.Application Agda.TypeChecking.Rules.Builtin
    Agda.TypeChecking.Rules.Builtin.Coinduction
    Agda.TypeChecking.Rules.Data Agda.TypeChecking.Rules.Decl
    Agda.TypeChecking.Rules.Def Agda.TypeChecking.Rules.Display
    Agda.TypeChecking.Rules.LHS Agda.TypeChecking.Rules.LHS.Implicit
    Agda.TypeChecking.Rules.LHS.Problem
    Agda.TypeChecking.Rules.LHS.ProblemRest
    Agda.TypeChecking.Rules.LHS.Unify Agda.TypeChecking.Rules.Record
    Agda.TypeChecking.Rules.Term Agda.TypeChecking.Serialise
    Agda.TypeChecking.Serialise.Base
    Agda.TypeChecking.Serialise.Instances
    Agda.TypeChecking.Serialise.Instances.Abstract
    Agda.TypeChecking.Serialise.Instances.Common
    Agda.TypeChecking.Serialise.Instances.Compilers
    Agda.TypeChecking.Serialise.Instances.Errors
    Agda.TypeChecking.Serialise.Instances.Highlighting
    Agda.TypeChecking.Serialise.Instances.Internal
    Agda.TypeChecking.SizedTypes Agda.TypeChecking.SizedTypes.Solve
    Agda.TypeChecking.SizedTypes.Syntax
    Agda.TypeChecking.SizedTypes.Utils
    Agda.TypeChecking.SizedTypes.WarshallSolver Agda.TypeChecking.Sort
    Agda.TypeChecking.Substitute Agda.TypeChecking.Substitute.Class
    Agda.TypeChecking.Substitute.DeBruijn
    Agda.TypeChecking.SyntacticEquality Agda.TypeChecking.Telescope
    Agda.TypeChecking.Unquote Agda.TypeChecking.Warnings
    Agda.TypeChecking.With Agda.Utils.AffineHole Agda.Utils.AssocList
    Agda.Utils.Bag Agda.Utils.Benchmark Agda.Utils.BiMap
    Agda.Utils.Char Agda.Utils.Cluster Agda.Utils.Either
    Agda.Utils.Empty Agda.Utils.Environment Agda.Utils.Except
    Agda.Utils.Favorites Agda.Utils.FileName Agda.Utils.Float
    Agda.Utils.Function Agda.Utils.Functor Agda.Utils.Geniplate
    Agda.Utils.Graph.AdjacencyMap.Unidirectional Agda.Utils.Hash
    Agda.Utils.HashMap Agda.Utils.Haskell.Syntax Agda.Utils.IO
    Agda.Utils.IO.Binary Agda.Utils.IO.Directory Agda.Utils.IO.UTF8
    Agda.Utils.IORef Agda.Utils.Impossible Agda.Utils.IndexedList
    Agda.Utils.IntSet.Infinite Agda.Utils.Lens Agda.Utils.Lens.Examples
    Agda.Utils.List Agda.Utils.ListT Agda.Utils.Map Agda.Utils.Maybe
    Agda.Utils.Maybe.Strict Agda.Utils.Memo Agda.Utils.Monad
    Agda.Utils.Monoid Agda.Utils.NonemptyList Agda.Utils.Null
    Agda.Utils.POMonoid Agda.Utils.Parser.MemoisedCPS
    Agda.Utils.Parser.ReadP Agda.Utils.PartialOrd
    Agda.Utils.Permutation Agda.Utils.Pointer Agda.Utils.Pretty
    Agda.Utils.SemiRing Agda.Utils.Singleton Agda.Utils.Size
    Agda.Utils.String Agda.Utils.Suffix Agda.Utils.Three
    Agda.Utils.Time Agda.Utils.Trie Agda.Utils.Tuple
    Agda.Utils.TypeLevel Agda.Utils.Update Agda.Utils.VarSet
    Agda.Utils.Warshall Agda.Utils.Zipper Agda.Version
    Agda.VersionCommit
hidden-modules: Paths_Agda
import-dirs: /usr/lib/ghc-8.4.3/site-local/Agda-2.5.4
library-dirs: /usr/lib/ghc-8.4.3/site-local/Agda-2.5.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/agda
hs-libraries: HSAgda-2.5.4-9V6NaxwSgLsClQ9AAgneJY
depends:
    array-0.5.2.0 async-2.2.1-B6m2kYywRJu7nicgTBxsJe base-4.11.1.0
    binary-0.8.5.1 blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG
    boxes-0.1.5-EY7X3MTmq17BS0dK50ivYF bytestring-0.10.8.2
    containers-0.5.11.0 data-hash-0.2.0.1-D2pljNnFjuv5cOCQdMozWU
    deepseq-1.4.3.0 directory-1.3.1.5
    EdisonCore-1.3.2.1-RWp2NRy4n7GOABgTTYJta
    edit-distance-0.2.2.1-B7XvzAt3DQ5DrMTYu2eW2w
    equivalence-0.3.2-3KXUMF3chYxDgZgaRfCp58 filepath-1.4.2
    geniplate-mirror-0.7.6-BOyiF6L7w2F4l39KglniJW
    gitrev-1.3.1-I3rV26MPk8fH6eAgYo6ASC
    hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg
    hashtables-1.2.3.1-FwvkrjNnnglEJJXpMCqokg haskeline-0.7.4.2
    ieee754-0.8.0-KmEF4YGiqmIDu40b1SLx46 mtl-2.2.2
    murmur-hash-0.1.0.9-Ce2PF3vuSih2JvgNjQCn0O pretty-1.1.3.6
    process-1.6.3.0 regex-tdfa-1.2.3.1-az1JL7mhmZBLFmoReK21K
    stm-2.4.5.0 strict-0.3.2-GUMMwuTAWLDDoRWXG04D6Z
    template-haskell-2.13.0.0 text-1.2.3.0 time-1.8.0.2
    unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu
    uri-encode-1.5.0.5-C0LTL3cUY17EybZuOdcMgy transformers-0.5.5.0
    zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH
abi-depends: array-0.5.2.0=dc85b03ee806d784249cc791da6109c3
             async-2.2.1-B6m2kYywRJu7nicgTBxsJe=32776142fda961cc693aa4db742773f9
             base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG=c53bb3bf02513bb30eb5ce3eb528e263
             boxes-0.1.5-EY7X3MTmq17BS0dK50ivYF=4029fe902567e5520f3cfc10e3399ec6
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             data-hash-0.2.0.1-D2pljNnFjuv5cOCQdMozWU=bf0ec83ca033e56ed37a487766394165
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             directory-1.3.1.5=f5fa3aef63d61d9b32ef25d211ef137f
             EdisonCore-1.3.2.1-RWp2NRy4n7GOABgTTYJta=1c86caf46d75bd29d1e60052bed0e17f
             edit-distance-0.2.2.1-B7XvzAt3DQ5DrMTYu2eW2w=02958dfaddfd66b4d812005241ff868f
             equivalence-0.3.2-3KXUMF3chYxDgZgaRfCp58=9b046ba1d37ba7d2de4f6292853fd591
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             geniplate-mirror-0.7.6-BOyiF6L7w2F4l39KglniJW=8116824f8392c4bf45247201ac577834
             gitrev-1.3.1-I3rV26MPk8fH6eAgYo6ASC=dfadfabf13d3d9a6719171042287531b
             hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg=0f14342a1ffe8710d31657335cf81134
             hashtables-1.2.3.1-FwvkrjNnnglEJJXpMCqokg=9716e82ce2a1119e069e6c69de7a6cc9
             haskeline-0.7.4.2=e6153d219f5fb7b64fb712b63f016a25
             ieee754-0.8.0-KmEF4YGiqmIDu40b1SLx46=9f6b114ae6eb47237e10ea290c9398cc
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             murmur-hash-0.1.0.9-Ce2PF3vuSih2JvgNjQCn0O=5f8503e0d2a6f65d8ac1612a7f83f505
             pretty-1.1.3.6=3c31686bd534e1773b954ae82713db97
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             regex-tdfa-1.2.3.1-az1JL7mhmZBLFmoReK21K=98feb6ae4c5e833326f77c1995f4743b
             stm-2.4.5.0=4e743cb5a370ac3fbade528432951c3f
             strict-0.3.2-GUMMwuTAWLDDoRWXG04D6Z=bb84743753e36e5d9eb9840a6b2de2dc
             template-haskell-2.13.0.0=ac7dfd04924d4ebfa90a119ad22a36cc
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu=5b052eced98346d45f3db03378f2841d
             uri-encode-1.5.0.5-C0LTL3cUY17EybZuOdcMgy=6a5af22f7901ee990a1b2c0c77234551
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH=8fa648805d93281f19b98bbf203b4b1c
haddock-interfaces: /usr/share/doc/agda/html/Agda.haddock
haddock-html: /usr/share/doc/agda/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

