// Copyright (c) 2015, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

part of services.completion.dart.sorter.common;

// Auto-generated, please do not edit.

/**
 * A map of <library>.<classname> to an ordered list of method names,
 * field names, getter names, and named constructors.
 * The names are ordered from most relevant to least relevant.
 * Names not listed are considered equally less relevant than those listed.
 */
const Map<String, List<String>> defaultSelectorRelevance = const {
'dart.core.Comparable': const ['compareTo','compare',],
'dart.math.Random': const ['nextInt','nextDouble','nextBool',],
'dart.core.List': const ['add','map','length','removeLast','addAll','join','forEach','contains','removeAt','where','last','clear','setRange','sort','insert','remove','sublist','indexOf','isEmpty','any','insertAll','first','removeRange','replaceRange','take','getRange','skip','toList','retainWhere','fillRange','removeWhere','expand','fold','reversed','firstWhere','every','setAll','asMap','isNotEmpty','lastIndexOf','singleWhere','lastWhere','shuffle','takeWhile','iterator','toString','toSet','single','reduce','elementAt','skipWhile','insertRange','filter','push','mappedBy','addLast','some','slice','retainMatching','firstMatching','removeAll','retainAll','removeMatching','min','lastMatching','singleMatching','max','get','toArray','runtimeType','reverse','addd','asByteArray',],
'dart.core.Iterable': const ['toList','map','join','toSet','where','forEach','expand','fold','every','any','contains','firstWhere','length','elementAt','skipWhile','reduce','iterator','take','skip','toString','singleWhere','lastWhere','takeWhile','isEmpty','first','single','last','isNotEmpty','addAll','indexOf','add','sort','toArray','mappedBy','filter',],
'dart.core.Set': const ['add','contains','remove','addAll','clear','difference','map','containsAll','union','removeWhere','removeAll','intersection','retainAll','retainWhere','forEach','toSet','every','lookup','any','toString','toList','where','length','join','skip','firstWhere','isEmpty','first','iterator','singleWhere','expand','elementAt','fold','reduce','single','lastWhere','isNotEmpty','take','takeWhile','skipWhile','last','findBy','toArray','filter',],
'dart.collection.Queue': const ['add','removeFirst','clear','removeLast','remove','addAll','addLast','addFirst','removeWhere','retainWhere','length','toList','where','contains','forEach','map','isNotEmpty','first','isEmpty','fold','skip','any','elementAt',],
'dart.core.Map': const ['containsKey','forEach','remove','putIfAbsent','clear','addAll','length','keys','values','containsValue','toString','isNotEmpty','isEmpty','get','getKeys','put','getValues','clone','keySet','hashCode','runtimeType',],
'dart.core.Iterator': const ['moveNext','current','next','hasNext',],
'dart.pkg.collection.equality.Equality': const ['hash','equals','isValidKey',],
'dart.pkg.collection.equality.SetEquality': const ['equals','hash',],
'dart.pkg.collection.equality.MapEquality': const ['equals','hash',],
'dart.pkg.collection.equality.ListEquality': const ['equals','hash',],
'dart.pkg.collection.equality.IterableEquality': const ['hash','equals',],
'dart.pkg.collection.equality.UnorderedIterableEquality': const ['hash','equals',],
'dart.async.StreamSubscription': const ['cancel','pause','onDone','resume','onError','asFuture','onData','isPaused',],
'dart.async.StreamController': const ['add','close','addError','addStream','stream','hasListener','signalError','sink','done',],
'dart.async.Stream': const ['listen','transform','pipe','first','toList','forEach','firstWhere','where','join','fold','asyncMap','map','isEmpty','asBroadcastStream','handleError','capture','asyncExpand','take','single','expand','onFile','skip','any','timeout','add','last','runtimeType','isBroadcast','drain','elementAt','skipWhile','distinct','singleWhere','lastWhere','contains','every','takeWhile','emit','onDir','onError','onDone','onData','length',],
'dart.async.Future': const ['then','catchError','wait','whenComplete','forEach','asStream','timeout','map','packages','where','firstWhere','chain','transform','doWhile','onError','onResponse','onRequest','handleException',],
'dart.core.String': const ['substring','codeUnitAt','startsWith','replaceAll','split','contains','indexOf','toLowerCase','trim','length','endsWith','lastIndexOf','compareTo','isEmpty','toUpperCase','replaceFirst','toString','replaceAllMapped','allMatches','padLeft','codeUnits','hashCode','splitMapJoin','isNotEmpty','runes','charCodeAt','charCodes','trimRight','padRight','concat','equalsIgnoreCase','splitChars','trimLeft','matchAsPrefix','equals','map','toLoweCase','match','slice','getBytes','toCharArray','runtimeType','charAt','valueOf',],
'dart.core.StringBuffer': const ['write','toString','writeln','writeCharCode','clear','writeAll','add','addAll','addCharCode','isEmpty',],
'dart.core.RegExp': const ['firstMatch','hasMatch','allMatches','matchAsPrefix','pattern','stringMatch','toString','exec',],
'dart.core.double': const ['parse','toInt','compareTo','floor','toString','abs','round','toStringAsPrecision','toDouble','floorToDouble','ceil','truncate','toStringAsFixed','roundToDouble','clamp','isNaN','isFinite','toStringAsExponential','ceilToDouble','truncateToDouble','isNan','isNegative','isInfinite','hashCode',],
'dart.core.Type': const ['toString','hashCode','runtimeType',],
'dart.mirrors.InstanceMirror': const ['reflectee','getField','type','invoke','setField','delegate','function','then','apply','hasReflectee',],
'dart.collection.IterableBase': const ['iterableToFullString',],
'dart.pkg.collection.utils.Pair': const ['last',],
'dart.collection.Maps': const ['mapToString','length','putIfAbsent','clear','containsKey','getValues','forEach','containsValue','isNotEmpty','isEmpty',],
'dart.collection.SplayTreeSet': const ['add','addAll','where',],
'dart.core.StackTrace': const ['toString','frames',],
'dart.convert.JsonCodec': const ['encode','decode','fuse',],
'dart.mirrors.MirrorSystem': const ['getName','libraries','findLibrary','isolate','dynamicType','getSymbol','voidType',],
'dart.mirrors.ClassMirror': const ['newInstance','isSubtypeOf','reflectedType','qualifiedName','metadata','getField','owner','declarations','superclass','simpleName','isSubclassOf','invoke','instanceMembers','mixin','isAbstract','originalDeclaration','typeVariables','setField','isOriginalDeclaration','superinterfaces','isAssignableTo','owners',],
'dart.io.Process': const ['start','runSync','run','kill','exitCode',],
'dart.core.int': const ['parse','toDouble','toString','toInt','compareTo','toRadixString','abs','remainder','toUnsigned','toSigned','clamp','round','floor','substr','ceil','isEven','id','append','truncate','hashCode','toStringAsFixed','ceilToDouble','roundToDouble','floorToDouble','truncateToDouble','isNegative','length','isNaN','isInfinite','runtimeType','bitLength',],
'dart.core.Sink': const ['add','close',],
'dart.async.EventSink': const ['close','add','addError',],
'dart.async.Completer': const ['complete','completeError','future','isCompleted','completeException','then',],
'dart.io.FileStat': const ['mode','stat','type','statSync','changed','modified','size',],
'dart.io.Link': const ['existsSync','createSync','resolveSymbolicLinksSync','exists','delete','targetSync','deleteSync','target','create','updateSync',],
'dart.io.FileSystemEntityType': const ['toString','NOT_FOUND','DIRECTORY','FILE',],
'dart.io.Directory': const ['existsSync','list','listSync','watch','path','exists','createSync','create','deleteSync','delete','createTemp','createTempSync','renameSync','parent','absolute','stat','current','createRecursivelySync','resolveSymbolicLinksSync','rename','statSync',],
'dart.io.File': const ['existsSync','readAsStringSync','openRead','writeAsStringSync','readAsString','openWrite','lastModifiedSync','exists','resolveSymbolicLinksSync','writeAsString','path','resolveSymbolicLinks','statSync','deleteSync','createSync','delete','openSync','parent','readAsBytesSync','copy','open','absolute','fullPathSync','length','writeAsBytesSync','lastModified','writeAsBytes','readAsLinesSync','fullPath','readAsBytes','copySync','create','lengthSync','readAsLines','isFileSync','isFile','rename','openOutputStream','openInputStream','stat','renameSync','watch','directorySync','isAbsolute','directory',],
'dart.io.Stdout': const ['writeln','close','write','flush','addStream','writeString','add','writeCharCode','addString',],
'dart.io.IOSink': const ['write','close','writeln','flush','add','addStream','writeAll','writeCharCode','encoding','addError','done',],
'dart.mirrors.LibraryMirror': const ['uri','getField','declarations','invoke','topLevelMembers','setField','classes','first',],
'dart.core.Match': const ['group','end','start','groups','toString',],
'dart.isolate.SendPort': const ['send','call','hashCode',],
'dart.core.DateTime': const ['parse','toIso8601String','millisecondsSinceEpoch','difference','toUtc','add','day','year','month','isAfter','toString','compareTo','subtract','isBefore','millisecond','toLocal','timeZoneName','timeZoneOffset','isUtc','weekday','isAtSameMomentAs','second','hour','minute','hashCode','now','runtimeType',],
'dart.core.Duration': const ['inMilliseconds','toString','inSeconds','inMicroseconds','inHours','inMinutes','inDays','isNegative','compareTo',],
'dart.core.Uri': const ['parse','toString','toFilePath','path','resolve','decodeComponent','encodeFull','decodeQueryComponent','scheme','encodeComponent','resolveUri','encodeQueryComponent','query','decodeFull','pathSegments','queryParameters','origin','authority','splitQueryString','replace','host','isAbsolute','port','fragment','hasAuthority','userInfo','parseIPv4Address','parseIPv6Address','hasQuery','endsWith','startsWith',],
'dart.typed_data.Uint32List': const ['sublist','setAll','fillRange','setRange','removeRange','removeLast','clear','addAll','add',],
'dart.typed_data.TypedData': const ['buffer',],
'dart.io.BytesBuilder': const ['takeBytes','addByte','add','clear','toBytes',],
'dart.isolate.ReceivePort': const ['close','transform','listen','receive','toSendPort','takeWhile','sendPort','asBroadcastStream',],
'dart.convert.Encoding': const ['decode','encode','getByName','decodeStream','name',],
'dart.convert.Utf8Codec': const ['encode','decode','decoder','decodeStream',],
'dart.core.Stopwatch': const ['start','stop','reset','elapsedMicroseconds','elapsedMilliseconds','elapsed','elapsedInMs',],
'dart.async.ZoneDelegate': const ['handleUncaughtError','registerUnaryCallback','registerCallback','registerBinaryCallback','runBinary','errorCallback','scheduleMicrotask','run','createTimer',],
'dart.async.Zone': const ['handleUncaughtError','run','fork','inSameErrorZone','runGuarded','bindUnaryCallback','bindBinaryCallback','runUnary','bindCallback','scheduleMicrotask','createTimer',],
'dart.dom.html.BodyElement': const ['innerHtml','children','nodes','append','style','onContextMenu','onMouseDown','onMouseWheel','scrollTop','onMouseUp','onClick','scrollLeft','clientHeight','clientWidth','onBlur','onFocus','onDoubleClick','scrollHeight','onMouseMove','elements','createFragment','classes','ownerDocument','query','onKeyDown','querySelector','offsetWidth','scrollWidth','offsetHeight','setInnerHtml','childNodes','requestFullscreen','offsetTop',],
'dart.dom.html.Location': const ['hash','search','reload','pathname','toString','href','host','assign','replace','protocol','hostname','port','origin',],
'dart.convert.HtmlEscape': const ['convert',],
'dart.dom.html.Window': const ['postMessage','btoa','lookupPort','document','requestAnimationFrame','alert','navigator','devicePixelRatio','pageYOffset','pageXOffset','onAnimationEnd','innerWidth','onResize','getSelection','cancelAnimationFrame','animationEndEvent','innerHeight','registerPort','dispatchEvent','onAnimationStart','onMouseUp','onMouseMove','open','screen','indexedDB','setTimeout','scrollX','scrollY','onScroll','openDatabase','confirm','getContainer','location','onKeyUp','atob','scrollTo','localStorage','scrollBy','setInterval','setImmediate','requestLayoutFrame','requestFileSystem','onHashChange','close','console','onError','onMessage','animationFrame',],
'dart.core.Function': const ['apply','toString','call','bind',],
'dart.async.Timer': const ['cancel','run',],
'dart.dom.html.HeadElement': const ['append','querySelector','query','children','style','elements','querySelectorAll','nodes','id','insertBefore','text',],
'dart.dom.html.ElementStream': const ['listen','where','first','matches','forEach','map',],
'dart.dom.html.Element': const ['query','onClick','innerHtml','style','querySelector','nodes','children','remove','append','querySelectorAll','classes','attributes','setInnerHtml','getComputedStyle','onChange','parent','matches','getBoundingClientRect','focus','dispatchEvent','addEventListener','insertAllBefore','clone','getAttribute','blur','createShadowRoot','contains','text','setAttribute','insertAdjacentElement','appendText','scrollIntoView','shadowRoot','getNamespacedAttributes','removeEventListener','insertBefore','appendHtml','click','offsetWidth','insertAdjacentHtml','insertAdjacentText','getClientRects','getElementsByClassName','replaceWith','scrollByLines','scrollByPages','hasChildNodes','requestFullscreen','requestPointerLock','queryAll','setAttributeNS','getAttributeNS','dataset','offsetHeight','on','createFragment','offsetTo','getDestinationInsertionPoints','matchesWithAncestors','attributeChanged','onMouseDown','nextElementSibling','getRegionFlowRanges','onContextMenu','animate','onTouchStart','scrollTop','offsetTop','onTouchMove','onTouchEnd','onMouseWheel','clientWidth','scrollLeft','clientHeight','isTagSupported','parentNode','onMouseUp','bind','onKeyDown','ownerDocument','unbind','unbindAll','init','createInstance','render','update','onKeyUp','onMouseMove','xtag','offsetLeft','tabIndex','client','requestFullScreen','getInputContext','borderEdge','clearModel','id','disabled','value','getContext','lastChild','firstChild','nextNode','innerHTML','onMouseEnter','onMouseLeave','contentEdge','elements','matchesSelector','webkitRequestPointerLock','tagName','childNodes','webkitRequestFullscreen','webkitRequestFullScreen','marginEdge','paddingEdge','outerHtml','onMouseOver','onMouseOut','onDragEnd','boolean','scrollHeight','hidden','onDragStart','onDoubleClick','nodeType','hashCode','onDrag','onInput','selectionStart','selectionEnd','onDrop','onDragLeave','hideOrShowNavigation','onDragOver','model','scrollEvent','onDragEnter','previousElementSibling','className','namespaceUri','onSubmit','selection','setItemSelected','runtimeType','apply','createBinding','values','onBlur','onTouchCancel','show','insertAdjacentHTML','nodeName','selected','contentEditable','localName','number','draggable','src','addText','addHTML','select','clear','str','clearSelection',],
'dart.dom.html.HtmlElement': const ['querySelector','query','append','classes','style','getComputedStyle','remove','getBoundingClientRect','querySelectorAll','clone','attributes','focus','tabIndex','onClick','parent','onMouseLeave','replaceWith','onContextMenu','onMouseEnter','onKeyDown','blur','setInnerText','scrollTop','appendHtml','dataset','lastChild','onSelectStart','onDrop','onDragOver','onDragLeave','onDragEnter','onDragEnd','onDragStart','onDrag','onDoubleClick','children','onScroll','getAttribute','nodes','outerHtml','click','createShadowRoot',],
'dart.dom.html.ElementList': const ['forEach','length','contains','last','style','addAll','first','where','onMouseLeave','onMouseEnter','toList','some','onClick','map','classes','indexOf',],
'dart.dom.html.HtmlDocument': const ['query','querySelectorAll','querySelector','queryAll','createElement','body','title','createElementUpgrader','documentElement','timeline','onKeyDown','getElementById','registerElement','onClick','addEventListener','onMouseUp','onMouseMove','activeElement','createElementNS','createDocumentFragment','createRange','adoptNode','getElementsByTagName','onKeyUp','elementFromPoint','contains','getElementsByName','head','exitFullscreen','onMouseWheel','register',],
'dart.collection.LinkedHashMap': const ['containsKey','forEach','remove','putIfAbsent','keys','length','clear','values','isNotEmpty',],
'dart.dom.html.Navigator': const ['userAgent','language','appVersion','appName','geolocation','vendor','appCodeName','dartEnabled','getUserMedia','onLine','platform','storageQuota',],
'dart.dom.html.CssStyleDeclaration': const ['display','width','height','top','setProperty','left','position','zIndex','cssText','right','maxHeight','visibility','bottom','background','removeProperty','cursor','overflow','getPropertyValue','opacity','backgroundColor','float','transform','padding','border','borderRadius','paddingBottom','transition','paddingTop','overflowY','color','outline','backgroundImage','transformStyle','pointerEvents','marginLeft','textAlign','backgroundPosition','boxSizing','paddingLeft','backgroundSize','margin','fontFamily','userSelect','fontSize','lineHeight','willChange','fontWeight','getProperty','marginRight','whiteSpace','overflowX','textDecoration','perspective','perspectiveOrigin','appearance','borderLeftWidth','paddingRight','borderColor','borderBottomWidth','borderTopWidth','webkitOverflowScrolling','borderRightWidth','marginBottom','transitionProperty','transitionTimingFunction','transitionDuration','animation','animationDelay','animationFillMode','animationDirection','animationIterationCount','animationTimingFunction','animationDuration','animationName','verticalAlign','marginTop','boxShadow','getPropertyPriority','textStrokeColor','borderBottom','font','supportsProperty','textShadow','maxWidth','minWidth','minHeight','outlineColor','filter','borderWidth','animationPlayState','fontStyle','borderRight','borderLeft','borderTop',],
'dart.io.ProcessResult': const ['stdout','exitCode',],
'dart.io.FileSystemEvent': const ['path','isDirectory','type','MODIFY','CREATE','DELETE',],
'dart.collection.HashSet': const ['add','contains','remove','clear','addAll','retainAll','length','isEmpty','toList','removeAll','any','forEach','map',],
'dart.collection.HashMap': const ['remove','containsKey','forEach','clear','keys','putIfAbsent','addAll','values',],
'dart.io.FileSystemEntity': const ['isDirectorySync','path','typeSync','existsSync','isDirectory','identicalSync','isFileSync','type','isFile','statSync','deleteSync','isLinkSync','parentOf','renameSync','isLink','readAsStringSync','identical','rename','toString','delete','exists','parent','stat',],
'dart.io.OSError': const ['errorCode','toString',],
'dart.async.StreamTransformer': const ['bind',],
'dart.core.Runes': const ['toList','any','elementAt','iterator','single','first','forEach','last',],
'dart.core.Object': const ['toString','toJson','hashCode','discardListChages','reverse','map','lightDom','getName','where','add','containsKey','format','setTable','getClass','getNamespace','getId','getCell','getSize','setNamespace','equals','setColumn','getColumnName','getForeignTableName','setDatabase','setAttribute','setId','getChild','body','setPrevious','getIndex','getParent','getChildAt','getChildCount','getValue','getRoot','POST','GET','getPackage','setSchema','clone','getType','then','isInheritance','isVisible','getDartName','getPlatform','setPosition','setPackage','requiresTransactionInPostgres','setAppData','getSchema','getBuildProperty','getPrevious','getTerminal','n','replaceWith','setChild','setPlatform','run','removeItem','getAllItems','bytes','compareTo','getAttribute','setPreviousIndex','isEmpty','getEdgeAt','isVertex','writeExternal','isEdge','getEdgeCount','isConnectable','setValue','isCollapsed','getStyles','setRoot','getStyle','getGeometry','noSuchMethod','contains','elementAt','e',],
'dart.core.StringSink': const ['write','writeln','writeCharCode','toString','writeAll',],
'dart.io.Stdin': const ['pipe','readLineSync','transform','listen',],
'dart.io.HttpServer': const ['bind','listen','close','connectionsInfo','bindSecure','address','port','idleTimeout','serverHeader','autoCompress','asBroadcastStream','transform','addRequestHandler','listenOn','on',],
'dart.io.HttpResponse': const ['close','write','statusCode','headers','add','done','redirect','addStream','detachSocket','reasonPhrase','writeln','addError','writeCharCode','writeAll','flush','toString','when','cookies','contentLength','addString','getLogs','listen','persistentConnection','deadline',],
'dart.io.HttpRequest': const ['listen','uri','session','drain','transform','response','toString','cookies','method','fold','connectionInfo','pipe','asBroadcastStream','toList','timeout','takeWhile','take','skipWhile','singleWhere','map','lastWhere','join','handleError','skip','firstWhere','expand','every','elementAt','distinct','asyncMap','asyncExpand','any','toSet','contains','where','reduce','forEach','headers','path',],
'dart.collection.SplayTreeMap': const ['forEach','containsKey','remove','keys','values','firstKeyAfter','lastKeyBefore','clear','length',],
'dart.io.HttpClient': const ['post','getUrl','openUrl','close','postUrl','get','open','addCredentials','patchUrl','shutdown','put','delete','addProxyCredentials','findProxyFromEnvironment',],
'dart.io.HttpClientRequest': const ['close','add','write','addStream','cookies',],
'dart.io.Platform': const ['isWindows','script','environment','operatingSystem','pathSeparator',],
'dart.collection.LinkedHashSet': const ['add','map','contains','toList','addAll','remove',],
'dart.io.RandomAccessFile': const ['lengthSync','readIntoSync','close','closeSync','writeStringSync','writeString','writeFromSync','length','readInto','read','readSync','writeFrom','readListSync','flushSync','positionSync','setPosition','writeListSync','setPositionSync','unlock','lock','unlockSync','readList','lockSync','readByteSync','position','writeList','writeByteSync',],
'dart.core.num': const ['round','toDouble','toInt','floor','abs','toString','parse','ceil','toStringAsFixed','isNaN','compareTo','roundToDouble','remainder','hashCode','clamp','isInfinite','isNegative','truncate','toStringAsPrecision','toStringAsExponential','isFinite','truncateToDouble','toRadixString',],
'dart.dom.html.HttpRequest': const ['send','open','getString','abort','setRequestHeader','request','getAllResponseHeaders','overrideMimeType','requestCrossOrigin','getResponseHeader','postFormData','onLoadEnd','onError','onLoad','DONE','withCredentials','onReadyStateChange','onLoadStart',],
'dart.dom.html.Event': const ['preventDefault','toString','stopImmediatePropagation','stopPropagation','target','currentTarget',],
'dart.dom.html.FileReader': const ['readAsArrayBuffer','readAsDataUrl','readAsText','onError','onLoadEnd','result',],
'dart.core.Pattern': const ['allMatches','matchAsPrefix','toString','firstMatch','pattern','codeUnitAt',],
'dart.io.ContentType': const ['parse','toString','charset','mimeType','value','parameters','subType','primaryType',],
'dart.io.HttpHeaders': const ['set','contentType','ifModifiedSince','value','add','host','forEach','date','removeAll','clear','remove','noFolding','contentLength','port','expires','chunkedTransferEncoding','persistentConnection','toString','CONTENT_TYPE','data',],
'dart.typed_data.Uint8List': const ['setRange','sublist','fillRange','setAll','length','buffer','toString','toList','lastIndexOf','indexOf','join','removeRange','removeLast','clear','addAll','add',],
'dart.async.StreamSink': const ['close','addStream','add','addError',],
'dart.typed_data.ByteData': const ['getUint32','setUint32','getUint8','setUint64','getInt32','getUint16','getUint64','setUint16','getInt16','setInt64','setInt32','setInt16','setFloat64','getInt64','setInt8','getFloat64','getFloat32','setFloat32','getInt8','setUint8',],
'dart.io.HttpClientResponse': const ['listen','toList','transform','drain','fold','pipe','detachSocket',],
'dart.core.BidirectionalIterator': const ['moveNext','movePrevious',],
'dart.mirrors.ClosureMirror': const ['invoke','apply','function',],
'dart.typed_data.Int32x4': const ['x','signMask','select',],
'dart.js.JsObject': const ['callMethod','hasProperty','toString','deleteProperty','instanceof',],
'dart.dom.html.Node': const ['remove','ELEMENT_NODE','insertBefore','replaceWith','insertAllBefore','querySelector','localName','text','append','setMenubarOrientation','getElementsByTagName','getElementsByClassName','nodes','parentNode','getElementById','firstChild','parent','contains','tagName','value','toString','name','querySelectorAll','clone','attributes','nextNode','nodeType','click','bind','outerHtml','dispatchEvent','on','childNodes',],
'dart.core.RuneIterator': const ['moveNext','reset',],
'dart.mirrors.DeclarationMirror': const ['isPrivate','simpleName','metadata','isSubclassOf','qualifiedName','parameters','invoke',],
'dart.dom.html.History': const ['pushState','back','replaceState','length',],
'dart.dom.html.CssClassSet': const ['add','remove','toggle','clear','contains','addAll','removeAll','toString','firstWhere','first','toggleAll','length','containsAll',],
'dart.dom.html.Document': const ['querySelector','querySelectorAll','documentElement','createElement','title','body','removeEventListener','addEventListener','getElementsByTagName','createElementNS','query','window','queryAll',],
'dart.mirrors.IsolateMirror': const ['rootLibrary',],
'dart.mirrors.ObjectMirror': const ['invoke','getField','setField',],
'dart.dom.html.DivElement': const ['append','classes','style','setInnerHtml','remove','querySelector','id','getComputedStyle','appendText','text','querySelectorAll','onDragEnd','onDrag','onDragStart','draggable','innerHtml','insertAdjacentElement','appendHtml','className','children','focus','query','nodes','createShadowRoot','clone','attributes','queryAll','click','onMouseDown','onClick','hidden','addEventListener','onMouseMove','scrollIntoView','onKeyDown','title','getBoundingClientRect','onMouseUp','dispatchEvent','insertAdjacentText','contentEditable','scrollTop','scrollByLines','bind','insertBefore','xtag','insertAdjacentHtml','matches','setAttribute','on','onKeyUp','getElementsByClassName',],
'dart.dom.html.NodeValidatorBuilder': const ['allowNavigation','allowElement','allowHtml5','allowSvg','allowInlineStyles','allowTextElements','allowTemplating','allowCustomElement','allowTagExtension','allowImages',],
'dart.dom.html.Console': const ['timeEnd','time','timeStamp','warn','log','error','groupEnd','info','debug','groupCollapsed','group','dir',],
'dart.dom.html.ElementUpgrader': const ['upgrade',],
'dart.async.StreamIterator': const ['moveNext','cancel',],
'dart.io.SystemEncoding': const ['decode',],
'dart.collection.UnmodifiableListView': const ['where','contains','any','length','join','firstWhere',],
'dart.core.Error': const ['safeToString','toString',],
'dart.convert.Utf8Encoder': const ['bind','convert','startChunkedConversion',],
'dart.dom.html.DomImplementation': const ['createHtmlDocument',],
'dart.dom.html.DocumentFragment': const ['querySelectorAll','append','clone','nodes','children','setInnerHtml','querySelector','queryAll','query','remove','ownerDocument',],
'dart.dom.html.ShadowRoot': const ['querySelector','querySelectorAll','host','children','append','contains','query','activeElement','supported','nodes','firstChild','getElementsByTagName','text','innerHtml','olderShadowRoot',],
'dart.mirrors.TypeMirror': const ['qualifiedName','isSubtypeOf','reflectedType','newInstance','isAssignableTo','simpleName','typeArguments','originalDeclaration','toString','referent','hasReflectedType','isPrivate','typeVariables','owner','invoke','isOriginalDeclaration',],
'dart.io.ServerSocket': const ['bind','close','listen',],
'dart.dom.html.PerformanceNavigation': const ['type','redirectCount',],
'dart.dom.html.Performance': const ['now','timing','navigation',],
'dart.dom.html.PerformanceTiming': const ['navigationStart',],
'dart.typed_data.ByteBuffer': const ['asUint8List','asUint32List','asInt32List','asByteData','asFloat64x2List','asInt32x4List','asFloat32x4List','asFloat64List','asFloat32List','asUint64List','asInt64List','asUint16List','asInt16List','asUint8ClampedList','asInt8List',],
'dart.io.WebSocket': const ['add','listen','close','connect','where','map','send',],
'dart.convert.JsonEncoder': const ['convert','startChunkedConversion',],
'dart.convert.JsonDecoder': const ['convert','startChunkedConversion',],
'dart.core.bool': const ['toString','should','hashCode','isAssignableFrom','parse','containsKey',],
'dart.core.FormatException': const ['toString',],
'dart.dom.html.WindowBase': const ['postMessage','navigator','close','alert',],
'dart.dom.html.ButtonElement': const ['text','onClick','classes','attributes','style','append','type','setInnerHtml','children','onMouseOut','onMouseOver','click','disabled','dataset','appendText',],
'dart.core.Exception': const ['toString','printStackTrace',],
'dart.dom.html.DataTransfer': const ['setData','setDragImage','types','effectAllowed','dropEffect','getData','files',],
'dart.math.Point': const ['x','y','distanceTo','magnitude',],
'dart.dom.html.LIElement': const ['classes','append','style','text','querySelector','innerHtml','dispatchEvent','children','dataset','className','nodes','remove','value',],
'dart.dom.html.CanvasRenderingContext2D': const ['lineTo','beginPath','fillRect','moveTo','stroke','drawImage','closePath','restore','translate','save','scale','fill','getImageData','clearRect','setTransform','strokeRect','rotate','putImageData','fillStyle','arc','transform','fillText','strokeStyle','createImageData','createPatternFromImage','clip','lineWidth','drawImageToRect','strokeText','font','rect','drawImageScaledFromSource','setFillColorRgb','createLinearGradient','bezierCurveTo','drawImageScaled','measureText','setLineDash','shadowBlur','shadowOffsetX','shadowOffsetY','shadowColor','quadraticCurveTo','imageSmoothingEnabled','textAlign','createRadialGradient','textBaseline','globalAlpha','lineCap',],
'dart.io.HeaderValue': const ['parse',],
'dart.dom.html.ScriptElement': const ['src','type','async','remove','text',],
'dart.dom.html.MouseEvent': const ['preventDefault','stopPropagation','target','dataTransfer','page','client','ctrlKey','stopImmediatePropagation','metaKey','shiftKey',],
'dart.io.RawSocket': const ['write','listen','close','connect','read','available','shutdown','setOption',],
'dart.io.RawSecureSocket': const ['secure','connect','shutdown','listen','secureServer','write','read',],
'dart.dom.web_sql.SqlDatabase': const ['transaction','supported',],
'dart.dom.web_sql.SqlTransaction': const ['executeSql',],
'dart.dom.web_sql.SqlResultSetRowList': const ['length','elementAt','isNotEmpty','item','forEach',],
'dart.convert.AsciiCodec': const ['encode','decode',],
'dart.dom.html.EventStreamProvider': const ['forTarget','forElement',],
'dart.dom.html.MutationObserver': const ['observe','disconnect','takeRecords',],
'dart.dom.html.UListElement': const ['queryAll','append','style','id','children','remove','query','insertBefore','classes',],
'dart.dom.html.VideoElement': const ['canPlayType','load','pause','play','autoplay','remove','src',],
'dart.dom.html.MediaError': const ['code',],
'dart.dom.html.TimeRanges': const ['start','end',],
'dart.dom.html.SourceElement': const ['remove',],
'dart.dom.html.ObjectElement': const ['remove','getAttribute',],
'dart.dom.html.OptionElement': const ['value','text','selected','label','appendText',],
'dart.dom.html.SpanElement': const ['classes','text','style','append','appendText','onMouseOut','onMouseOver','onClick','attributes','remove','draggable','id','outerHtml','innerHtml','setAttribute','querySelector','scrollIntoView',],
'dart.dom.html.Geolocation': const ['getCurrentPosition','watchPosition',],
'dart.dom.html.Coordinates': const ['accuracy','longitude','latitude','speed','heading','altitudeAccuracy','altitude',],
'dart.dom.html.ImageElement': const ['remove','width','height','onLoad','src','style','crossOrigin','classes','className','id','onDragStart',],
'dart.mirrors.MethodMirror': const ['parameters','isGetter','isConstructor','returnType','owner','simpleName','location','source','isStatic',],
'dart.dom.html.Storage': const ['containsKey','clear','remove','length','keys','containsValue',],
'dart.convert.ChunkedConversionSink': const ['add','close','specialI',],
'dart.collection.ListQueue': const ['add','removeFirst','addAll','addLast','removeLast','forEach','toList','removeWhere','addFirst',],
'dart.dom.html.CanvasElement': const ['getContext','style','width','height','context2D','toDataUrl','getContext3d','onMouseUp','onMouseDown','getBoundingClientRect','onMouseMove','onClick','onMouseOut','className','onMouseOver','setAttribute','remove','context2d','focus',],
'dart.dom.html.KeyboardEvent': const ['preventDefault','which','stopPropagation','ctrlKey','keyCode','stopImmediatePropagation','metaKey','altKey','shiftKey','getModifierState',],
'dart.dom.html.WebSocket': const ['send','close','onMessage','onClose','onError','onOpen','readyState','url','sendTypedData','binaryType',],
'dart.io.WebSocketTransformer': const ['upgrade','isUpgradeRequest',],
'dart.core.Symbol': const ['toString','length',],
'dart.js.JsFunction': const ['apply',],
'dart.io.InternetAddress': const ['address','host','lookup','toString','isLoopback',],
'dart.convert.Latin1Codec': const ['decode',],
'dart.dom.html.ElementEvents': const ['click','load','change','keyPress','drop','dragOver','dragEnter','input','keyDown','dragLeave','dragEnd','dragStart','mouseOut','mouseMove','keyUp','loadedMetadata',],
'dart.dom.html.TableCellElement': const ['setInnerHtml','style','append','text','insertAdjacentElement','colSpan','setAttribute','innerHtml','cellIndex',],
'dart.dom.html.TableRowElement': const ['append','attributes','classes','onClick','children','onMouseOut','onMouseOver','remove','insertCell','cells','createFragment','addCell','query','outerHtml',],
'dart.convert.Converter': const ['convert','startChunkedConversion',],
'dart.dom.html.FormData': const ['append','appendBlob',],
'dart.io.ProcessException': const ['toString',],
'dart.dom.html.Text': const ['remove','text','toString',],
'dart.dom.html.AnchorElement': const ['href','text','onClick','id','classes','append','dispatchEvent','replaceWith','download','click','setAttribute','appendText',],
'dart.dom.svg.LineElement': const ['setAttribute',],
'dart.dom.svg.RectElement': const ['setAttribute','attributes',],
'dart.dom.svg.EllipseElement': const ['setAttribute',],
'dart.dom.svg.PolylineElement': const ['attributes',],
'dart.dom.svg.CircleElement': const ['setAttribute',],
'dart.dom.svg.PathElement': const ['setAttribute','createSvgPathSegLinetoAbs','createSvgPathSegMovetoAbs',],
'dart.dom.html.HeadingElement': const ['text','classes','appendText','append','id',],
'dart.dom.html.TableElement': const ['insertRow','createFragment','append','children','createTBody','deleteRow','addRow','query','querySelector',],
'dart.io.HttpConnectionInfo': const ['remoteAddress','remotePort','localPort','remoteHost',],
'dart.dom.html.FormElement': const ['append','submit','children','remove',],
'dart.io.Cookie': const ['value','toString','path',],
'dart.dom.html.InputElement': const ['focus','select','value','remove','type','checkValidity','dataset','onKeyDown','setSelectionRange','dispatchEvent','selectionStart','selectionEnd','setAttribute','bind','checked','attributes','blur','setRangeText','click','onChange','placeholder','id','onKeyUp','onBlur','onKeyPress','autocomplete','onPaste','defaultChecked','onFocus','disabled',],
'dart.io.Socket': const ['close','connect','transform','destroy','add','listen','write','addStream','pipe','address','read','writeList','setOption','flush','map','readList','available',],
'dart.mirrors.ParameterMirror': const ['type','isOptional','defaultValue',],
'dart.convert.Codec': const ['fuse','encode','decode',],
'dart.dom.indexed_db.Database': const ['transaction','createObjectStore','close',],
'dart.dom.indexed_db.Transaction': const ['objectStore','onAbort','onError','onComplete',],
'dart.dom.indexed_db.ObjectStore': const ['put','delete','createIndex','getObject','index','openCursor','clear',],
'dart.dom.svg.SvgSvgElement': const ['append','setAttribute','createFragment','createSvgPoint','getScreenCtm','onMouseUp','onMouseMove',],
'dart.dom.svg.Point': const ['matrixTransform',],
'dart.dom.svg.Matrix': const ['inverse',],
'dart.dom.html.WheelEvent': const ['preventDefault','stopPropagation',],
'dart.dom.svg.AnimatedRect': const ['baseVal',],
'dart.dom.html.SelectElement': const ['append','focus','remove','classes','tabIndex','options','selectedIndex','querySelectorAll','multiple','value',],
'dart.dom.html.LabelElement': const ['query','text','append','htmlFor','style','appendText','classes',],
'dart.io.HttpSession': const ['id','destroy','clear','containsKey','isNew','remove','onTimeout',],
'dart.dom.indexed_db.IdbFactory': const ['open','deleteDatabase','supported','supportsDatabaseNames','getDatabaseNames',],
'dart.dom.indexed_db.Request': const ['result',],
'dart.dom.indexed_db.Index': const ['openCursor',],
'dart.dom.indexed_db.KeyRange': const ['upperBound_','bound_','lowerBound_','only_',],
'dart.dom.indexed_db.CursorWithValue': const ['delete',],
'dart.core.NoSuchMethodError': const ['toString',],
'dart.isolate.Isolate': const ['spawn','spawnUri','resume','addOnExitListener','removeErrorListener','addErrorListener','kill','ping','pause','setErrorsFatal',],
'dart.dom.html.TemplateElement': const ['decorate','content',],
'dart.dom.html.TreeWalker': const ['nextNode',],
'dart.dom.html.StyleElement': const ['remove','appendText','text','sheet','attributes','type','appendHtml','dataset','append','innerHtml',],
'dart.dom.html.EventTarget': const ['error','result','matchesWithAncestors','nodeName','matches','classes','dispatchEvent','removeEventListener','addEventListener','status','parent','value','hashCode',],
'dart.collection_helpers.equality.Equality': const ['hash','equals','isValidKey',],
'dart.collection_helpers.equality.SetEquality': const ['hash','equals',],
'dart.collection_helpers.equality.MapEquality': const ['hash','equals',],
'dart.collection_helpers.equality.ListEquality': const ['hash','equals',],
'dart.collection_helpers.equality.IterableEquality': const ['hash','equals',],
'dart.collection_helpers.equality.UnorderedIterableEquality': const ['hash','equals',],
'dart.io.SecureSocket': const ['initialize','close','connect','listen','write','add','fold','writeln','secure','transform',],
'dart.io.HttpDate': const ['parse','format',],
'dart.math.Rectangle': const ['top','left','containsPoint','height','width','topLeft','intersection','topRight','intersects','containsRectangle','boundingBox','snap',],
'dart.dom.html.ContentElement': const ['getDistributedNodes',],
'dart.io.SocketException': const ['toString',],
'dart.dom.html.TextAreaElement': const ['style','focus','select','rows','attributes','setSelectionRange','value','appendText','remove',],
'dart.dom.html.LinkElement': const ['href','replaceWith','rel',],
'dart.dom.html.ParagraphElement': const ['text','appendHtml','classes','addHtml','hidden',],
'dart.typed_data.Int32List': const ['setRange','indexOf','sublist','removeRange','removeLast','clear','addAll','add','setAll',],
'dart.dom.web_gl.RenderingContext': const ['ARRAY_BUFFER','texParameteri','bindBuffer','bindFramebuffer','TEXTURE_2D','enable','deleteShader','getUniformLocation','bindTexture','clear','createTexture','detachShader','attachShader','getAttribLocation','createBuffer','enableVertexAttribArray','vertexAttribPointer','FLOAT','STATIC_DRAW','createShader','shaderSource','compileShader','viewport','useProgram','clearColor','bufferDataTyped','getShaderParameter','uniformMatrix4fv','getShaderInfoLog','bindRenderbuffer','deleteTexture','deleteProgram','RGBA','linkProgram','createProgram','disableVertexAttribArray','disable','getProgramParameter','blendFunc','drawArrays','getProgramInfoLog','TRIANGLES','lineWidth','COMPILE_STATUS','texImage2DTyped','NEAREST','createFramebuffer','getExtension','framebufferTexture2D','framebufferRenderbuffer','renderbufferStorage','createRenderbuffer','ELEMENT_ARRAY_BUFFER','uniformMatrix3fv','uniform2f','UNSIGNED_BYTE','deleteFramebuffer','deleteRenderbuffer','TEXTURE_MIN_FILTER','TEXTURE_MAG_FILTER','CLAMP_TO_EDGE','DEPTH_TEST','DEPTH_BUFFER_BIT','texImage2DImage','COLOR_BUFFER_BIT','LINK_STATUS','FRAGMENT_SHADER','VERTEX_SHADER','bufferData','TEXTURE_WRAP_S','TEXTURE_WRAP_T','texImage2DCanvas','LINEAR','UNSIGNED_SHORT','texImage2D','drawElements','pixelStorei','colorMask','depthFunc','TRIANGLE_STRIP','activeTexture','TEXTURE0','depthMask','FRAMEBUFFER','UNPACK_FLIP_Y_WEBGL','generateMipmap','uniform1i',],
'dart.typed_data.Float32List': const ['sublist','indexOf','buffer','setRange','length',],
'dart.dom.html.DirectoryEntry': const ['getFile','createDirectory','createFile','createReader','getDirectory','removeRecursively','toUrl','fullPath','toString',],
'dart.dom.html.Entry': const ['moveTo','isFile','copyTo','isDirectory','fullPath','name','remove','getMetadata','createWriter','file','getParent','toUrl',],
'dart.dom.html.DirectoryReader': const ['readEntries',],
'dart.dom.html.KeyCode': const ['DOWN','RIGHT','LEFT','TAB','UP','ESC','ENTER','isCharacterKey','SPACE','NUM_SOUTH','NUM_NORTH','NUM_EAST','NUM_WEST','NUM_NORTH_EAST','NUM_SOUTH_EAST','R',],
'dart.pkg.collection.iterable_zip.IterableZip': const ['map','toList',],
'dart.convert.LineSplitter': const ['convert',],
'dart.dom.html.HttpRequestUpload': const ['onProgress','onError','onTimeout',],
'dart.dom.html.File': const ['name','slice','readAsBytesSync','existsSync',],
'dart.dom.html.Events': const ['error','message','load','hashChange','popState','resize','loadEnd',],
'dart.dom.html.Url': const ['createObjectUrl','revokeObjectUrl','createObjectUrlFromBlob','createObjectUrlFromStream',],
'dart.dom.html.RtcIceCandidate': const ['candidate','sdpMLineIndex',],
'dart.dom.html.RtcPeerConnection': const ['setLocalDescription','createDataChannel','createOffer','createAnswer',],
'dart.io.RawDatagramSocket': const ['bind','close','receive','send','listen',],
'dart.pkg.collection.equality.DeepCollectionEquality': const ['equals','hash',],
'dart.pkg.collection.priority_queue.PriorityQueue': const ['addAll','contains','removeFirst','add','removeAll',],
'dart.convert.StringConversionSink': const ['add','asUtf8Sink','close','asStringSink','addSlice',],
'dart.dom.html.ImageData': const ['data',],
'dart.dom.html.PreElement': const ['appendText','text','append','classes',],
'dart.dom.html.MediaStream': const ['stop',],
'dart.dom.html.DomParser': const ['parseFromString',],
'dart.dom.html.CustomEvent': const ['stopImmediatePropagation','preventDefault','stopPropagation',],
'dart.typed_data.Uint16List': const ['buffer','sublist','setRange','removeRange','removeLast','clear','addAll','add','length',],
'dart.dom.html.CanvasGradient': const ['addColorStop',],
'dart.dom.html.Notification': const ['requestPermission',],
'dart.dom.svg.Length': const ['value','valueAsString',],
'dart.dom.svg.AnimatedLength': const ['baseVal',],
'dart.dom.svg.PointList': const ['getItem',],
'dart.mirrors.SourceLocation': const ['line',],
'dart.DartGrammarDefinition': const ['build',],
'dart.dom.html.TextMetrics': const ['width',],
'dart.dom.html.CssRect': const ['width','height','top','left','topLeft',],
'dart.dom.html.KeyboardEventStream': const ['onKeyDown',],
'dart.dom.html.CssRule': const ['selectorText',],
'dart.dom.html.CssStyleRule': const ['style','selectorText',],
'dart.dom.html.Selection': const ['removeAllRanges','collapse','getRangeAt',],
'dart.dom.html.CheckboxInputElement': const ['checked','attributes','classes','value',],
'dart.dom.html.TextInputElement': const ['classes','value','focus','select','className','onKeyDown','style',],
'dart.dom.html.DateInputElement': const ['classes',],
'dart.dom.html.RangeInputElement': const ['style','attributes','onChange','value','step','max','min',],
'dart.dom.html.AnimationTimeline': const ['play',],
'dart.dom.html.AnimationPlayer': const ['play',],
'dart.dom.html.GlobalEventHandlers': const ['clickEvent',],
'dart.dom.html.TouchEvent': const ['preventDefault','supported','stopPropagation',],
'dart.dom.html.AudioElement': const ['canPlayType','load','append','play','pause','remove',],
'dart.io.ProcessSignal': const ['watch',],
'dart.convert.Utf8Decoder': const ['convert','startChunkedConversion',],
'dart.dom.html.AnimationEvent': const ['preventDefault','stopImmediatePropagation',],
'dart.dom.html.FocusEvent': const ['stopImmediatePropagation',],
'dart.dom.html.Touch': const ['page','client',],
'dart.async.DeferredLibrary': const ['load',],
'dart.dom.html.TableSectionElement': const ['append','innerHtml','rows','createFragment','addRow',],
'dart.mirrors.Mirror': const ['methods','invoke','type','delegate','members',],
'dart.core.StateError': const ['toString',],
'dart.io.FileMode': const ['APPEND','READ','WRITE',],
'dart.dom.html.CssStyleDeclarationBase': const ['display','backgroundColor','opacity','borderLeftWidth',],
'dart.dom.html.IFrameElement': const ['style','src',],
'dart.io.FileSystemException': const ['toString',],
'dart.dom.html.Screen': const ['width','height','pixelDepth',],
'dart.core.ArgumentError': const ['toString',],
'dart.dom.html.Blob': const ['slice',],
'dart.dom.svg.PatternElement': const ['setAttribute','append',],
'dart.dom.svg.DefsElement': const ['append',],
'dart.dom.svg.PathSegList': const ['appendItem','clear','length','getItem',],
'dart.dom.html.FileList': const ['length','item',],
'dart.dom.html.FileError': const ['NOT_FOUND_ERR','code',],
'dart.mirrors.VariableMirror': const ['type','isFinal','isStatic',],
'dart.io.HttpStatus': const ['NOT_FOUND',],
'dart.typed_data.Float64List': const ['sublist','indexOf','setRange',],
'dart.typed_data.Float32x4': const ['shuffle','shuffleMix','scale','signMask','clamp','withX','withY','w','z','y','x',],
'dart.pkg.typed_data.typed_buffers.Int32x4Buffer': const ['add',],
'dart.dom.html.NumberInputElement': const ['step','max','min','valueAsNumber',],
'dart.dom.html.ValidityState': const ['valid',],
'dart.dom.html.CssStyleSheet': const ['ownerNode','insertRule','addRule',],
'dart.io.ZLibCodec': const ['decode',],
'dart.collection.HasNextIterator': const ['next',],
'dart.isolate.RawReceivePort': const ['close',],
'dart.mirrors.TypeVariableMirror': const ['simpleName','isSubtypeOf','isAssignableTo','owner',],
'dart.typed_data.implementation.NativeByteBuffer': const ['asFloat64List','asFloat32List','asInt32List',],
'dart.typed_data.implementation.NativeFloat32x4List': const ['length',],
'dart.typed_data.implementation.NativeFloat32List': const ['sublist',],
'dart.typed_data.implementation.NativeInt32x4List': const ['length',],
'dart.typed_data.implementation.NativeFloat64x2List': const ['length',],
'dart.typed_data.implementation.NativeFloat64List': const ['sublist',],
'dart.typed_data.implementation.NativeTypedArray': const ['length',],
'dart.typed_data.implementation.NativeTypedArrayOfDouble': const ['setRange',],
'dart.typed_data.implementation.NativeTypedArrayOfInt': const ['setRange',],
'dart.typed_data.implementation.NativeInt32x4': const ['w','z','y','x',],
'dart.dom.svg.SvgElement': const ['isTagSupported','clone','setAttribute','children','setInnerHtml','attributes',],
'dart.dom.svg.GElement': const ['append','querySelector','id',],
'dart.dom.html.ProgressEvent': const ['toString',],
'dart.core.RangeError': const ['toString','checkValidRange','checkNotNegative','checkValueInInterval','checkValidIndex',],
'dart.dom.html.TouchList': const ['length','first','isEmpty','isNotEmpty',],
'dart.dom.html.FieldSetElement': const ['append','querySelector',],
'dart.dom.html.ShadowElement': const ['getDistributedNodes',],
'dart.dom.html.KeyEvent': const ['keyCode','type','preventDefault',],
'dart.dom.html.NodeList': const ['length','add',],
'dart.dom.html.DomStringList': const ['length',],
'dart.dom.html.HtmlCollection': const ['length','forEach','contains',],
'dart.dom.html.Range': const ['createContextualFragment','selectNodeContents','insertNode','setEndAfter',],
'dart.dom.html.NodeTreeSanitizer': const ['sanitizeTree',],
'dart.dom.html.MimeTypeArray': const ['length',],
'dart.dom.html.PluginArray': const ['length',],
'dart.dom.html.SourceBufferList': const ['length',],
'dart.dom.html.SpeechGrammarList': const ['length',],
'dart.dom.html.TextTrackCueList': const ['length',],
'dart.dom.html.TextTrackList': const ['length',],
'dart.dom.html.Dimension': const ['value','toString',],
'dart.dom.html.UriPolicy': const ['allowsUri',],
'dart.dom.html.NodeValidator': const ['allowsAttribute','allowsElement',],
'dart.dom.html.Worker': const ['terminate',],
'dart.typed_data.Int16List': const ['sublist','buffer','contains','setRange','removeRange','removeLast','clear','addAll','add',],
'dart.dom.indexed_db.Cursor': const ['next',],
'dart.dom.svg.LengthList': const ['length','getItem',],
'dart.dom.svg.NumberList': const ['length','getItem',],
'dart.dom.svg.StringList': const ['length','getItem',],
'dart.dom.svg.TransformList': const ['length','getItem',],
'dart.js.JsArray': const ['length','addAll','insert','removeRange','removeAt','add','setRange','removeLast',],
'dart.dom.html.ApplicationCache': const ['swapCache',],
'dart.dom.web_audio.AudioContext': const ['createBufferSource','createOscillator','destination','createPanner','createGain',],
'dart.dom.html.FileUploadInputElement': const ['click',],
'dart.dom.html.DomRectReadOnly': const ['top','left','height','width',],
'dart.typed_data.Int8List': const ['sublist','setRange','removeRange','removeLast','clear','addAll','add','buffer',],
'dart.dom.web_audio.AudioBufferSourceNode': const ['connectNode','start','stop',],
'dart.dom.html.FileEntry': const ['file','getParent','toUrl','getMetadata',],
'dart.dom.html.CustomStream': const ['listen',],
'dart.dom.html.TrackElement': const ['defaultValue',],
'dart.dom.web_audio.OscillatorNode': const ['connectNode',],
'dart.dom.html.StorageQuota': const ['queryInfo',],
'dart.collection.DoubleLinkedQueue': const ['add',],
'dart.core.TypeError': const ['toString',],
'dart.core.AssertionError': const ['toString',],
'dart.profiler.Metrics': const ['register',],
'dart.collection.LinkedList': const ['remove','addFirst','clear','add',],
'dart.typed_data.Uint8ClampedList': const ['sublist',],
'dart.typed_data.Float64x2': const ['y','x','withX',],
'dart.convert.ByteConversionSink': const ['close','add','addSlice',],
'dart.convert.ClosableStringSink': const ['close','write',],
'dart.mirrors.TypedefMirror': const ['isSubtypeOf','isAssignableTo','referent',],
'dart.mirrors.FunctionTypeMirror': const ['isSubtypeOf','isAssignableTo','returnType','parameters','isOriginalDeclaration',],
'dart.mirrors.LibraryDependencyMirror': const ['metadata',],
'dart.test.stream_from_iterable.IterableTest': const ['run',],
'dart.io.SecureServerSocket': const ['bind','close','listen',],
'dart.io.RawServerSocket': const ['bind','listen','close',],
'dart.typed_data.Uint64List': const ['sublist','setRange','removeRange','removeLast','clear','addAll','add',],
'dart.typed_data.Int64List': const ['sublist','setRange','removeRange','removeLast','clear','addAll','add',],
'dart.io.StdioType': const ['name',],
'dart.io.HttpConnectionsInfo': const ['total','idle','active',],
'dart.io.RawSecureServerSocket': const ['bind','close','listen',],
'dart.io.ServerSocketReference': const ['create',],
'dart.io.NetworkInterface': const ['list',],
'dart.io.ZLibDecoder': const ['convert',],
'dart.io.ZLibEncoder': const ['convert',],
'dart.pkg.async.results.ValueResult': const ['value',],
'dart.pkg.async.stream_zip.StreamZip': const ['toList',],
'dart.pkg.async.results.Result': const ['flatten','release',],
'dart.pkg.async.results.ErrorResult': const ['stackTrace','error',],
'dart.dom.html.OptGroupElement': const ['append',],
'dart.dom.html.UnknownElement': const ['query',],
'dart.dom.web_audio.AudioParam': const ['value','setValueAtTime',],
'dart.dom.html.RadioButtonInputElement': const ['checked',],
'dart.dom.web_audio.BiquadFilterNode': const ['connectNode',],
'dart.async.StreamConsumer': const ['addStream','close',],
'dart.dom.html.FileSystem': const ['root',],
'dart.dom.html.FileWriter': const ['write','abort',],
'dart.dom.html.OutputElement': const ['scrollIntoView',],
'dart.dom.html.Css': const ['supports',],
'dart.io.IOException': const ['toString',],
'dart.dom.html.ButtonInputElement': const ['value','onClick',],
};
