/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.DefaultPendingSource;
import org.gradle.api.internal.collections.IndexedElementSource;
import org.gradle.api.internal.collections.PendingSource;
import org.gradle.api.internal.provider.ProviderInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListElementSource<T>
implements IndexedElementSource<T> {
    private final List<T> values = new ArrayList<T>();
    private final PendingSource<T> pending = new DefaultPendingSource();

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public boolean constantTimeIsEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size() + this.pending.size();
    }

    @Override
    public int estimatedSize() {
        return this.values.size() + this.pending.size();
    }

    @Override
    public Iterator<T> iterator() {
        this.pending.realizePending();
        return this.values.iterator();
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return this.values.iterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.values.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.values.listIterator(index);
    }

    @Override
    public boolean contains(Object element) {
        this.pending.realizePending();
        return this.values.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        this.pending.realizePending();
        return this.values.containsAll(elements);
    }

    @Override
    public List<? extends T> subList(int fromIndex, int toIndex) {
        return this.values.subList(fromIndex, toIndex);
    }

    @Override
    public T get(int index) {
        return this.values.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    @Override
    public boolean add(T element) {
        return this.values.add(element);
    }

    @Override
    public void add(int index, T element) {
        this.values.add(index, element);
    }

    @Override
    public T set(int index, T element) {
        return this.values.set(index, element);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public T remove(int index) {
        return this.values.remove(index);
    }

    @Override
    public void clear() {
        this.pending.clear();
        this.values.clear();
    }

    @Override
    public void realizePending() {
        this.pending.realizePending();
    }

    @Override
    public void realizePending(Class<?> type) {
        this.pending.realizePending(type);
    }

    @Override
    public void addPending(ProviderInternal<? extends T> provider) {
        this.pending.addPending(provider);
    }

    @Override
    public void removePending(ProviderInternal<? extends T> provider) {
        this.pending.removePending(provider);
    }

    @Override
    public void onRealize(Action<ProviderInternal<? extends T>> action) {
        this.pending.onRealize(action);
    }
}

