/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;

final class CollectSpliterators {
    static <T> Spliterator<T> indexed(int size, int extraCharacteristics, IntFunction<T> function2) {
        return CollectSpliterators.indexed(size, extraCharacteristics, function2, null);
    }

    static <T> Spliterator<T> indexed(int size, int extraCharacteristics, IntFunction<T> function2, Comparator<? super T> comparator) {
        if (comparator != null) {
            Preconditions.checkArgument((extraCharacteristics & 4) != 0);
        }
        class WithCharacteristics
        implements Spliterator<T> {
            private final Spliterator<T> delegate;
            final /* synthetic */ int val$extraCharacteristics;
            final /* synthetic */ Comparator val$comparator;

            WithCharacteristics(Spliterator<T> delegate) {
                this.val$extraCharacteristics = n;
                this.val$comparator = var3_3;
                this.delegate = delegate;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action2) {
                return this.delegate.tryAdvance(action2);
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action2) {
                this.delegate.forEachRemaining(action2);
            }

            @Override
            public Spliterator<T> trySplit() {
                Spliterator split = this.delegate.trySplit();
                return split == null ? null : new WithCharacteristics(split, this.val$extraCharacteristics, this.val$comparator);
            }

            @Override
            public long estimateSize() {
                return this.delegate.estimateSize();
            }

            @Override
            public int characteristics() {
                return this.delegate.characteristics() | this.val$extraCharacteristics;
            }

            @Override
            public Comparator<? super T> getComparator() {
                if (this.hasCharacteristics(4)) {
                    return this.val$comparator;
                }
                throw new IllegalStateException();
            }
        }
        return new WithCharacteristics(IntStream.range(0, size).mapToObj(function2).spliterator(), extraCharacteristics, comparator);
    }

    static <F, T> Spliterator<T> map(final Spliterator<F> fromSpliterator, final Function<? super F, ? extends T> function2) {
        Preconditions.checkNotNull(fromSpliterator);
        Preconditions.checkNotNull(function2);
        return new Spliterator<T>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action2) {
                return fromSpliterator.tryAdvance(fromElement -> action2.accept((Object)function2.apply(fromElement)));
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action2) {
                fromSpliterator.forEachRemaining(fromElement -> action2.accept((Object)function2.apply(fromElement)));
            }

            @Override
            public Spliterator<T> trySplit() {
                Spliterator fromSplit = fromSpliterator.trySplit();
                return fromSplit != null ? CollectSpliterators.map(fromSplit, function2) : null;
            }

            @Override
            public long estimateSize() {
                return fromSpliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return fromSpliterator.characteristics() & 0xFFFFFEFA;
            }
        };
    }

    static <F, T> Spliterator<T> flatMap(Spliterator<F> fromSpliterator, Function<? super F, Spliterator<T>> function2, int topCharacteristics, long topSize) {
        Preconditions.checkArgument((topCharacteristics & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((topCharacteristics & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(fromSpliterator);
        Preconditions.checkNotNull(function2);
        class FlatMapSpliterator
        implements Spliterator<T> {
            Spliterator<T> prefix;
            final Spliterator<F> from;
            final int characteristics;
            long estimatedSize;
            final /* synthetic */ Function val$function;

            FlatMapSpliterator(Spliterator<T> prefix, Spliterator<F> from, int characteristics, long estimatedSize) {
                this.val$function = var6_5;
                this.prefix = prefix;
                this.from = from;
                this.characteristics = characteristics;
                this.estimatedSize = estimatedSize;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action2) {
                do {
                    if (this.prefix != null && this.prefix.tryAdvance(action2)) {
                        if (this.estimatedSize != Long.MAX_VALUE) {
                            --this.estimatedSize;
                        }
                        return true;
                    }
                    this.prefix = null;
                } while (this.from.tryAdvance(fromElement -> {
                    this.prefix = (Spliterator)this.val$function.apply(fromElement);
                }));
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action2) {
                if (this.prefix != null) {
                    this.prefix.forEachRemaining(action2);
                    this.prefix = null;
                }
                this.from.forEachRemaining(fromElement -> ((Spliterator)this.val$function.apply(fromElement)).forEachRemaining(action2));
                this.estimatedSize = 0L;
            }

            @Override
            public Spliterator<T> trySplit() {
                Spliterator fromSplit = this.from.trySplit();
                if (fromSplit != null) {
                    int splitCharacteristics = this.characteristics & 0xFFFFFFBF;
                    long estSplitSize = this.estimateSize();
                    if (estSplitSize < Long.MAX_VALUE) {
                        this.estimatedSize -= (estSplitSize /= 2L);
                    }
                    FlatMapSpliterator result2 = new FlatMapSpliterator(this.prefix, fromSplit, splitCharacteristics, estSplitSize, this.val$function);
                    this.prefix = null;
                    return result2;
                }
                if (this.prefix != null) {
                    Spliterator result3 = this.prefix;
                    this.prefix = null;
                    return result3;
                }
                return null;
            }

            @Override
            public long estimateSize() {
                if (this.prefix != null) {
                    this.estimatedSize = Math.max(this.estimatedSize, this.prefix.estimateSize());
                }
                return Math.max(this.estimatedSize, 0L);
            }

            @Override
            public int characteristics() {
                return this.characteristics;
            }
        }
        return new FlatMapSpliterator(null, fromSpliterator, topCharacteristics, topSize, function2);
    }
}

