/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.StyleEditor;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.SyntaxUtilities;

public class SyntaxHiliteOptionPane
extends AbstractOptionPane {
    public static final EmptyBorder noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private StyleTableModel styleModel;
    private JTable styleTable;

    public SyntaxHiliteOptionPane() {
        super("syntax");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout(6, 6));
        this.add("Center", this.createStyleTableScroller());
    }

    @Override
    protected void _save() {
        this.styleModel.save();
    }

    private JScrollPane createStyleTableScroller() {
        this.styleModel = SyntaxHiliteOptionPane.createStyleTableModel();
        this.styleTable = new JTable(this.styleModel);
        this.styleTable.setRowHeight(GenericGUIUtilities.defaultRowHeight());
        this.styleTable.setRowSelectionAllowed(false);
        this.styleTable.setColumnSelectionAllowed(false);
        this.styleTable.setCellSelectionEnabled(false);
        this.styleTable.getTableHeader().setReorderingAllowed(false);
        this.styleTable.addMouseListener(new MouseHandler());
        TableColumnModel tableColumnModel = this.styleTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellRenderer(new StyleTableModel.StyleRenderer());
        Dimension dimension = this.styleTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 100);
        JScrollPane jScrollPane = new JScrollPane(this.styleTable);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    private static StyleTableModel createStyleTableModel() {
        return new StyleTableModel();
    }

    private static class StyleTableModel
    extends AbstractTableModel {
        private final List<StyleChoice> styleChoices = new Vector<StyleChoice>(23);

        StyleTableModel() {
            for (int i = 1; i < 19; ++i) {
                String string = Token.tokenToString((byte)i);
                this.addStyleChoice(string, "view.style." + string.toLowerCase());
            }
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.1"), "view.style.foldLine.1");
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.2"), "view.style.foldLine.2");
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.3"), "view.style.foldLine.3");
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.0"), "view.style.foldLine.0");
            Collections.sort(this.styleChoices, new StandardUtilities.StringCompare(true));
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.styleChoices.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StyleChoice styleChoice = this.styleChoices.get(n);
            switch (n2) {
                case 0: {
                    return styleChoice.label;
                }
                case 1: {
                    return styleChoice.style;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            StyleChoice styleChoice = this.styleChoices.get(n);
            if (n2 == 1) {
                styleChoice.style = (SyntaxStyle)object;
            }
            this.fireTableRowsUpdated(n, n);
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return jEdit.getProperty("options.syntax.object");
                }
                case 1: {
                    return jEdit.getProperty("options.syntax.style");
                }
            }
            return null;
        }

        public void save() {
            for (StyleChoice styleChoice : this.styleChoices) {
                jEdit.setProperty(styleChoice.property, GUIUtilities.getStyleString(styleChoice.style));
            }
        }

        private void addStyleChoice(String string, String string2) {
            Font font = new JLabel().getFont();
            this.styleChoices.add(new StyleChoice(string, string2, SyntaxUtilities.parseStyle(jEdit.getProperty(string2), font.getFamily(), font.getSize(), true)));
        }

        static class StyleRenderer
        extends JLabel
        implements TableCellRenderer {
            StyleRenderer() {
                this.setOpaque(true);
                this.setBorder(noFocusBorder);
                this.setText("Hello World");
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    SyntaxStyle syntaxStyle = (SyntaxStyle)object;
                    this.setForeground(syntaxStyle.getForegroundColor());
                    if (syntaxStyle.getBackgroundColor() != null) {
                        this.setBackground(syntaxStyle.getBackgroundColor());
                    } else {
                        this.setBackground(jEdit.getColorProperty("view.bgColor"));
                    }
                    this.setFont(syntaxStyle.getFont());
                }
                this.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
        }

        private static class StyleChoice {
            private String label;
            private String property;
            private SyntaxStyle style;

            StyleChoice(String string, String string2, SyntaxStyle syntaxStyle) {
                this.label = string;
                this.property = string2;
                this.style = syntaxStyle;
            }

            public String toString() {
                return this.label;
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SyntaxStyle syntaxStyle;
            int n = SyntaxHiliteOptionPane.this.styleTable.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            SyntaxStyle syntaxStyle2 = (SyntaxStyle)SyntaxHiliteOptionPane.this.styleModel.getValueAt(n, 1);
            String string = (String)SyntaxHiliteOptionPane.this.styleModel.getValueAt(n, 0);
            JDialog jDialog = GenericGUIUtilities.getParentDialog(SyntaxHiliteOptionPane.this);
            if (jDialog != null) {
                syntaxStyle = new StyleEditor(jDialog, syntaxStyle2, string).getStyle();
            } else {
                View view = GUIUtilities.getView(SyntaxHiliteOptionPane.this);
                syntaxStyle = new StyleEditor(view, syntaxStyle2, string).getStyle();
            }
            if (syntaxStyle != null) {
                SyntaxHiliteOptionPane.this.styleModel.setValueAt(syntaxStyle, n, 1);
            }
        }
    }
}

