/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.PolarCoor;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class OrthogonalizeAction
extends JosmAction {
    private static final String USAGE = I18n.tr("<h3>When one or more ways are selected, the shape is adjusted such, that all angles are 90 or 180 degrees.</h3>You can add two nodes to the selection. Then, the direction is fixed by these two reference nodes. (Afterwards, you can undo the movement for certain nodes:<br>Select them and press the shortcut for Orthogonalize / Undo. The default is Shift-Q.)", new Object[0]);
    private static final double EPSILON = 1.0E-6;
    private static final double TOLERANCE1 = Utils.toRadians(45.0);
    private static final double TOLERANCE2 = Utils.toRadians(45.0);
    private static final Map<Node, EastNorth> rememberMovements = new HashMap<Node, EastNorth>();

    public OrthogonalizeAction() {
        super(I18n.tr("Orthogonalize Shape", new Object[0]), "ortho", I18n.tr("Move nodes so all angles are 90 or 180 degrees", new Object[0]), Shortcut.registerShortcut("tools:orthogonalize", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape", new Object[0])), 81, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/OrthogonalizeShape"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg;
        if (!this.isEnabled()) {
            return;
        }
        if ("EPSG:4326".equals(Main.getProjection().toString()) && !ConditionalOptionPaneUtil.showConfirmationDialog("align_rectangular_4326", Main.parent, msg = I18n.tr("<html>You are using the EPSG:4326 projection which might lead<br>to undesirable results when doing rectangular alignments.<br>Change your projection to get rid of this warning.<br>Do you want to continue?</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 0, 3, 0)) {
            return;
        }
        Collection<OsmPrimitive> sel = this.getLayerManager().getEditDataSet().getSelected();
        try {
            MainApplication.undoRedo.add(OrthogonalizeAction.orthogonalize(sel));
        }
        catch (InvalidUserInputException ex) {
            Logging.debug(ex);
            String msg2 = "usage".equals(ex.getMessage()) ? "<h2>" + I18n.tr("Usage", new Object[0]) + "</h2>" + USAGE : ex.getMessage() + "<br><hr><h2>" + I18n.tr("Usage", new Object[0]) + "</h2>" + USAGE;
            new Notification(msg2).setIcon(1).setDuration(Notification.TIME_DEFAULT).show();
        }
    }

    public static SequenceCommand orthogonalize(Iterable<OsmPrimitive> selection) throws InvalidUserInputException {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<WayData> wayDataList = new ArrayList<WayData>();
        for (OsmPrimitive p : selection) {
            if (p instanceof Node) {
                nodeList.add((Node)p);
                continue;
            }
            if (p instanceof Way) {
                if (p.isIncomplete()) continue;
                wayDataList.add(new WayData(((Way)p).getNodes()));
                continue;
            }
            throw new InvalidUserInputException(I18n.tr("Selection must consist only of ways and nodes.", new Object[0]));
        }
        int nodesCount = nodeList.size();
        if (wayDataList.isEmpty() && nodesCount > 2) {
            WayData data = new WayData(nodeList);
            Collection<Command> commands = OrthogonalizeAction.orthogonalize(Collections.singletonList(data), Collections.emptyList());
            return new SequenceCommand(I18n.tr("Orthogonalize", new Object[0]), commands);
        }
        if (wayDataList.isEmpty()) {
            throw new InvalidUserInputException("usage");
        }
        if (nodesCount <= 2) {
            rememberMovements.clear();
            LinkedList<Command> commands = new LinkedList<Command>();
            if (nodesCount == 2) {
                commands.addAll(OrthogonalizeAction.orthogonalize(wayDataList, nodeList));
            } else if (nodesCount == 1) {
                commands.add(OrthogonalizeAction.orthogonalize(wayDataList, (Node)nodeList.get(0)));
            } else if (nodesCount == 0) {
                for (List<WayData> g : OrthogonalizeAction.buildGroups(wayDataList)) {
                    commands.addAll(OrthogonalizeAction.orthogonalize(g, nodeList));
                }
            }
            return new SequenceCommand(I18n.tr("Orthogonalize", new Object[0]), commands);
        }
        throw new InvalidUserInputException("usage");
    }

    private static List<List<WayData>> buildGroups(List<WayData> wayDataList) {
        ArrayList<List<WayData>> groups = new ArrayList<List<WayData>>();
        HashSet<WayData> remaining = new HashSet<WayData>(wayDataList);
        while (!remaining.isEmpty()) {
            ArrayList<WayData> group = new ArrayList<WayData>();
            groups.add(group);
            Iterator it = remaining.iterator();
            WayData next = (WayData)it.next();
            it.remove();
            OrthogonalizeAction.extendGroupRec(group, next, new ArrayList<WayData>(remaining));
            remaining.removeAll(group);
        }
        return groups;
    }

    private static void extendGroupRec(List<WayData> group, WayData newGroupMember, List<WayData> remaining) {
        group.add(newGroupMember);
        for (int i = 0; i < remaining.size(); ++i) {
            WayData candidate = remaining.get(i);
            if (candidate == null || Collections.disjoint(candidate.wayNodes, newGroupMember.wayNodes)) continue;
            remaining.set(i, null);
            OrthogonalizeAction.extendGroupRec(group, candidate, remaining);
        }
    }

    private static Command orthogonalize(List<WayData> wayDataList, Node singleNode) throws InvalidUserInputException {
        ArrayList<EastNorth> rightAnglePositions = new ArrayList<EastNorth>();
        int wayCount = wayDataList.size();
        for (WayData wd : wayDataList) {
            Node n2;
            Node n0;
            int n = wd.wayNodes.size();
            int i = wd.wayNodes.indexOf(singleNode);
            if (i == 0 && n >= 3 && singleNode.equals(wd.wayNodes.get(n - 1))) {
                n0 = wd.wayNodes.get(n - 2);
                n2 = wd.wayNodes.get(1);
            } else {
                if (i <= 0 || i >= n - 1) continue;
                n0 = wd.wayNodes.get(i - 1);
                n2 = wd.wayNodes.get(i + 1);
            }
            EastNorth n0en = n0.getEastNorth();
            EastNorth n1en = singleNode.getEastNorth();
            EastNorth n2en = n2.getEastNorth();
            double angle = Geometry.getNormalizedAngleInDegrees(Geometry.getCornerAngle(n0en, n1en, n2en));
            if (wayCount != 1 && (!(80.0 <= angle) || !(angle <= 100.0))) continue;
            EastNorth c = n0en.getCenter(n2en);
            double r = n0en.distance(n2en) / 2.0;
            double vX = n1en.east() - c.east();
            double vY = n1en.north() - c.north();
            double magV = Math.sqrt(vX * vX + vY * vY);
            rightAnglePositions.add(new EastNorth(c.east() + vX / magV * r, c.north() + vY / magV * r));
        }
        if (rightAnglePositions.isEmpty()) {
            throw new InvalidUserInputException("Unable to orthogonalize " + singleNode);
        }
        return new MoveCommand(singleNode, Main.getProjection().eastNorth2latlon(Geometry.getCentroidEN(rightAnglePositions)));
    }

    private static Collection<Command> orthogonalize(List<WayData> wayDataList, List<Node> headingNodes) throws InvalidUserInputException {
        Direction[][] orientations;
        double headingAll;
        try {
            if (headingNodes.isEmpty()) {
                wayDataList.get(0).calcDirections(Direction.RIGHT);
                double refHeading = wayDataList.get((int)0).heading;
                EastNorth totSum = new EastNorth(0.0, 0.0);
                for (WayData wayData : wayDataList) {
                    wayData.calcDirections(Direction.RIGHT);
                    int directionOffset = OrthogonalizeAction.angleToDirectionChange(wayData.heading - refHeading, TOLERANCE2);
                    wayData.calcDirections(Direction.RIGHT.changeBy(directionOffset));
                    if (OrthogonalizeAction.angleToDirectionChange(refHeading - wayData.heading, TOLERANCE2) != 0) {
                        throw new JosmRuntimeException("orthogonalize error");
                    }
                    totSum = EN.sum(totSum, wayData.segSum);
                }
                headingAll = EN.polar(EastNorth.ZERO, totSum);
            } else {
                headingAll = EN.polar(headingNodes.get(0).getEastNorth(), headingNodes.get(1).getEastNorth());
                for (WayData wayData : wayDataList) {
                    wayData.calcDirections(Direction.RIGHT);
                    int directionOffset = OrthogonalizeAction.angleToDirectionChange(wayData.heading - headingAll, TOLERANCE2);
                    wayData.calcDirections(Direction.RIGHT.changeBy(directionOffset));
                }
            }
        }
        catch (RejectedAngleException ex) {
            throw new InvalidUserInputException(I18n.tr("<html>Please make sure all selected ways head in a similar direction<br>or orthogonalize them one by one.</html>", new Object[0]), ex);
        }
        HashSet<Node> allNodes = new HashSet<Node>();
        for (WayData w : wayDataList) {
            allNodes.addAll(w.wayNodes);
        }
        HashMap<Node, Double> hashMap = new HashMap<Node, Double>();
        HashMap<Node, Double> nY = new HashMap<Node, Double>();
        EastNorth pivot = EastNorth.ZERO;
        for (Node n : allNodes) {
            pivot = EN.sum(pivot, n.getEastNorth());
        }
        pivot = new EastNorth(pivot.east() / (double)allNodes.size(), pivot.north() / (double)allNodes.size());
        for (Node n : allNodes) {
            EastNorth tmp = EN.rotateCC(pivot, n.getEastNorth(), -headingAll);
            hashMap.put(n, tmp.east());
            nY.put(n, tmp.north());
        }
        Direction[] directionArray = new Direction[]{Direction.RIGHT, Direction.LEFT};
        Direction[] vertical = new Direction[]{Direction.UP, Direction.DOWN};
        for (Direction[] orientation : orientations = new Direction[][]{directionArray, vertical}) {
            HashSet s = new HashSet(allNodes);
            int size = s.size();
            for (int dummy = 0; dummy < size && !s.isEmpty(); ++dummy) {
                Node dummyN = (Node)s.iterator().next();
                HashSet<Node> cs = new HashSet<Node>();
                cs.add(dummyN);
                boolean somethingHappened = true;
                while (somethingHappened) {
                    somethingHappened = false;
                    for (WayData w : wayDataList) {
                        for (int i = 0; i < w.nSeg; ++i) {
                            Node n1 = w.wayNodes.get(i);
                            Node n2 = w.wayNodes.get(i + 1);
                            if (!Arrays.asList(orientation).contains((Object)w.segDirections[i])) continue;
                            if (cs.contains(n1) && !cs.contains(n2)) {
                                cs.add(n2);
                                somethingHappened = true;
                            }
                            if (!cs.contains(n2) || cs.contains(n1)) continue;
                            cs.add(n1);
                            somethingHappened = true;
                        }
                    }
                }
                HashMap<Node, Double> nC = orientation == directionArray ? nY : hashMap;
                double average = 0.0;
                for (Node n : cs) {
                    s.remove(n);
                    average += ((Double)nC.get(n)).doubleValue();
                }
                average /= (double)cs.size();
                for (Node fn : headingNodes) {
                    if (!cs.contains(fn)) continue;
                    average = (Double)nC.get(fn);
                }
                if (orientation == vertical && headingNodes.size() == 2 && cs.containsAll(headingNodes)) continue;
                for (Node n : cs) {
                    nC.put(n, average);
                }
            }
            if (s.isEmpty()) continue;
            throw new JosmRuntimeException("orthogonalize error");
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        for (Node n : allNodes) {
            EastNorth tmp = new EastNorth((Double)hashMap.get(n), (Double)nY.get(n));
            tmp = EN.rotateCC(pivot, tmp, headingAll);
            double dx = tmp.east() - n.getEastNorth().east();
            double dy = tmp.north() - n.getEastNorth().north();
            if (headingNodes.contains(n)) {
                if (Math.abs(dx) > Math.abs(1.0E-6 * tmp.east()) || Math.abs(dy) > Math.abs(1.0E-6 * tmp.east())) {
                    throw new AssertionError((Object)"heading node has changed");
                }
                continue;
            }
            rememberMovements.put(n, new EastNorth(dx, dy));
            commands.add(new MoveCommand((OsmPrimitive)n, dx, dy));
        }
        return commands;
    }

    private static double standardAngle0to2PI(double a) {
        while (a >= Math.PI * 2) {
            a -= Math.PI * 2;
        }
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    private static double standardAngleMPItoPI(double a) {
        while (a > Math.PI) {
            a -= Math.PI * 2;
        }
        while (a <= -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    private static int angleToDirectionChange(double a, double deltaMax) throws RejectedAngleException {
        int dirChange;
        a = OrthogonalizeAction.standardAngleMPItoPI(a);
        double d0 = Math.abs(a);
        double d90 = Math.abs(a - 1.5707963267948966);
        double dm90 = Math.abs(a + 1.5707963267948966);
        if (d0 < deltaMax) {
            dirChange = 0;
        } else if (d90 < deltaMax) {
            dirChange = 1;
        } else if (dm90 < deltaMax) {
            dirChange = -1;
        } else {
            double d180 = Math.abs((a = OrthogonalizeAction.standardAngle0to2PI(a)) - Math.PI);
            if (d180 < deltaMax) {
                dirChange = 2;
            } else {
                throw new RejectedAngleException();
            }
        }
        return dirChange;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    protected static class RejectedAngleException
    extends Exception {
        RejectedAngleException() {
        }
    }

    public static final class InvalidUserInputException
    extends Exception {
        InvalidUserInputException(String message) {
            super(message);
        }

        InvalidUserInputException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static final class EN {
        private EN() {
        }

        public static EastNorth rotateCC(EastNorth pivot, EastNorth en, double angle) {
            double cosPhi = Math.cos(angle);
            double sinPhi = Math.sin(angle);
            double x = en.east() - pivot.east();
            double y = en.north() - pivot.north();
            double nx = cosPhi * x - sinPhi * y + pivot.east();
            double ny = sinPhi * x + cosPhi * y + pivot.north();
            return new EastNorth(nx, ny);
        }

        public static EastNorth sum(EastNorth en1, EastNorth en2) {
            return new EastNorth(en1.east() + en2.east(), en1.north() + en2.north());
        }

        public static EastNorth diff(EastNorth en1, EastNorth en2) {
            return new EastNorth(en1.east() - en2.east(), en1.north() - en2.north());
        }

        public static double polar(EastNorth en1, EastNorth en2) {
            return PolarCoor.computeAngle(en2, en1);
        }
    }

    static enum Direction {
        RIGHT,
        UP,
        LEFT,
        DOWN;


        public Direction changeBy(int directionChange) {
            int tmp = (this.ordinal() + directionChange) % 4;
            if (tmp < 0) {
                tmp += 4;
            }
            return Direction.values()[tmp];
        }
    }

    private static class WayData {
        public final List<Node> wayNodes;
        public final int nSeg;
        public final int nNode;
        public final Direction[] segDirections;
        public EastNorth segSum;
        public double heading;

        WayData(List<Node> wayNodes) {
            this.wayNodes = wayNodes;
            this.nNode = wayNodes.size();
            this.nSeg = this.nNode - 1;
            this.segDirections = new Direction[this.nSeg];
        }

        public void calcDirections(Direction pInitialDirection) throws InvalidUserInputException {
            Direction direction;
            EastNorth[] en = new EastNorth[this.nNode];
            for (int i = 0; i < this.nNode; ++i) {
                en[i] = this.wayNodes.get(i).getEastNorth();
            }
            this.segDirections[0] = direction = pInitialDirection;
            for (int i = 0; i < this.nSeg - 1; ++i) {
                double h1 = EN.polar(en[i], en[i + 1]);
                double h2 = EN.polar(en[i + 1], en[i + 2]);
                try {
                    direction = direction.changeBy(OrthogonalizeAction.angleToDirectionChange(h2 - h1, TOLERANCE1));
                }
                catch (RejectedAngleException ex) {
                    throw new InvalidUserInputException(I18n.tr("Please select ways with angles of approximately 90 or 180 degrees.", new Object[0]), ex);
                }
                this.segDirections[i + 1] = direction;
            }
            EastNorth h = new EastNorth(0.0, 0.0);
            EastNorth v = new EastNorth(0.0, 0.0);
            for (int i = 0; i < this.nSeg; ++i) {
                EastNorth segment = EN.diff(en[i + 1], en[i]);
                if (this.segDirections[i] == Direction.RIGHT) {
                    h = EN.sum(h, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.UP) {
                    v = EN.sum(v, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.LEFT) {
                    h = EN.diff(h, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.DOWN) {
                    v = EN.diff(v, segment);
                    continue;
                }
                throw new IllegalStateException();
            }
            this.segSum = EN.sum(h, new EastNorth(v.north(), -v.east()));
            this.heading = EN.polar(new EastNorth(0.0, 0.0), this.segSum);
        }
    }

    public static class Undo
    extends JosmAction {
        public Undo() {
            super(I18n.tr("Orthogonalize Shape / Undo", new Object[0]), "ortho", I18n.tr("Undo orthogonalization for certain nodes", new Object[0]), Shortcut.registerShortcut("tools:orthogonalizeUndo", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape / Undo", new Object[0])), 81, 5005), true, "action/orthogonalize/undo", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<Command> commands = new LinkedList<Command>();
            Collection sel = this.getLayerManager().getEditDataSet().getSelected();
            try {
                for (OsmPrimitive p : sel) {
                    if (!(p instanceof Node)) {
                        throw new InvalidUserInputException("selected object is not a node");
                    }
                    Node n = (Node)p;
                    if (!rememberMovements.containsKey(n)) continue;
                    EastNorth tmp = (EastNorth)rememberMovements.get(n);
                    commands.add(new MoveCommand((OsmPrimitive)n, -tmp.east(), -tmp.north()));
                    rememberMovements.remove(n);
                }
                if (commands.isEmpty()) {
                    throw new InvalidUserInputException("Commands are empty");
                }
                MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize / Undo", new Object[0]), commands));
            }
            catch (InvalidUserInputException ex) {
                Logging.debug(ex);
                new Notification(I18n.tr("Orthogonalize Shape / Undo<br>Please select nodes that were moved by the previous Orthogonalize Shape action!", new Object[0])).setIcon(1).show();
            }
        }

        @Override
        protected void updateEnabledState() {
            this.updateEnabledStateOnCurrentSelection();
        }

        @Override
        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
            this.updateEnabledStateOnModifiableSelection(selection);
        }
    }
}

