/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/LambdaWithSuspendModifierCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "hasFormOfSuspendModifierForLambda", "", "Lorg/jetbrains/kotlin/psi/Call;", "hasNoArgumentListButDanglingLambdas", "isInfixWithRightLambda", "referencedName", "", "frontend"})
public final class LambdaWithSuspendModifierCallChecker
implements CallChecker {
    public static final LambdaWithSuspendModifierCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Call call2;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        Call call3 = call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call3, "call");
        String callName = this.referencedName(call3);
        if (Intrinsics.areEqual(callName, "suspend") ^ true) {
            Object obj = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(obj, "descriptor");
            if (Intrinsics.areEqual(obj.getName().asString(), "suspend") ^ true) {
                return;
            }
        }
        Object obj = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(obj, "descriptor");
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(obj);
        if (Intrinsics.areEqual(fqName2, SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            if (!this.hasFormOfSuspendModifierForLambda(call2) || call2.getExplicitReceiver() != null) {
                context.getTrace().report(Errors.NON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND.on(reportOn));
            }
        } else if (this.hasFormOfSuspendModifierForLambda(call2)) {
            context.getTrace().report(Errors.MODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND.on(reportOn));
        }
    }

    private final boolean hasFormOfSuspendModifierForLambda(@NotNull Call $receiver) {
        return Intrinsics.areEqual(this.referencedName($receiver), "suspend") && !CallUtilKt.isCallableReference($receiver) && $receiver.getTypeArguments().isEmpty() && (this.hasNoArgumentListButDanglingLambdas($receiver) || this.isInfixWithRightLambda($receiver));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String referencedName(@NotNull Call $receiver) {
        KtExpression ktExpression = $receiver.getCalleeExpression();
        KtExpression ktExpression2 = ktExpression;
        if (ktExpression == null) return null;
        KtExpression $receiver$iv = ktExpression2;
        KtExpression ktExpression3 = $receiver$iv;
        if (!(ktExpression3 instanceof KtSimpleNameExpression)) {
            ktExpression3 = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression3;
        ktExpression2 = ktSimpleNameExpression;
        if (ktSimpleNameExpression == null) return null;
        String string = ktExpression2.getReferencedName();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNoArgumentListButDanglingLambdas(@NotNull Call $receiver) {
        KtValueArgumentList ktValueArgumentList = $receiver.getValueArgumentList();
        if ((ktValueArgumentList != null ? ktValueArgumentList.getLeftParenthesis() : null) != null) return false;
        List<? extends LambdaArgument> list2 = $receiver.getFunctionLiteralArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "functionLiteralArguments");
        Collection collection = list2;
        if (collection.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixWithRightLambda(@NotNull Call $receiver) {
        if (!CallResolverUtilKt.isInfixCall($receiver)) return false;
        KtElement $receiver$iv = $receiver.getCallElement();
        KtElement ktElement = $receiver$iv;
        if (!(ktElement instanceof KtBinaryExpression)) {
            ktElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
        if (!((ktBinaryExpression != null ? ktBinaryExpression.getRight() : null) instanceof KtLambdaExpression)) return false;
        return true;
    }

    private LambdaWithSuspendModifierCallChecker() {
    }

    static {
        LambdaWithSuspendModifierCallChecker lambdaWithSuspendModifierCallChecker;
        INSTANCE = lambdaWithSuspendModifierCallChecker = new LambdaWithSuspendModifierCallChecker();
    }
}

