/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import sbt.internal.io.MilliNative;

public final class WinMilli$
extends MilliNative<WinBase.FILETIME> {
    public static WinMilli$ MODULE$;

    static {
        new WinMilli$();
    }

    private WinNT.HANDLE getHandle(String lpFileName, int dwDesiredAccess, int dwShareMode) {
        WinNT.HANDLE hFile;
        WinNT.HANDLE hANDLE = hFile = Kernel32.INSTANCE.CreateFile(lpFileName, dwDesiredAccess, dwShareMode, null, 3, 0x2000000, null);
        WinNT.HANDLE hANDLE2 = WinBase.INVALID_HANDLE_VALUE;
        if (!(hANDLE != null ? !hANDLE.equals(hANDLE2) : hANDLE2 != null)) {
            int err = Kernel32.INSTANCE.GetLastError();
            if (err == 2 || err == 3) {
                throw new FileNotFoundException("Not found: " + lpFileName);
            }
            throw new IOException("CreateFile() failed with error " + Kernel32.INSTANCE.GetLastError());
        }
        return hFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WinBase.FILETIME getModifiedTimeNative(String filePath) {
        void var3_5;
        WinBase.FILETIME.ByReference byReference;
        WinNT.HANDLE hFile = this.getHandle(filePath, Integer.MIN_VALUE, 1);
        try {
            WinBase.FILETIME.ByReference modifiedTime = new WinBase.FILETIME.ByReference();
            if (!Kernel32.INSTANCE.GetFileTime(hFile, null, null, (WinBase.FILETIME)modifiedTime)) {
                throw new IOException("GetFileTime() failed with error " + Kernel32.INSTANCE.GetLastError() + " for file " + filePath);
            }
            byReference = modifiedTime;
        }
        finally {
            if (!Kernel32.INSTANCE.CloseHandle(hFile)) {
                throw new IOException("CloseHandle() after GetFileTime() failed with error " + Kernel32.INSTANCE.GetLastError() + " for file " + filePath);
            }
        }
        WinBase.FILETIME.ByReference mtime = byReference;
        return var3_5;
    }

    @Override
    public void setModifiedTimeNative(String filePath, WinBase.FILETIME fileTime) {
        WinNT.HANDLE hFile = this.getHandle(filePath, 256, 2);
        try {
            if (Kernel32.INSTANCE.SetFileTime(hFile, null, null, fileTime) == 0) {
                throw new IOException("SetFileTime() failed with error " + Kernel32.INSTANCE.GetLastError() + " for file " + filePath);
            }
        }
        finally {
            if (!Kernel32.INSTANCE.CloseHandle(hFile)) {
                throw new IOException("CloseHandle() after SetFileTime() failed with error " + Kernel32.INSTANCE.GetLastError() + " for file " + filePath);
            }
        }
    }

    @Override
    public long fromNative(WinBase.FILETIME mtimeNative) {
        return mtimeNative.toTime();
    }

    @Override
    public WinBase.FILETIME toNative(long mtime) {
        return new WinBase.FILETIME(new Date(mtime));
    }

    private WinMilli$() {
        MODULE$ = this;
    }
}

