import ll = require("../lowLevelAST");
import hl = require("../highLevelAST");
import hlimpl = require("../highLevelImpl");
import yaml = require("yaml-ast-parser");
import proxy = require("./LowLevelASTProxy");
import RamlWrapper = require("../artifacts/raml10parserapi");
import RamlWrapper08 = require("../artifacts/raml08parserapi");
import core = require("../wrapped-ast/parserCore");
import referencePatcher = require("./referencePatcher");
export declare function expandTraitsAndResourceTypes<T>(api: T): T;
export declare function expandLibraries(api: RamlWrapper.Api): RamlWrapper.Api;
export declare function expandLibrary(lib: RamlWrapper.Library): RamlWrapper.Library;
export declare function mergeAPIs(masterUnit: ll.ICompilationUnit, extensionsAndOverlays: ll.ICompilationUnit[], mergeMode: hlimpl.OverlayMergeMode): hl.IHighLevelNode;
export declare class TraitsAndResourceTypesExpander {
    private hasGlobalTraits;
    private hasGlobalResourceTypes;
    private ramlVersion;
    expandTraitsAndResourceTypes(api: RamlWrapper.Api | RamlWrapper08.Api, rp?: referencePatcher.ReferencePatcher, forceProxy?: boolean): RamlWrapper.Api | RamlWrapper08.Api;
    init(hlNode: hl.IHighLevelNode): void;
    expandHighLevelNode(hlNode: hl.IHighLevelNode, rp: referencePatcher.ReferencePatcher, api: core.BasicNodeImpl, initTypes?: boolean): RamlWrapper.Api | RamlWrapper08.Api;
    private getTemplate<T>(name, context, cache, globalList);
    createHighLevelNode(_api: hl.IHighLevelNode, merge?: boolean, rp?: referencePatcher.ReferencePatcher, forceProxy?: boolean): hlimpl.ASTNodeImpl;
    private processResource(resource, _nodes?);
    private mergeBodiesForMethod(method);
    private mergeBodies(bodyNode, defaultMediaType);
    private collectResourceData(original, obj, arr?, transformer?, nodesChain?, occuredResourceTypes?);
    private extractTraits(obj, _transformer, nodesChain, occuredTraits?);
    private readGenerictData(r, obj, context, template, transformer, unitsChain?);
}
export declare class LibraryExpander {
    expandLibraries(_api: RamlWrapper.Api): RamlWrapper.Api;
    expandLibrary(_lib: RamlWrapper.Library): RamlWrapper.Library;
    processNode(rp: referencePatcher.ReferencePatcher, hlNode: hl.IHighLevelNode): void;
}
export declare function toUnits(node: hl.IParseResult): ll.ICompilationUnit[];
export declare function getTransformNames(): string[];
export declare function getTransformersForOccurence(occurence: string): any[];
export declare class ValueTransformer implements proxy.ValueTransformer {
    templateKind: string;
    templateName: string;
    unitsChain: ll.ICompilationUnit[];
    scalarParamValues: {
        [key: string]: string;
    };
    scalarParams: {
        [key: string]: ll.ILowLevelASTNode;
    };
    structuredParams: {
        [key: string]: ll.ILowLevelASTNode;
    };
    vDelegate: ValueTransformer;
    constructor(templateKind: string, templateName: string, unitsChain: ll.ICompilationUnit[], scalarParamValues?: {
        [key: string]: string;
    }, scalarParams?: {
        [key: string]: ll.ILowLevelASTNode;
    }, structuredParams?: {
        [key: string]: ll.ILowLevelASTNode;
    }, vDelegate?: ValueTransformer);
    transform(obj: any, toString?: boolean, doBreak?: () => boolean, callback?: (obj: any, transformer: DefaultTransformer) => any): {
        value: any;
        errors: hl.ValidationIssue[];
    };
    private paramUpperBound(str, pos);
    children(node: ll.ILowLevelASTNode): ll.ILowLevelASTNode[];
    valueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    anchorValueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    resolvedValueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    includePath(node: ll.ILowLevelASTNode): string;
    substitutionNode(node: ll.ILowLevelASTNode, chain?: ll.ILowLevelASTNode[], inKey?: boolean): any;
    paramNodesChain(node: ll.ILowLevelASTNode, inKey: boolean): ll.ILowLevelASTNode[];
    private paramName(node, inKey);
    definingUnitSequence(str: string): ll.ICompilationUnit[];
    _definingUnitSequence(str: string): ll.ICompilationUnit[];
}
export declare class DefaultTransformer extends ValueTransformer {
    constructor(owner: RamlWrapper.ResourceBase | RamlWrapper.MethodBase | RamlWrapper08.Resource | RamlWrapper08.MethodBase, delegate: ValueTransformer, unitsChain: ll.ICompilationUnit[]);
    owner: RamlWrapper.ResourceBase | RamlWrapper.MethodBase | RamlWrapper08.Resource | RamlWrapper08.MethodBase;
    delegate: ValueTransformer;
    transform(obj: any, toString?: boolean, doContinue?: () => boolean, callback?: (obj: any, transformer: DefaultTransformer) => any): any;
    private initParams();
    children(node: ll.ILowLevelASTNode): ll.ILowLevelASTNode[];
    valueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    includePath(node: ll.ILowLevelASTNode): string;
    anchorValueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    resolvedValueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    substitutionNode(node: ll.ILowLevelASTNode, chain?: ll.ILowLevelASTNode[], inKey?: boolean): any;
    _definingUnitSequence(str: string): ll.ICompilationUnit[];
}
export declare function parseMediaType(str: string): any;
