/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.AbstractPDFFontStream;
import org.apache.fop.pdf.PDFName;

public class PDFCFFStreamType0C
extends AbstractPDFFontStream {
    private byte[] cffData;
    private boolean fullEmbed;

    public PDFCFFStreamType0C(boolean fullEmbed) {
        this.fullEmbed = fullEmbed;
    }

    @Override
    protected int getSizeHint() throws IOException {
        if (this.cffData != null) {
            return this.cffData.length;
        }
        return 0;
    }

    @Override
    protected void outputRawStreamData(OutputStream out) throws IOException {
        out.write(this.cffData);
    }

    @Override
    protected void populateStreamDict(Object lengthEntry) {
        String type = this.fullEmbed ? "OpenType" : "CIDFontType0C";
        this.put("Subtype", new PDFName(type));
        super.populateStreamDict(lengthEntry);
    }

    public void setData(byte[] data, int size) throws IOException {
        this.cffData = new byte[size];
        System.arraycopy(data, 0, this.cffData, 0, size);
    }
}

