/*
 * Decompiled with CFR 0.152.
 */
package IceDiscovery;

import Ice.AMD_LocatorRegistry_setAdapterDirectProxy;
import Ice.AMD_LocatorRegistry_setReplicatedAdapterDirectProxy;
import Ice.AMD_LocatorRegistry_setServerProcessProxy;
import Ice.Communicator;
import Ice.Current;
import Ice.Endpoint;
import Ice.Holder;
import Ice.Identity;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.ProcessPrx;
import Ice._LocatorRegistryDisp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LocatorRegistryI
extends _LocatorRegistryDisp {
    final ObjectPrx _wellKnownProxy;
    final Map<String, ObjectPrx> _adapters = new HashMap<String, ObjectPrx>();
    final Map<String, Set<String>> _replicaGroups = new HashMap<String, Set<String>>();

    public LocatorRegistryI(Communicator com) {
        this._wellKnownProxy = com.stringToProxy("p").ice_locator(null).ice_router(null).ice_collocationOptimized(true);
    }

    @Override
    public synchronized void setAdapterDirectProxy_async(AMD_LocatorRegistry_setAdapterDirectProxy cb, String adapterId, ObjectPrx proxy, Current current) {
        if (proxy != null) {
            this._adapters.put(adapterId, proxy);
        } else {
            this._adapters.remove(adapterId);
        }
        cb.ice_response();
    }

    @Override
    public synchronized void setReplicatedAdapterDirectProxy_async(AMD_LocatorRegistry_setReplicatedAdapterDirectProxy cb, String adapterId, String replicaGroupId, ObjectPrx proxy, Current current) {
        if (proxy != null) {
            this._adapters.put(adapterId, proxy);
            Set<String> s = this._replicaGroups.get(replicaGroupId);
            if (s == null) {
                s = new HashSet<String>();
                this._replicaGroups.put(replicaGroupId, s);
            }
            s.add(adapterId);
        } else {
            this._adapters.remove(adapterId);
            Set<String> s = this._replicaGroups.get(replicaGroupId);
            if (s != null) {
                s.remove(adapterId);
                if (s.isEmpty()) {
                    this._replicaGroups.remove(adapterId);
                }
            }
        }
        cb.ice_response();
    }

    @Override
    public void setServerProcessProxy_async(AMD_LocatorRegistry_setServerProcessProxy cb, String serverId, ProcessPrx process, Current current) {
        cb.ice_response();
    }

    synchronized ObjectPrx findObject(Identity id) {
        if (id.name.length() == 0) {
            return null;
        }
        ObjectPrx prx = this._wellKnownProxy.ice_identity(id);
        ArrayList<String> adapterIds = new ArrayList<String>();
        for (String a : this._replicaGroups.keySet()) {
            try {
                prx.ice_adapterId(a).ice_ping();
                adapterIds.add(a);
            }
            catch (LocalException localException) {}
        }
        if (adapterIds.isEmpty()) {
            for (String a : this._adapters.keySet()) {
                try {
                    prx.ice_adapterId(a).ice_ping();
                    adapterIds.add(a);
                }
                catch (LocalException localException) {}
            }
        }
        if (adapterIds.isEmpty()) {
            return null;
        }
        Collections.shuffle(adapterIds);
        return prx.ice_adapterId((String)adapterIds.get(0));
    }

    synchronized ObjectPrx findAdapter(String adapterId, Holder<Boolean> isReplicaGroup) {
        ObjectPrx proxy = this._adapters.get(adapterId);
        if (proxy != null) {
            isReplicaGroup.value = false;
            return proxy;
        }
        Set<String> s = this._replicaGroups.get(adapterId);
        if (s != null) {
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            ObjectPrx prx = null;
            for (String a : s) {
                proxy = this._adapters.get(a);
                if (proxy == null) continue;
                if (prx == null) {
                    prx = proxy;
                }
                endpoints.addAll(Arrays.asList(proxy.ice_getEndpoints()));
            }
            if (prx != null) {
                isReplicaGroup.value = true;
                return prx.ice_endpoints(endpoints.toArray(new Endpoint[endpoints.size()]));
            }
        }
        isReplicaGroup.value = false;
        return null;
    }
}

