// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either via the {@link Registry}
 * object or via the registry admin <tt>SessionManager</tt> object.
 * @see Registry
 **/
public interface AdminSession extends com.zeroc.Glacier2.Session
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param current The Current object for the invocation.
     * @see Registry#getSessionTimeout
     **/
    void keepAlive(com.zeroc.Ice.Current current);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param current The Current object for the invocation.
     * @return The admin interface proxy.
     **/
    AdminPrx getAdmin(com.zeroc.Ice.Current current);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param current The Current object for the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     **/
    com.zeroc.Ice.ObjectPrx getAdminCallbackTemplate(com.zeroc.Ice.Current current);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param current The Current object for the invocation.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     **/
    void setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, com.zeroc.Ice.Current current)
        throws ObserverAlreadyRegisteredException;

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param current The Current object for the invocation.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     **/
    void setObserversByIdentity(com.zeroc.Ice.Identity registryObs, com.zeroc.Ice.Identity nodeObs, com.zeroc.Ice.Identity appObs, com.zeroc.Ice.Identity adptObs, com.zeroc.Ice.Identity objObs, com.zeroc.Ice.Current current)
        throws ObserverAlreadyRegisteredException;

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param current The Current object for the invocation.
     * @return The current serial.
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     **/
    int startUpdate(com.zeroc.Ice.Current current)
        throws AccessDeniedException;

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     **/
    void finishUpdate(com.zeroc.Ice.Current current)
        throws AccessDeniedException;

    /**
     * Get the name of the registry replica hosting this session.
     * @param current The Current object for the invocation.
     * @return The replica name of the registry.
     **/
    String getReplicaName(com.zeroc.Ice.Current current);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    FileIteratorPrx openServerLog(String id, String path, int count, com.zeroc.Ice.Current current)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    FileIteratorPrx openServerStdErr(String id, int count, com.zeroc.Ice.Current current)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    FileIteratorPrx openServerStdOut(String id, int count, com.zeroc.Ice.Current current)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     **/
    FileIteratorPrx openNodeStdErr(String name, int count, com.zeroc.Ice.Current current)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     **/
    FileIteratorPrx openNodeStdOut(String name, int count, com.zeroc.Ice.Current current)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     **/
    FileIteratorPrx openRegistryStdErr(String name, int count, com.zeroc.Ice.Current current)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     **/
    FileIteratorPrx openRegistryStdOut(String name, int count, com.zeroc.Ice.Current current)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    static final String[] _iceIds =
    {
        "::Glacier2::Session",
        "::Ice::Object",
        "::IceGrid::AdminSession"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::AdminSession";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_keepAlive(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        obj.keepAlive(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAdmin(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        AdminPrx ret = obj.getAdmin(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAdminCallbackTemplate(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        com.zeroc.Ice.ObjectPrx ret = obj.getAdminCallbackTemplate(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_setObservers(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        RegistryObserverPrx iceP_registryObs;
        NodeObserverPrx iceP_nodeObs;
        ApplicationObserverPrx iceP_appObs;
        AdapterObserverPrx iceP_adptObs;
        ObjectObserverPrx iceP_objObs;
        iceP_registryObs = RegistryObserverPrx.uncheckedCast(istr.readProxy());
        iceP_nodeObs = NodeObserverPrx.uncheckedCast(istr.readProxy());
        iceP_appObs = ApplicationObserverPrx.uncheckedCast(istr.readProxy());
        iceP_adptObs = AdapterObserverPrx.uncheckedCast(istr.readProxy());
        iceP_objObs = ObjectObserverPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        obj.setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_setObserversByIdentity(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity iceP_registryObs;
        com.zeroc.Ice.Identity iceP_nodeObs;
        com.zeroc.Ice.Identity iceP_appObs;
        com.zeroc.Ice.Identity iceP_adptObs;
        com.zeroc.Ice.Identity iceP_objObs;
        iceP_registryObs = com.zeroc.Ice.Identity.ice_read(istr);
        iceP_nodeObs = com.zeroc.Ice.Identity.ice_read(istr);
        iceP_appObs = com.zeroc.Ice.Identity.ice_read(istr);
        iceP_adptObs = com.zeroc.Ice.Identity.ice_read(istr);
        iceP_objObs = com.zeroc.Ice.Identity.ice_read(istr);
        inS.endReadParams();
        obj.setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_startUpdate(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        int ret = obj.startUpdate(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_finishUpdate(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.finishUpdate(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getReplicaName(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getReplicaName(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_openServerLog(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        String iceP_path;
        int iceP_count;
        iceP_id = istr.readString();
        iceP_path = istr.readString();
        iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openServerLog(iceP_id, iceP_path, iceP_count, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_openServerStdErr(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        int iceP_count;
        iceP_id = istr.readString();
        iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openServerStdErr(iceP_id, iceP_count, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_openServerStdOut(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        int iceP_count;
        iceP_id = istr.readString();
        iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openServerStdOut(iceP_id, iceP_count, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_openNodeStdErr(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        int iceP_count;
        iceP_name = istr.readString();
        iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openNodeStdErr(iceP_name, iceP_count, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_openNodeStdOut(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        int iceP_count;
        iceP_name = istr.readString();
        iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openNodeStdOut(iceP_name, iceP_count, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_openRegistryStdErr(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        int iceP_count;
        iceP_name = istr.readString();
        iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openRegistryStdErr(iceP_name, iceP_count, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_openRegistryStdOut(AdminSession obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        int iceP_count;
        iceP_name = istr.readString();
        iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openRegistryStdOut(iceP_name, iceP_count, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    final static String[] _iceOps =
    {
        "destroy",
        "finishUpdate",
        "getAdmin",
        "getAdminCallbackTemplate",
        "getReplicaName",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "keepAlive",
        "openNodeStdErr",
        "openNodeStdOut",
        "openRegistryStdErr",
        "openRegistryStdOut",
        "openServerLog",
        "openServerStdErr",
        "openServerStdOut",
        "setObservers",
        "setObserversByIdentity",
        "startUpdate"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return com.zeroc.Glacier2.Session._iceD_destroy(this, in, current);
            }
            case 1:
            {
                return _iceD_finishUpdate(this, in, current);
            }
            case 2:
            {
                return _iceD_getAdmin(this, in, current);
            }
            case 3:
            {
                return _iceD_getAdminCallbackTemplate(this, in, current);
            }
            case 4:
            {
                return _iceD_getReplicaName(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 7:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 8:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 9:
            {
                return _iceD_keepAlive(this, in, current);
            }
            case 10:
            {
                return _iceD_openNodeStdErr(this, in, current);
            }
            case 11:
            {
                return _iceD_openNodeStdOut(this, in, current);
            }
            case 12:
            {
                return _iceD_openRegistryStdErr(this, in, current);
            }
            case 13:
            {
                return _iceD_openRegistryStdOut(this, in, current);
            }
            case 14:
            {
                return _iceD_openServerLog(this, in, current);
            }
            case 15:
            {
                return _iceD_openServerStdErr(this, in, current);
            }
            case 16:
            {
                return _iceD_openServerStdOut(this, in, current);
            }
            case 17:
            {
                return _iceD_setObservers(this, in, current);
            }
            case 18:
            {
                return _iceD_setObserversByIdentity(this, in, current);
            }
            case 19:
            {
                return _iceD_startUpdate(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
