/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationDrivenModelRuleExtractor<T extends Annotation>
implements MethodModelRuleExtractor {
    private static final ModelType<Void> VOID = ModelType.of(Void.TYPE);
    private final Class<T> annotationType;

    protected AbstractAnnotationDrivenModelRuleExtractor() {
        Class annotationType;
        this.annotationType = annotationType = new TypeToken<T>(this.getClass()){}.getRawType();
    }

    public Class<T> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public boolean isSatisfiedBy(MethodRuleDefinition<?, ?> ruleDefinition) {
        return ruleDefinition.isAnnotationPresent(this.annotationType);
    }

    @Override
    public String getDescription() {
        return String.format("annotated with @%s", this.annotationType.getSimpleName());
    }

    protected void validateIsVoidMethod(MethodRuleDefinition<?, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        if (!this.isVoidMethod(ruleDefinition)) {
            problems.add(ruleDefinition, "A method " + this.getDescription() + " must have void return type.");
        }
    }

    protected boolean isVoidMethod(MethodRuleDefinition<?, ?> ruleDefinition) {
        return ruleDefinition.getReturnType().equals(VOID);
    }
}

