/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.Controller;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketBuilder;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketController;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.Reactor;

class SocketTransport
implements Transport {
    private PacketBuilder builder;
    private SocketChannel channel;
    private Controller writer;
    private Socket socket;
    private boolean closed;

    public SocketTransport(Socket socket, Reactor reactor) throws IOException {
        this(socket, reactor, 20480);
    }

    public SocketTransport(Socket socket, Reactor reactor, int limit) throws IOException {
        this(socket, reactor, limit, 3);
    }

    public SocketTransport(Socket socket, Reactor reactor, int limit, int queue) throws IOException {
        this.writer = new SocketController(socket, reactor, limit);
        this.builder = new PacketBuilder(queue);
        this.channel = socket.getChannel();
        this.socket = socket;
    }

    public Map getAttributes() {
        return this.socket.getAttributes();
    }

    public SSLEngine getEngine() {
        return this.socket.getEngine();
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public int read(ByteBuffer data) throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        return this.channel.read(data);
    }

    public void write(ByteBuffer data) throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        Packet packet = this.builder.build(data);
        while (packet != null) {
            if (!this.closed) {
                this.writer.write(packet);
            }
            packet = this.builder.build(data);
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        Packet packet = this.builder.build();
        if (packet != null) {
            this.writer.write(packet);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            Packet packet = this.builder.build();
            if (packet != null) {
                this.writer.write(packet);
            }
            this.writer.close();
            this.closed = true;
        }
    }
}

